/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.retriever;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.ScheduledEventUser;
import discord4j.core.object.automod.AutoModRule;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.GuildSticker;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.object.entity.StageInstance;
import discord4j.core.object.entity.ThreadMember;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.retriever.EntityRetriever;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.AutoModRuleData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildFields;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.GuildScheduledEventUserData;
import discord4j.discordjson.json.GuildUpdateData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleDataFields;
import discord4j.discordjson.json.StageInstanceData;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.json.UserData;
import discord4j.rest.RestClient;
import discord4j.rest.util.PaginationUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RestEntityRetriever
implements EntityRetriever {
    private final GatewayDiscordClient gateway;
    private final RestClient rest;

    public RestEntityRetriever(GatewayDiscordClient gateway) {
        this.gateway = gateway;
        this.rest = gateway.rest();
    }

    @Override
    public Mono<Channel> getChannelById(Snowflake channelId) {
        return this.rest.getChannelService().getChannel(channelId.asLong()).map(data -> EntityUtil.getChannel(this.gateway, data));
    }

    @Override
    public Mono<Guild> getGuildById(Snowflake guildId) {
        return this.rest.getGuildService().getGuild(guildId.asLong()).map(this::toGuildData).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<GuildSticker> getGuildStickerById(Snowflake guildId, Snowflake stickerId) {
        return this.rest.getStickerService().getGuildSticker(guildId.asLong(), stickerId.asLong()).map(data -> new GuildSticker(this.gateway, (StickerData)data, guildId.asLong()));
    }

    @Override
    public Mono<GuildEmoji> getGuildEmojiById(Snowflake guildId, Snowflake emojiId) {
        return this.rest.getEmojiService().getGuildEmoji(guildId.asLong(), emojiId.asLong()).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, guildId.asLong()));
    }

    @Override
    public Mono<Member> getMemberById(Snowflake guildId, Snowflake userId) {
        return this.rest.getGuildService().getGuildMember(guildId.asLong(), userId.asLong()).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong()));
    }

    @Override
    public Mono<Message> getMessageById(Snowflake channelId, Snowflake messageId) {
        return this.rest.getChannelService().getMessage(channelId.asLong(), messageId.asLong()).map(data -> new Message(this.gateway, (MessageData)data));
    }

    @Override
    public Mono<Role> getRoleById(Snowflake guildId, Snowflake roleId) {
        return this.rest.getGuildService().getGuildRoles(guildId.asLong()).filter(response -> response.id().asString().equals(roleId.asString())).singleOrEmpty().map(data -> new Role(this.gateway, (RoleData)data, guildId.asLong()));
    }

    @Override
    public Mono<User> getUserById(Snowflake userId) {
        return this.rest.getUserService().getUser(userId.asLong()).map(data -> new User(this.gateway, (UserData)data));
    }

    @Override
    public Flux<Guild> getGuilds() {
        Function makeRequest = params -> this.rest.getUserService().getCurrentUserGuilds((Map<String, Object>)params);
        return PaginationUtil.paginateAfter(makeRequest, data -> Snowflake.asLong(data.id()), 0L, 100).map(GuildFields::id).flatMap(id -> this.rest.getGuildService().getGuild(Snowflake.asLong(id))).map(this::toGuildData).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<User> getSelf() {
        return this.rest.getUserService().getCurrentUser().map(data -> new User(this.gateway, (UserData)data));
    }

    @Override
    public Mono<Member> getSelfMember(Snowflake guildId) {
        return this.rest.getSelfMember(guildId).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong()));
    }

    @Override
    public Flux<Member> getGuildMembers(Snowflake guildId) {
        Function doRequest = params -> this.rest.getGuildService().getGuildMembers(guildId.asLong(), (Map<String, Object>)params);
        return PaginationUtil.paginateAfter(doRequest, data -> Snowflake.asLong(data.user().id()), 0L, 100).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong()));
    }

    @Override
    public Flux<GuildChannel> getGuildChannels(Snowflake guildId) {
        return this.rest.getGuildService().getGuildChannels(guildId.asLong()).map(data -> EntityUtil.getChannel(this.gateway, data)).ofType(GuildChannel.class);
    }

    @Override
    public Flux<Role> getGuildRoles(Snowflake guildId) {
        return this.rest.getGuildService().getGuildRoles(guildId.asLong()).map(data -> new Role(this.gateway, (RoleData)data, guildId.asLong()));
    }

    @Override
    public Flux<GuildEmoji> getGuildEmojis(Snowflake guildId) {
        return this.rest.getEmojiService().getGuildEmojis(guildId.asLong()).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, guildId.asLong()));
    }

    @Override
    public Flux<GuildSticker> getGuildStickers(Snowflake guildId) {
        return this.rest.getStickerService().getGuildStickers(guildId.asLong()).map(data -> new GuildSticker(this.gateway, (StickerData)data, guildId.asLong()));
    }

    @Override
    public Mono<ThreadMember> getThreadMemberById(Snowflake threadId, Snowflake userId) {
        return this.rest.getChannelService().getThreadMember(threadId.asLong(), userId.asLong()).map(data -> new ThreadMember(this.gateway, (ThreadMemberData)data));
    }

    @Override
    public Flux<ThreadMember> getThreadMembers(Snowflake threadId) {
        return this.rest.getChannelService().listThreadMembers(threadId.asLong()).map(data -> new ThreadMember(this.gateway, (ThreadMemberData)data));
    }

    @Override
    public Flux<AutoModRule> getGuildAutoModRules(Snowflake guildId) {
        return this.rest.getAutoModService().getAutoModRules(guildId.asLong()).map(data -> new AutoModRule(this.gateway, (AutoModRuleData)data));
    }

    @Override
    public Mono<ScheduledEvent> getScheduledEventById(Snowflake guildId, Snowflake eventId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("with_user_count", true);
        return this.rest.getGuildService().getScheduledEvent(guildId.asLong(), eventId.asLong(), queryParams).map(data -> new ScheduledEvent(this.gateway, (GuildScheduledEventData)data));
    }

    @Override
    public Flux<ScheduledEvent> getScheduledEvents(Snowflake guildId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("with_user_count", true);
        return this.rest.getGuildService().getScheduledEvents(guildId.asLong(), queryParams).map(data -> new ScheduledEvent(this.gateway, (GuildScheduledEventData)data));
    }

    @Override
    public Flux<ScheduledEventUser> getScheduledEventUsers(Snowflake guildId, Snowflake eventId) {
        Function doRequest = params -> {
            params.put("with_member", true);
            return this.rest.getGuildService().getScheduledEventUsers(guildId.asLong(), eventId.asLong(), (Map<String, Object>)params);
        };
        return PaginationUtil.paginateAfter(doRequest, data -> Snowflake.asLong(data.user().id()), 0L, 100).map(data -> new ScheduledEventUser(this.gateway, (GuildScheduledEventUserData)data, guildId));
    }

    private GuildData toGuildData(GuildUpdateData guild) {
        return GuildData.builder().from(guild).roles(guild.roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(guild.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).channels(Collections.emptyList()).members(Collections.emptyList()).joinedAt("").large(false).memberCount(0).build();
    }

    @Override
    public Mono<StageInstance> getStageInstanceByChannelId(Snowflake channelId) {
        return this.rest.getStageInstanceService().getStageInstance(channelId.asLong()).map(data -> new StageInstance(this.gateway, (StageInstanceData)data));
    }
}

