/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.CategoryCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="CategoryCreateMonoGenerator", generator="Immutables")
public final class CategoryCreateMono
extends CategoryCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final Integer position_value;
    private final boolean position_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private CategoryCreateMono(String name, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible position$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.initShim = null;
    }

    private CategoryCreateMono(@Nullable String reason, String name, Possible<Integer> position, Possible<List<PermissionOverwrite>> permissionOverwrites, Guild guild) {
        this.reason = reason;
        this.name = name;
        Possible<Integer> position$impl = position;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        this.guild = guild;
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final CategoryCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new CategoryCreateMono(value, this.name, this.position(), this.permissionOverwrites(), this.guild);
    }

    public final CategoryCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new CategoryCreateMono(this.reason, newValue, this.position(), this.permissionOverwrites(), this.guild);
    }

    public CategoryCreateMono withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new CategoryCreateMono(this.reason, this.name, newValue, this.permissionOverwrites(), this.guild);
    }

    public CategoryCreateMono withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new CategoryCreateMono(this.reason, this.name, newValue, this.permissionOverwrites(), this.guild);
    }

    public CategoryCreateMono withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new CategoryCreateMono(this.reason, this.name, this.position(), newValue, this.guild);
    }

    public CategoryCreateMono withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new CategoryCreateMono(this.reason, this.name, this.position(), newValue, this.guild);
    }

    @SafeVarargs
    public final CategoryCreateMono withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return new CategoryCreateMono(this.reason, this.name, this.position(), newValue, this.guild);
    }

    public final CategoryCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new CategoryCreateMono(this.reason, this.name, this.position(), this.permissionOverwrites(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CategoryCreateMono && this.equalTo(0, (CategoryCreateMono)another);
    }

    private boolean equalTo(int synthetic, CategoryCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.position().equals(another.position()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.guild.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "CategoryCreateMono{reason=" + this.reason + ", name=" + this.name + ", position=" + this.position().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", guild=" + this.guild + "}";
    }

    public static CategoryCreateMono of(String name, Guild guild) {
        return new CategoryCreateMono(name, guild);
    }

    static CategoryCreateMono copyOf(CategoryCreateMonoGenerator instance) {
        if (instance instanceof CategoryCreateMono) {
            return (CategoryCreateMono)instance;
        }
        return CategoryCreateMono.of(instance.name(), instance.guild()).withReason(instance.reason()).withPosition(instance.position()).withPermissionOverwrites(instance.permissionOverwrites());
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    @Generated(from="CategoryCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build CategoryCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

