/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.GuildCreateFields;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.RoleCreateSpec;
import discord4j.core.spec.RoleCreateSpecGenerator;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.GuildCreateRequest;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import reactor.util.annotation.Nullable;

@Value.Immutable
interface GuildCreateSpecGenerator
extends Spec<GuildCreateRequest> {
    public String name();

    public Region region();

    @Nullable
    public Image icon();

    @Value.Default
    default public Guild.VerificationLevel verificationLevel() {
        return Guild.VerificationLevel.NONE;
    }

    @Value.Default
    default public Guild.NotificationLevel defaultMessageNotificationLevel() {
        return Guild.NotificationLevel.ALL_MESSAGES;
    }

    @Value.Default
    default public Guild.ContentFilterLevel explicitContentFilter() {
        return Guild.ContentFilterLevel.DISABLED;
    }

    @Value.Default
    default public List<RoleCreateSpec> roles() {
        return Collections.emptyList();
    }

    @Nullable
    public RoleCreateSpec everyoneRole();

    @Value.Default
    default public List<GuildCreateFields.PartialChannel> channels() {
        return Collections.emptyList();
    }

    @Override
    default public GuildCreateRequest asRequest() {
        List roles = this.roles().stream().map(RoleCreateSpecGenerator::asRequest).collect(Collectors.toCollection(ArrayList::new));
        RoleCreateSpec everyoneRole = this.everyoneRole();
        if (everyoneRole != null) {
            roles.add(0, everyoneRole.asRequest());
        }
        List channels = this.channels().stream().map(GuildCreateFields.PartialChannel::asRequest).collect(Collectors.toList());
        return GuildCreateRequest.builder().name(this.name()).region(this.region().getId()).icon(InternalSpecUtils.mapNullable(this.icon(), Image::getDataUri)).verificationLevel(this.verificationLevel().getValue()).defaultMessageNotifications(this.defaultMessageNotificationLevel().getValue()).explicitContentFilter(this.explicitContentFilter().getValue()).roles(roles).channels(channels).build();
    }
}

