/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.spec.GuildPruneCountSpecGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildPruneCountSpecGenerator", generator="Immutables")
public final class GuildPruneCountSpec
implements GuildPruneCountSpecGenerator {
    private final Integer days;
    @Nullable
    private final Set<Snowflake> roles;

    private GuildPruneCountSpec(Integer days) {
        this.days = Objects.requireNonNull(days, "days");
        this.roles = null;
    }

    private GuildPruneCountSpec(Integer days, @Nullable Set<Snowflake> roles) {
        this.days = days;
        this.roles = roles;
    }

    @Override
    public Integer days() {
        return this.days;
    }

    @Override
    @Nullable
    public Set<Snowflake> roles() {
        return this.roles;
    }

    public final GuildPruneCountSpec withDays(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "days");
        if (this.days.equals(newValue)) {
            return this;
        }
        return new GuildPruneCountSpec(newValue, this.roles);
    }

    public final GuildPruneCountSpec withRoles(Snowflake ... elements) {
        if (elements == null) {
            return new GuildPruneCountSpec(this.days, null);
        }
        Set<Snowflake> newValue = Arrays.asList(elements) == null ? null : GuildPruneCountSpec.createUnmodifiableSet(GuildPruneCountSpec.createSafeList(Arrays.asList(elements), true, false));
        return new GuildPruneCountSpec(this.days, newValue);
    }

    public final GuildPruneCountSpec withRoles(@Nullable Iterable<? extends Snowflake> elements) {
        if (this.roles == elements) {
            return this;
        }
        Set<Snowflake> newValue = elements == null ? null : GuildPruneCountSpec.createUnmodifiableSet(GuildPruneCountSpec.createSafeList(elements, true, false));
        return new GuildPruneCountSpec(this.days, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildPruneCountSpec && this.equalTo(0, (GuildPruneCountSpec)another);
    }

    private boolean equalTo(int synthetic, GuildPruneCountSpec another) {
        return this.days.equals(another.days) && Objects.equals(this.roles, another.roles);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.days.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.roles);
        return h2;
    }

    public String toString() {
        return "GuildPruneCountSpec{days=" + this.days + ", roles=" + this.roles + "}";
    }

    public static GuildPruneCountSpec of(Integer days) {
        return new GuildPruneCountSpec(days);
    }

    static GuildPruneCountSpec copyOf(GuildPruneCountSpecGenerator instance) {
        if (instance instanceof GuildPruneCountSpec) {
            return (GuildPruneCountSpec)instance;
        }
        return GuildPruneCountSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="GuildPruneCountSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DAYS = 1L;
        private long initBits = 1L;
        private Integer days;
        private List<Snowflake> roles = null;

        private Builder() {
        }

        public final Builder from(GuildPruneCountSpec instance) {
            return this.from((GuildPruneCountSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GuildPruneCountSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.days(instance.days());
            Set<Snowflake> rolesValue = instance.roles();
            if (rolesValue != null) {
                this.addAllRoles(rolesValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder days(Integer days) {
            this.days = Objects.requireNonNull(days, "days");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRole(Snowflake element) {
            if (this.roles == null) {
                this.roles = new ArrayList<Snowflake>();
            }
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(Snowflake ... elements) {
            if (this.roles == null) {
                this.roles = new ArrayList<Snowflake>();
            }
            for (Snowflake element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(@Nullable Iterable<? extends Snowflake> elements) {
            if (elements == null) {
                this.roles = null;
                return this;
            }
            this.roles = new ArrayList<Snowflake>();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<? extends Snowflake> elements) {
            Objects.requireNonNull(elements, "roles element");
            if (this.roles == null) {
                this.roles = new ArrayList<Snowflake>();
            }
            for (Snowflake snowflake : elements) {
                this.roles.add(Objects.requireNonNull(snowflake, "roles element"));
            }
            return this;
        }

        public GuildPruneCountSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GuildPruneCountSpec(this.days, this.roles == null ? null : GuildPruneCountSpec.createUnmodifiableSet(this.roles));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("days");
            }
            return "Cannot build GuildPruneCountSpec, some of required attributes are not set " + attributes;
        }
    }
}

