/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.WebhookCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="WebhookCreateSpecGenerator", generator="Immutables")
public final class WebhookCreateSpec
implements WebhookCreateSpecGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final Image avatar_value;
    private final boolean avatar_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private WebhookCreateSpec(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.reason = null;
        Possible avatar$impl = Possible.absent();
        this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    private WebhookCreateSpec(@Nullable String reason, String name, Possible<Optional<Image>> avatar) {
        this.reason = reason;
        this.name = name;
        Possible avatar$impl = avatar;
        this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Optional<Image>> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.avatar_value));
    }

    public final WebhookCreateSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new WebhookCreateSpec(value, this.name, this.avatar());
    }

    public final WebhookCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new WebhookCreateSpec(this.reason, newValue, this.avatar());
    }

    public WebhookCreateSpec withAvatar(Possible<Optional<Image>> value) {
        Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
        return new WebhookCreateSpec(this.reason, this.name, newValue);
    }

    @Deprecated
    public WebhookCreateSpec withAvatar(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return new WebhookCreateSpec(this.reason, this.name, newValue);
    }

    public WebhookCreateSpec withAvatarOrNull(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return new WebhookCreateSpec(this.reason, this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookCreateSpec && this.equalTo(0, (WebhookCreateSpec)another);
    }

    private boolean equalTo(int synthetic, WebhookCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.avatar().equals(another.avatar());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.avatar().hashCode();
        return h2;
    }

    public String toString() {
        return "WebhookCreateSpec{reason=" + this.reason + ", name=" + this.name + ", avatar=" + this.avatar().toString() + "}";
    }

    public static WebhookCreateSpec of(String name) {
        return new WebhookCreateSpec(name);
    }

    static WebhookCreateSpec copyOf(WebhookCreateSpecGenerator instance) {
        if (instance instanceof WebhookCreateSpec) {
            return (WebhookCreateSpec)instance;
        }
        return WebhookCreateSpec.builder().from(instance).build();
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public Image avatarOrElse(Image defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebhookCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookCreateSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="WebhookCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<Optional<Image>> avatar_possible = Possible.absent();
        private String reason;
        private String name;

        private Builder() {
        }

        public final Builder from(WebhookCreateSpec instance) {
            return this.from((WebhookCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(WebhookCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.avatar(instance.avatar());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avatar(Possible<Optional<Image>> value) {
            this.avatar_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder avatar(@Nullable Image value) {
            this.avatar_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avatarOrNull(@Nullable Image value) {
            this.avatar_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public WebhookCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new WebhookCreateSpec(this.reason, this.name, this.avatar_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build WebhookCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<Image>> avatar_build() {
            return this.avatar_possible;
        }
    }
}

