/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.spec.WebhookEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="WebhookEditSpecGenerator", generator="Immutables")
public final class WebhookEditSpec
implements WebhookEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Image avatar_value;
    private final boolean avatar_absent;
    private final Snowflake channelId_value;
    private final boolean channelId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final WebhookEditSpec INSTANCE = WebhookEditSpec.validate(new WebhookEditSpec());

    private WebhookEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible avatar$impl = Possible.absent();
        Possible channelId$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.channelId_value = channelId$impl.toOptional().orElse(null);
        this.channelId_absent = channelId$impl.isAbsent();
        this.initShim = null;
    }

    private WebhookEditSpec(@Nullable String reason, Possible<String> name, Possible<Image> avatar, Possible<Snowflake> channelId) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Image> avatar$impl = avatar;
        Possible<Snowflake> channelId$impl = channelId;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.channelId_value = channelId$impl.toOptional().orElse(null);
        this.channelId_absent = channelId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of(this.name_value);
    }

    @Override
    public Possible<Image> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of(this.avatar_value);
    }

    @Override
    public Possible<Snowflake> channelId() {
        return this.channelId_absent ? Possible.absent() : Possible.of(this.channelId_value);
    }

    public final WebhookEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return WebhookEditSpec.validate(new WebhookEditSpec(value, this.name(), this.avatar(), this.channelId()));
    }

    public WebhookEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookEditSpec.validate(new WebhookEditSpec(this.reason, newValue, this.avatar(), this.channelId()));
    }

    public WebhookEditSpec withName(String value) {
        Possible<String> newValue = Possible.of(value);
        return WebhookEditSpec.validate(new WebhookEditSpec(this.reason, newValue, this.avatar(), this.channelId()));
    }

    public WebhookEditSpec withAvatar(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return WebhookEditSpec.validate(new WebhookEditSpec(this.reason, this.name(), newValue, this.channelId()));
    }

    public WebhookEditSpec withAvatar(Image value) {
        Possible<Image> newValue = Possible.of(value);
        return WebhookEditSpec.validate(new WebhookEditSpec(this.reason, this.name(), newValue, this.channelId()));
    }

    public WebhookEditSpec withChannelId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return WebhookEditSpec.validate(new WebhookEditSpec(this.reason, this.name(), this.avatar(), newValue));
    }

    public WebhookEditSpec withChannelId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return WebhookEditSpec.validate(new WebhookEditSpec(this.reason, this.name(), this.avatar(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookEditSpec && this.equalTo(0, (WebhookEditSpec)another);
    }

    private boolean equalTo(int synthetic, WebhookEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.avatar().equals(another.avatar()) && this.channelId().equals(another.channelId());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name().hashCode();
        h2 += (h2 << 5) + this.avatar().hashCode();
        h2 += (h2 << 5) + this.channelId().hashCode();
        return h2;
    }

    public String toString() {
        return "WebhookEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", avatar=" + this.avatar().toString() + ", channelId=" + this.channelId().toString() + "}";
    }

    public static WebhookEditSpec create() {
        return INSTANCE;
    }

    private static WebhookEditSpec validate(WebhookEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static WebhookEditSpec copyOf(WebhookEditSpecGenerator instance) {
        if (instance instanceof WebhookEditSpec) {
            return (WebhookEditSpec)instance;
        }
        return WebhookEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public Image avatarOrElse(Image defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    public boolean isChannelIdPresent() {
        return !this.channelId_absent;
    }

    public Snowflake channelIdOrElse(Snowflake defaultValue) {
        return !this.channelId_absent ? this.channelId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebhookEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookEditSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="WebhookEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Image> avatar_possible = Possible.absent();
        private Possible<Snowflake> channelId_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(WebhookEditSpec instance) {
            return this.from((WebhookEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(WebhookEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.avatar(instance.avatar());
            this.channelId(instance.channelId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avatar(Possible<Image> value) {
            this.avatar_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avatar(Image value) {
            this.avatar_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder channelId(Possible<Snowflake> value) {
            this.channelId_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder channelId(Snowflake value) {
            this.channelId_possible = Possible.of(value);
            return this;
        }

        public WebhookEditSpec build() {
            return WebhookEditSpec.validate(new WebhookEditSpec(this.reason, this.name_build(), this.avatar_build(), this.channelId_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Image> avatar_build() {
            return this.avatar_possible;
        }

        private Possible<Snowflake> channelId_build() {
            return this.channelId_possible;
        }
    }
}

