/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ImmutableMessageCreateFields;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.WebhookMessageEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="WebhookMessageEditSpecGenerator", generator="Immutables")
public final class WebhookMessageEditSpec
implements WebhookMessageEditSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final List<EmbedCreateSpec> embeds;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final WebhookMessageEditSpec INSTANCE = WebhookMessageEditSpec.validate(new WebhookMessageEditSpec());

    private WebhookMessageEditSpec() {
        Possible content$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private WebhookMessageEditSpec(Builder builder) {
        Possible content$impl = builder.content_build();
        Possible allowedMentions$impl = builder.allowedMentions_build();
        Possible components$impl = builder.components_build();
        if (builder.filesIsSet()) {
            this.initShim.files(WebhookMessageEditSpec.createUnmodifiableList(true, builder.files));
        }
        if (builder.fileSpoilersIsSet()) {
            this.initShim.fileSpoilers(WebhookMessageEditSpec.createUnmodifiableList(true, builder.fileSpoilers));
        }
        if (builder.embedsIsSet()) {
            this.initShim.embeds(WebhookMessageEditSpec.createUnmodifiableList(true, builder.embeds));
        }
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private WebhookMessageEditSpec(Possible<Optional<String>> content, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, List<EmbedCreateSpec> embeds, Possible<Optional<AllowedMentions>> allowedMentions, Possible<List<LayoutComponent>> components) {
        Possible content$impl = content;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        this.initShim.embeds(embeds);
        Possible allowedMentions$impl = allowedMentions;
        Possible<List<LayoutComponent>> components$impl = components;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private List<MessageCreateFields.File> filesInitialize() {
        return WebhookMessageEditSpecGenerator.super.files();
    }

    private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
        return WebhookMessageEditSpecGenerator.super.fileSpoilers();
    }

    private List<EmbedCreateSpec> embedsInitialize() {
        return WebhookMessageEditSpecGenerator.super.embeds();
    }

    @Override
    public Possible<Optional<String>> content() {
        return this.content_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.content_value));
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public List<EmbedCreateSpec> embeds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeds() : this.embeds;
    }

    @Override
    public Possible<Optional<AllowedMentions>> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.allowedMentions_value));
    }

    @Override
    public Possible<List<LayoutComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    public WebhookMessageEditSpec withContent(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    @Deprecated
    public WebhookMessageEditSpec withContent(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public WebhookMessageEditSpec withContentOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookMessageEditSpec withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookMessageEditSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(elements, true, false));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookMessageEditSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, newValue, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookMessageEditSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(elements, true, false));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, newValue, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookMessageEditSpec withEmbeds(EmbedCreateSpec ... elements) {
        List<EmbedCreateSpec> newValue = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components()));
    }

    public final WebhookMessageEditSpec withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
        if (this.embeds == elements) {
            return this;
        }
        List<EmbedCreateSpec> newValue = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(elements, true, false));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components()));
    }

    public WebhookMessageEditSpec withAllowedMentions(Possible<Optional<AllowedMentions>> value) {
        Possible<Optional<AllowedMentions>> newValue = Objects.requireNonNull(value);
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components()));
    }

    @Deprecated
    public WebhookMessageEditSpec withAllowedMentions(@Nullable AllowedMentions value) {
        Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components()));
    }

    public WebhookMessageEditSpec withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
        Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components()));
    }

    public WebhookMessageEditSpec withComponents(Possible<? extends List<? extends LayoutComponent>> possible) {
        Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue));
    }

    public WebhookMessageEditSpec withComponents(Iterable<? extends LayoutComponent> elements) {
        Possible<List<LayoutComponent>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue));
    }

    @SafeVarargs
    public final WebhookMessageEditSpec withComponents(LayoutComponent ... elements) {
        Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
        return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookMessageEditSpec && this.equalTo(0, (WebhookMessageEditSpec)another);
    }

    private boolean equalTo(int synthetic, WebhookMessageEditSpec another) {
        return this.content().equals(another.content()) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.embeds.equals(another.embeds) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.content().hashCode();
        h2 += (h2 << 5) + this.files.hashCode();
        h2 += (h2 << 5) + this.fileSpoilers.hashCode();
        h2 += (h2 << 5) + this.embeds.hashCode();
        h2 += (h2 << 5) + this.allowedMentions().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.components_value);
        return h2;
    }

    public String toString() {
        return "WebhookMessageEditSpec{content=" + this.content().toString() + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", embeds=" + this.embeds + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + "}";
    }

    public static WebhookMessageEditSpec create() {
        return INSTANCE;
    }

    private static WebhookMessageEditSpec validate(WebhookMessageEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static WebhookMessageEditSpec copyOf(WebhookMessageEditSpecGenerator instance) {
        if (instance instanceof WebhookMessageEditSpec) {
            return (WebhookMessageEditSpec)instance;
        }
        return WebhookMessageEditSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WebhookMessageEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_FILES = 1L;
        private static final long OPT_BIT_FILE_SPOILERS = 2L;
        private static final long OPT_BIT_EMBEDS = 4L;
        private long optBits;
        private Possible<Optional<String>> content_possible = Possible.absent();
        private Possible<Optional<AllowedMentions>> allowedMentions_possible = Possible.absent();
        private List<LayoutComponent> components_list = null;
        private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
        private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();
        private List<EmbedCreateSpec> embeds = new ArrayList<EmbedCreateSpec>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WebhookMessageEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.addAllFiles(instance.files());
            this.addAllFileSpoilers(instance.fileSpoilers());
            this.addAllEmbeds(instance.embeds());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Possible<Optional<String>> value) {
            this.content_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder content(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder contentOrNull(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFile(MessageCreateFields.File element) {
            element = ImmutableMessageCreateFields.File.copyOf(element);
            this.files.add(Objects.requireNonNull(element, "files element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFile(String name, InputStream inputStream) {
            return this.addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
        }

        @CanIgnoreReturnValue
        public final Builder addFiles(MessageCreateFields.File ... elements) {
            for (MessageCreateFields.File element : elements) {
                element = ImmutableMessageCreateFields.File.copyOf(element);
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
            for (MessageCreateFields.File file : elements) {
                ImmutableMessageCreateFields.File file2 = ImmutableMessageCreateFields.File.copyOf(file);
                this.files.add(Objects.requireNonNull(file2, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
            element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
            this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFileSpoiler(String name, InputStream inputStream) {
            return this.addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
        }

        @CanIgnoreReturnValue
        public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
            for (MessageCreateFields.FileSpoiler element : elements) {
                element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
                this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            this.fileSpoilers.clear();
            return this.addAllFileSpoilers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
                ImmutableMessageCreateFields.FileSpoiler fileSpoiler2 = ImmutableMessageCreateFields.FileSpoiler.copyOf(fileSpoiler);
                this.fileSpoilers.add(Objects.requireNonNull(fileSpoiler2, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEmbed(EmbedCreateSpec element) {
            this.embeds.add(Objects.requireNonNull(element, "embeds element"));
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEmbeds(EmbedCreateSpec ... elements) {
            for (EmbedCreateSpec element : elements) {
                this.embeds.add(Objects.requireNonNull(element, "embeds element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder embeds(Iterable<? extends EmbedCreateSpec> elements) {
            this.embeds.clear();
            return this.addAllEmbeds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
            for (EmbedCreateSpec embedCreateSpec : elements) {
                this.embeds.add(Objects.requireNonNull(embedCreateSpec, "embeds element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Possible<Optional<AllowedMentions>> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder allowedMentions(@Nullable AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentionsOrNull(@Nullable AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(LayoutComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(Collection<? extends LayoutComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<? extends Collection<? extends LayoutComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<LayoutComponent>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Iterable<? extends LayoutComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder components(LayoutComponent ... elements) {
            this.components_list = Arrays.asList(elements);
            return this;
        }

        public WebhookMessageEditSpec build() {
            return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this));
        }

        private boolean filesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fileSpoilersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean embedsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private Possible<Optional<String>> content_build() {
            return this.content_possible;
        }

        private Possible<Optional<AllowedMentions>> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<List<LayoutComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<LayoutComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<LayoutComponent>();
            }
            return this.components_list;
        }
    }

    @Generated(from="WebhookMessageEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;
        private byte embedsBuildStage = 0;
        private List<EmbedCreateSpec> embeds;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(WebhookMessageEditSpec.this.filesInitialize(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(WebhookMessageEditSpec.this.fileSpoilersInitialize(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        List<EmbedCreateSpec> embeds() {
            if (this.embedsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embedsBuildStage == 0) {
                this.embedsBuildStage = (byte)-1;
                this.embeds = WebhookMessageEditSpec.createUnmodifiableList(false, WebhookMessageEditSpec.createSafeList(WebhookMessageEditSpec.this.embedsInitialize(), true, false));
                this.embedsBuildStage = 1;
            }
            return this.embeds;
        }

        void embeds(List<EmbedCreateSpec> embeds) {
            this.embeds = embeds;
            this.embedsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            if (this.embedsBuildStage == -1) {
                attributes.add("embeds");
            }
            return "Cannot build WebhookMessageEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

