/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.LogUtil;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.VoiceServerUpdateEvent;
import discord4j.core.event.domain.VoiceStateUpdateEvent;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.channel.AudioChannel;
import discord4j.core.spec.DefaultVoiceServerUpdateTask;
import discord4j.core.spec.legacy.LegacySpec;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import discord4j.gateway.GatewayClientGroup;
import discord4j.gateway.intent.Intent;
import discord4j.gateway.json.ShardGatewayPayload;
import discord4j.voice.AudioProvider;
import discord4j.voice.AudioReceiver;
import discord4j.voice.LocalVoiceReceiveTaskFactory;
import discord4j.voice.LocalVoiceSendTaskFactory;
import discord4j.voice.VoiceChannelRetrieveTask;
import discord4j.voice.VoiceConnection;
import discord4j.voice.VoiceDisconnectTask;
import discord4j.voice.VoiceGatewayOptions;
import discord4j.voice.VoiceReceiveTaskFactory;
import discord4j.voice.VoiceSendTaskFactory;
import discord4j.voice.VoiceServerOptions;
import discord4j.voice.VoiceStateUpdateTask;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.TupleUtils;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.retry.RetrySpec;

public class LegacyVoiceChannelJoinSpec
implements LegacySpec<Mono<VoiceConnection>> {
    private static final Logger log = Loggers.getLogger(LegacyVoiceChannelJoinSpec.class);
    private static final int DEFAULT_TIMEOUT = 10;
    private static final int DEFAULT_DISCOVERY_TIMEOUT = 5;
    private Duration timeout = Duration.ofSeconds(10L);
    private AudioProvider provider = AudioProvider.NO_OP;
    private AudioReceiver receiver = AudioReceiver.NO_OP;
    private VoiceSendTaskFactory sendTaskFactory = new LocalVoiceSendTaskFactory();
    private VoiceReceiveTaskFactory receiveTaskFactory = new LocalVoiceReceiveTaskFactory();
    private boolean selfDeaf;
    private boolean selfMute;
    private Duration ipDiscoveryTimeout = Duration.ofSeconds(5L);
    private RetrySpec ipDiscoveryRetrySpec = RetrySpec.maxInARow(1L);
    private final GatewayDiscordClient gateway;
    private final AudioChannel audioChannel;

    public LegacyVoiceChannelJoinSpec(GatewayDiscordClient gateway, AudioChannel audioChannel) {
        this.gateway = Objects.requireNonNull(gateway);
        this.audioChannel = audioChannel;
    }

    public LegacyVoiceChannelJoinSpec setProvider(AudioProvider provider) {
        this.provider = provider;
        return this;
    }

    @Deprecated
    public LegacyVoiceChannelJoinSpec setReceiver(AudioReceiver receiver) {
        this.receiver = receiver;
        return this;
    }

    public LegacyVoiceChannelJoinSpec setSendTaskFactory(VoiceSendTaskFactory sendTaskFactory) {
        this.sendTaskFactory = sendTaskFactory;
        return this;
    }

    @Deprecated
    public LegacyVoiceChannelJoinSpec setReceiveTaskFactory(VoiceReceiveTaskFactory receiveTaskFactory) {
        this.receiveTaskFactory = receiveTaskFactory;
        return this;
    }

    public LegacyVoiceChannelJoinSpec setSelfDeaf(boolean selfDeaf) {
        this.selfDeaf = selfDeaf;
        return this;
    }

    public LegacyVoiceChannelJoinSpec setSelfMute(boolean selfMute) {
        this.selfMute = selfMute;
        return this;
    }

    public LegacyVoiceChannelJoinSpec setTimeout(Duration timeout) {
        this.timeout = Objects.requireNonNull(timeout);
        return this;
    }

    public LegacyVoiceChannelJoinSpec setIpDiscoveryTimeout(Duration ipDiscoveryTimeout) {
        this.ipDiscoveryTimeout = Objects.requireNonNull(ipDiscoveryTimeout);
        return this;
    }

    public LegacyVoiceChannelJoinSpec setIpDiscoveryRetrySpec(RetrySpec ipDiscoveryRetrySpec) {
        this.ipDiscoveryRetrySpec = Objects.requireNonNull(ipDiscoveryRetrySpec);
        return this;
    }

    @Override
    public Mono<VoiceConnection> asRequest() {
        if (!this.gateway.getGatewayResources().getIntents().contains((Object)Intent.GUILD_VOICE_STATES)) {
            return Mono.error(new IllegalArgumentException("GUILD_VOICE_STATES intent is required to establish a voice connection"));
        }
        Snowflake guildId = this.audioChannel.getGuildId();
        Snowflake channelId = this.audioChannel.getId();
        GatewayClientGroup clientGroup = this.audioChannel.getClient().getGatewayClientGroup();
        int shardId = clientGroup.computeShardIndex(guildId);
        Mono<Void> sendVoiceStateUpdate = clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate(VoiceStateUpdate.builder().guildId(guildId.asString()).channelId(channelId.asString()).selfMute(this.selfMute).selfDeaf(this.selfDeaf).build(), shardId));
        Mono<VoiceStateUpdateEvent> waitForVoiceStateUpdate = LegacyVoiceChannelJoinSpec.onVoiceStateUpdates(this.gateway, guildId).next();
        Mono<VoiceServerUpdateEvent> waitForVoiceServerUpdate = LegacyVoiceChannelJoinSpec.onVoiceServerUpdate(this.gateway, guildId);
        VoiceDisconnectTask disconnectTask = id -> this.audioChannel.sendDisconnectVoiceState().then(this.gateway.getVoiceConnectionRegistry().disconnect(id));
        DefaultVoiceServerUpdateTask serverUpdateTask = new DefaultVoiceServerUpdateTask(this.gateway);
        VoiceStateUpdateTask stateUpdateTask = id -> LegacyVoiceChannelJoinSpec.onVoiceStateUpdates(this.gateway, id).map(stateUpdateEvent -> stateUpdateEvent.getCurrent().getSessionId());
        VoiceChannelRetrieveTask channelRetrieveTask = () -> this.gateway.getMemberById(this.audioChannel.getGuildId(), this.gateway.getSelfId()).flatMap(PartialMember::getVoiceState).flatMap(voiceState -> Mono.justOrEmpty(voiceState.getChannelId()));
        Mono newConnection = sendVoiceStateUpdate.then(Mono.zip(waitForVoiceStateUpdate, waitForVoiceServerUpdate)).flatMap(TupleUtils.function((voiceState, voiceServer) -> {
            String session = voiceState.getCurrent().getSessionId();
            VoiceServerOptions voiceServerOptions = new VoiceServerOptions(voiceServer.getToken(), voiceServer.getEndpoint());
            VoiceGatewayOptions voiceGatewayOptions = new VoiceGatewayOptions(guildId, this.gateway.getSelfId(), session, voiceServerOptions, this.gateway.getCoreResources().getJacksonResources(), this.gateway.getGatewayResources().getVoiceReactorResources(), this.gateway.getGatewayResources().getVoiceReconnectOptions(), this.provider, this.receiver, this.sendTaskFactory, this.receiveTaskFactory, disconnectTask, serverUpdateTask, stateUpdateTask, channelRetrieveTask, this.ipDiscoveryTimeout, this.ipDiscoveryRetrySpec);
            return this.gateway.getVoiceConnectionFactory().create(voiceGatewayOptions).flatMap(vc -> this.gateway.getVoiceConnectionRegistry().registerVoiceConnection(guildId, (VoiceConnection)vc).thenReturn(vc)).doOnEach(signal -> {
                if (signal.isOnSubscribe()) {
                    log.debug(LogUtil.format(signal.getContextView(), "Creating voice connection"));
                }
            }).contextWrite(ctx -> ctx.put("discord4j.gateway", Integer.toHexString(this.gateway.hashCode())).put("discord4j.shard", shardId).put("discord4j.guild", guildId.asLong()));
        })).timeout(this.timeout).doFinally(signal -> log.debug("Voice connection handshake to guild {} done after {}", guildId.asLong(), signal)).onErrorResume(TimeoutException.class, t -> this.gateway.getVoiceConnectionRegistry().getVoiceConnection(guildId).switchIfEmpty(this.audioChannel.sendDisconnectVoiceState().then(Mono.error(t))));
        return this.gateway.getVoiceConnectionRegistry().getVoiceConnection(guildId).flatMap(existing -> sendVoiceStateUpdate.then(waitForVoiceStateUpdate).thenReturn(existing)).switchIfEmpty(newConnection);
    }

    static Flux<VoiceStateUpdateEvent> onVoiceStateUpdates(GatewayDiscordClient gateway, Snowflake guildId) {
        return gateway.getEventDispatcher().on(VoiceStateUpdateEvent.class).filter(vsu -> {
            Snowflake vsuUser = vsu.getCurrent().getUserId();
            Snowflake vsuGuild = vsu.getCurrent().getGuildId();
            return vsuUser.equals(gateway.getSelfId()) && vsuGuild.equals(guildId);
        });
    }

    static Mono<VoiceServerUpdateEvent> onVoiceServerUpdate(GatewayDiscordClient gateway, Snowflake guildId) {
        return gateway.getEventDispatcher().on(VoiceServerUpdateEvent.class).filter(vsu -> vsu.getGuildId().equals(guildId) && vsu.getEndpoint() != null).next();
    }
}

