/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ListThreadsData;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ListThreadsData", generator="Immutables")
public final class ImmutableListThreadsData
implements ListThreadsData {
    private final List<ChannelData> threads;
    private final List<ThreadMemberData> members;
    private final Boolean hasMore_value;
    private final boolean hasMore_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableListThreadsData(Iterable<? extends ChannelData> threads, Iterable<? extends ThreadMemberData> members, Possible<Boolean> hasMore) {
        this.threads = ImmutableListThreadsData.createUnmodifiableList(false, ImmutableListThreadsData.createSafeList(threads, true, false));
        this.members = ImmutableListThreadsData.createUnmodifiableList(false, ImmutableListThreadsData.createSafeList(members, true, false));
        Possible<Boolean> hasMore$impl = hasMore;
        this.hasMore_value = hasMore$impl.toOptional().orElse(null);
        this.hasMore_absent = hasMore$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableListThreadsData(ImmutableListThreadsData original, List<ChannelData> threads, List<ThreadMemberData> members, Possible<Boolean> hasMore) {
        this.threads = threads;
        this.members = members;
        Possible<Boolean> hasMore$impl = hasMore;
        this.hasMore_value = hasMore$impl.toOptional().orElse(null);
        this.hasMore_absent = hasMore$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="threads")
    public List<ChannelData> threads() {
        return this.threads;
    }

    @Override
    @JsonProperty(value="members")
    public List<ThreadMemberData> members() {
        return this.members;
    }

    @Override
    @JsonProperty(value="has_more")
    public Possible<Boolean> hasMore() {
        return this.hasMore_absent ? Possible.absent() : Possible.of(this.hasMore_value);
    }

    public final ImmutableListThreadsData withThreads(ChannelData ... elements) {
        List<ChannelData> newValue = ImmutableListThreadsData.createUnmodifiableList(false, ImmutableListThreadsData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListThreadsData(this, newValue, this.members, this.hasMore());
    }

    public final ImmutableListThreadsData withThreads(Iterable<? extends ChannelData> elements) {
        if (this.threads == elements) {
            return this;
        }
        List<ChannelData> newValue = ImmutableListThreadsData.createUnmodifiableList(false, ImmutableListThreadsData.createSafeList(elements, true, false));
        return new ImmutableListThreadsData(this, newValue, this.members, this.hasMore());
    }

    public final ImmutableListThreadsData withMembers(ThreadMemberData ... elements) {
        List<ThreadMemberData> newValue = ImmutableListThreadsData.createUnmodifiableList(false, ImmutableListThreadsData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListThreadsData(this, this.threads, newValue, this.hasMore());
    }

    public final ImmutableListThreadsData withMembers(Iterable<? extends ThreadMemberData> elements) {
        if (this.members == elements) {
            return this;
        }
        List<ThreadMemberData> newValue = ImmutableListThreadsData.createUnmodifiableList(false, ImmutableListThreadsData.createSafeList(elements, true, false));
        return new ImmutableListThreadsData(this, this.threads, newValue, this.hasMore());
    }

    public ImmutableListThreadsData withHasMore(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableListThreadsData(this, this.threads, this.members, newValue);
    }

    public ImmutableListThreadsData withHasMore(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return new ImmutableListThreadsData(this, this.threads, this.members, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListThreadsData && this.equalTo(0, (ImmutableListThreadsData)another);
    }

    private boolean equalTo(int synthetic, ImmutableListThreadsData another) {
        return this.threads.equals(another.threads) && this.members.equals(another.members) && this.hasMore().equals(another.hasMore());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.threads.hashCode();
        h2 += (h2 << 5) + this.members.hashCode();
        h2 += (h2 << 5) + this.hasMore().hashCode();
        return h2;
    }

    public String toString() {
        return "ListThreadsData{threads=" + this.threads + ", members=" + this.members + ", hasMore=" + this.hasMore().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableListThreadsData fromJson(Json json) {
        Builder builder = ImmutableListThreadsData.builder();
        if (json.threads != null) {
            builder.addAllThreads(json.threads);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.hasMore != null) {
            builder.hasMore(json.hasMore);
        }
        return builder.build();
    }

    public static ImmutableListThreadsData of(List<ChannelData> threads, List<ThreadMemberData> members, Possible<Boolean> hasMore) {
        return ImmutableListThreadsData.of(threads, members, hasMore);
    }

    public static ImmutableListThreadsData of(Iterable<? extends ChannelData> threads, Iterable<? extends ThreadMemberData> members, Possible<Boolean> hasMore) {
        return new ImmutableListThreadsData(threads, members, hasMore);
    }

    public static ImmutableListThreadsData copyOf(ListThreadsData instance) {
        if (instance instanceof ImmutableListThreadsData) {
            return (ImmutableListThreadsData)instance;
        }
        return ImmutableListThreadsData.builder().from(instance).build();
    }

    public boolean isHasMorePresent() {
        return !this.hasMore_absent;
    }

    public Boolean hasMoreOrElse(Boolean defaultValue) {
        return !this.hasMore_absent ? this.hasMore_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ListThreadsData", generator="Immutables")
    public static final class Builder {
        private Possible<Boolean> hasMore_possible = Possible.absent();
        private List<ChannelData> threads = new ArrayList<ChannelData>();
        private List<ThreadMemberData> members = new ArrayList<ThreadMemberData>();

        private Builder() {
        }

        public final Builder from(ListThreadsData instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllThreads(instance.threads());
            this.addAllMembers(instance.members());
            this.hasMore(instance.hasMore());
            return this;
        }

        public final Builder addThread(ChannelData element) {
            this.threads.add(Objects.requireNonNull(element, "threads element"));
            return this;
        }

        public final Builder addThreads(ChannelData ... elements) {
            for (ChannelData element : elements) {
                this.threads.add(Objects.requireNonNull(element, "threads element"));
            }
            return this;
        }

        @JsonProperty(value="threads")
        public final Builder threads(Iterable<? extends ChannelData> elements) {
            this.threads.clear();
            return this.addAllThreads(elements);
        }

        public final Builder addAllThreads(Iterable<? extends ChannelData> elements) {
            for (ChannelData channelData : elements) {
                this.threads.add(Objects.requireNonNull(channelData, "threads element"));
            }
            return this;
        }

        public final Builder addMember(ThreadMemberData element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(ThreadMemberData ... elements) {
            for (ThreadMemberData element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @JsonProperty(value="members")
        public final Builder members(Iterable<? extends ThreadMemberData> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends ThreadMemberData> elements) {
            for (ThreadMemberData threadMemberData : elements) {
                this.members.add(Objects.requireNonNull(threadMemberData, "members element"));
            }
            return this;
        }

        @JsonProperty(value="has_more")
        public Builder hasMore(Possible<Boolean> value) {
            this.hasMore_possible = value;
            return this;
        }

        public Builder hasMore(Boolean value) {
            this.hasMore_possible = Possible.of(value);
            return this;
        }

        public ImmutableListThreadsData build() {
            return new ImmutableListThreadsData(null, ImmutableListThreadsData.createUnmodifiableList(true, this.threads), ImmutableListThreadsData.createUnmodifiableList(true, this.members), this.hasMore_build());
        }

        private Possible<Boolean> hasMore_build() {
            return this.hasMore_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ListThreadsData", generator="Immutables")
    static final class Json
    implements ListThreadsData {
        List<ChannelData> threads = Collections.emptyList();
        List<ThreadMemberData> members = Collections.emptyList();
        Possible<Boolean> hasMore = Possible.absent();

        Json() {
        }

        @JsonProperty(value="threads")
        public void setThreads(List<ChannelData> threads) {
            this.threads = threads;
        }

        @JsonProperty(value="members")
        public void setMembers(List<ThreadMemberData> members) {
            this.members = members;
        }

        @JsonProperty(value="has_more")
        public void setHasMore(Possible<Boolean> hasMore) {
            this.hasMore = hasMore;
        }

        @Override
        public List<ChannelData> threads() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ThreadMemberData> members() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> hasMore() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ListThreadsData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ListThreadsData, attribute initializers form cycle " + attributes;
        }
    }
}

