/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.json.gateway.ThreadMembersUpdate;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="ThreadMembersUpdate", generator="Immutables")
public final class ImmutableThreadMembersUpdate
implements ThreadMembersUpdate {
    private final long id_value;
    private final long guildId_value;
    private final int memberCount;
    private final List<ThreadMemberData> addedMembers_value;
    private final boolean addedMembers_absent;
    private final List<Id> removedMemberIds_value;
    private final boolean removedMemberIds_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableThreadMembersUpdate(Id id, Id guildId, int memberCount, Possible<List<ThreadMemberData>> addedMembers, Possible<List<Id>> removedMemberIds) {
        Id id$impl = id;
        Id guildId$impl = guildId;
        this.memberCount = memberCount;
        Possible<List<ThreadMemberData>> addedMembers$impl = addedMembers;
        Possible<List<Id>> removedMemberIds$impl = removedMemberIds;
        this.id_value = id$impl.asLong();
        this.guildId_value = guildId$impl.asLong();
        this.addedMembers_value = addedMembers$impl.toOptional().orElse(null);
        this.addedMembers_absent = addedMembers$impl.isAbsent();
        this.removedMemberIds_value = removedMemberIds$impl.toOptional().orElse(null);
        this.removedMemberIds_absent = removedMemberIds$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableThreadMembersUpdate(ImmutableThreadMembersUpdate original, Id id, Id guildId, int memberCount, Possible<List<ThreadMemberData>> addedMembers, Possible<List<Id>> removedMemberIds) {
        Id id$impl = id;
        Id guildId$impl = guildId;
        this.memberCount = memberCount;
        Possible<List<ThreadMemberData>> addedMembers$impl = addedMembers;
        Possible<List<Id>> removedMemberIds$impl = removedMemberIds;
        this.id_value = id$impl.asLong();
        this.guildId_value = guildId$impl.asLong();
        this.addedMembers_value = addedMembers$impl.toOptional().orElse(null);
        this.addedMembers_absent = addedMembers$impl.isAbsent();
        this.removedMemberIds_value = removedMemberIds$impl.toOptional().orElse(null);
        this.removedMemberIds_absent = removedMemberIds$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of(this.id_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of(this.guildId_value);
    }

    @Override
    @JsonProperty(value="member_count")
    public int memberCount() {
        return this.memberCount;
    }

    @Override
    @JsonProperty(value="added_members")
    public Possible<List<ThreadMemberData>> addedMembers() {
        return this.addedMembers_absent ? Possible.absent() : Possible.of(this.addedMembers_value);
    }

    @Override
    @JsonProperty(value="removed_member_ids")
    public Possible<List<Id>> removedMemberIds() {
        return this.removedMemberIds_absent ? Possible.absent() : Possible.of(this.removedMemberIds_value);
    }

    public ImmutableThreadMembersUpdate withId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableThreadMembersUpdate(this, newValue, this.guildId(), this.memberCount, this.addedMembers(), this.removedMemberIds());
    }

    public ImmutableThreadMembersUpdate withId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableThreadMembersUpdate(this, newValue, this.guildId(), this.memberCount, this.addedMembers(), this.removedMemberIds());
    }

    public ImmutableThreadMembersUpdate withGuildId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableThreadMembersUpdate(this, this.id(), newValue, this.memberCount, this.addedMembers(), this.removedMemberIds());
    }

    public ImmutableThreadMembersUpdate withGuildId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableThreadMembersUpdate(this, this.id(), newValue, this.memberCount, this.addedMembers(), this.removedMemberIds());
    }

    public final ImmutableThreadMembersUpdate withMemberCount(int value) {
        if (this.memberCount == value) {
            return this;
        }
        return new ImmutableThreadMembersUpdate(this, this.id(), this.guildId(), value, this.addedMembers(), this.removedMemberIds());
    }

    public ImmutableThreadMembersUpdate withAddedMembers(Possible<? extends List<? extends ThreadMemberData>> possible) {
        Possible<List<ThreadMemberData>> newValue = Objects.requireNonNull(possible);
        return new ImmutableThreadMembersUpdate(this, this.id(), this.guildId(), this.memberCount, newValue, this.removedMemberIds());
    }

    public ImmutableThreadMembersUpdate withAddedMembers(Iterable<? extends ThreadMemberData> elements) {
        Possible<List<ThreadMemberData>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableThreadMembersUpdate(this, this.id(), this.guildId(), this.memberCount, newValue, this.removedMemberIds());
    }

    @SafeVarargs
    public final ImmutableThreadMembersUpdate withAddedMembers(ThreadMemberData ... elements) {
        Possible<List<ThreadMemberData>> newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableThreadMembersUpdate(this, this.id(), this.guildId(), this.memberCount, newValue, this.removedMemberIds());
    }

    public ImmutableThreadMembersUpdate withRemovedMemberIds(Possible<? extends List<? extends Id>> possible) {
        Possible<List<Id>> newValue = Objects.requireNonNull(possible);
        return new ImmutableThreadMembersUpdate(this, this.id(), this.guildId(), this.memberCount, this.addedMembers(), newValue);
    }

    public ImmutableThreadMembersUpdate withRemovedMemberIds(Iterable<? extends Id> elements) {
        Possible<List<Id>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableThreadMembersUpdate(this, this.id(), this.guildId(), this.memberCount, this.addedMembers(), newValue);
    }

    @SafeVarargs
    public final ImmutableThreadMembersUpdate withRemovedMemberIds(Id ... elements) {
        Possible<List<Id>> newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableThreadMembersUpdate(this, this.id(), this.guildId(), this.memberCount, this.addedMembers(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThreadMembersUpdate && this.equalTo(0, (ImmutableThreadMembersUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableThreadMembersUpdate another) {
        return Objects.equals(this.id_value, another.id_value) && Objects.equals(this.guildId_value, another.guildId_value) && this.memberCount == another.memberCount && Objects.equals(this.addedMembers_value, another.addedMembers_value) && Objects.equals(this.removedMemberIds_value, another.removedMemberIds_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id_value);
        h2 += (h2 << 5) + Objects.hashCode(this.guildId_value);
        h2 += (h2 << 5) + this.memberCount;
        h2 += (h2 << 5) + Objects.hashCode(this.addedMembers_value);
        h2 += (h2 << 5) + Objects.hashCode(this.removedMemberIds_value);
        return h2;
    }

    public String toString() {
        return "ThreadMembersUpdate{id=" + Objects.toString(this.id_value) + ", guildId=" + Objects.toString(this.guildId_value) + ", memberCount=" + this.memberCount + ", addedMembers=" + Objects.toString(this.addedMembers_value) + ", removedMemberIds=" + Objects.toString(this.removedMemberIds_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableThreadMembersUpdate fromJson(Json json) {
        Builder builder = ImmutableThreadMembersUpdate.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.memberCountIsSet) {
            builder.memberCount(json.memberCount);
        }
        if (json.addedMembers != null) {
            builder.addedMembers(json.addedMembers);
        }
        if (json.removedMemberIds != null) {
            builder.removedMemberIds(json.removedMemberIds);
        }
        return builder.build();
    }

    public static ImmutableThreadMembersUpdate of(Id id, Id guildId, int memberCount, Possible<List<ThreadMemberData>> addedMembers, Possible<List<Id>> removedMemberIds) {
        return new ImmutableThreadMembersUpdate(id, guildId, memberCount, addedMembers, removedMemberIds);
    }

    public static ImmutableThreadMembersUpdate copyOf(ThreadMembersUpdate instance) {
        if (instance instanceof ImmutableThreadMembersUpdate) {
            return (ImmutableThreadMembersUpdate)instance;
        }
        return ImmutableThreadMembersUpdate.builder().from(instance).build();
    }

    public boolean isAddedMembersPresent() {
        return !this.addedMembers_absent;
    }

    public List<ThreadMemberData> addedMembersOrElse(List<ThreadMemberData> defaultValue) {
        return !this.addedMembers_absent ? this.addedMembers_value : defaultValue;
    }

    public boolean isRemovedMemberIdsPresent() {
        return !this.removedMemberIds_absent;
    }

    public List<Id> removedMemberIdsOrElse(List<Id> defaultValue) {
        return !this.removedMemberIds_absent ? this.removedMemberIds_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ThreadMembersUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MEMBER_COUNT = 1L;
        private long initBits = 1L;
        private Id id_id = null;
        private Id guildId_id = null;
        private List<ThreadMemberData> addedMembers_list = null;
        private List<Id> removedMemberIds_list = null;
        private int memberCount;

        private Builder() {
        }

        public final Builder from(ThreadMembersUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.guildId(instance.guildId());
            this.memberCount(instance.memberCount());
            this.addedMembers(instance.addedMembers());
            this.removedMemberIds(instance.removedMemberIds());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of(value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of(value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        @JsonProperty(value="member_count")
        public final Builder memberCount(int memberCount) {
            this.memberCount = memberCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder addAddedMember(ThreadMemberData element) {
            this.addedMembers_getOrCreate().add(element);
            return this;
        }

        public Builder addAllAddedMembers(Collection<? extends ThreadMemberData> elements) {
            this.addedMembers_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="added_members")
        public Builder addedMembers(Possible<? extends Collection<? extends ThreadMemberData>> elements) {
            this.addedMembers_list = null;
            elements.toOptional().ifPresent(e -> this.addedMembers_getOrCreate().addAll((Collection<ThreadMemberData>)e));
            return this;
        }

        public Builder addedMembers(Iterable<? extends ThreadMemberData> elements) {
            this.addedMembers_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        public final Builder addedMembers(ThreadMemberData ... elements) {
            this.addedMembers_list = Arrays.asList(elements);
            return this;
        }

        public Builder addRemovedMemberId(Id element) {
            this.removedMemberIds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllRemovedMemberIds(Collection<? extends Id> elements) {
            this.removedMemberIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="removed_member_ids")
        public Builder removedMemberIds(Possible<? extends Collection<? extends Id>> elements) {
            this.removedMemberIds_list = null;
            elements.toOptional().ifPresent(e -> this.removedMemberIds_getOrCreate().addAll((Collection<Id>)e));
            return this;
        }

        public Builder removedMemberIds(Iterable<? extends Id> elements) {
            this.removedMemberIds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        public final Builder removedMemberIds(Id ... elements) {
            this.removedMemberIds_list = Arrays.asList(elements);
            return this;
        }

        public ImmutableThreadMembersUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableThreadMembersUpdate(null, this.id_build(), this.guildId_build(), this.memberCount, this.addedMembers_build(), this.removedMemberIds_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("memberCount");
            }
            return "Cannot build ThreadMembersUpdate, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private Possible<List<ThreadMemberData>> addedMembers_build() {
            return this.addedMembers_list == null ? Possible.absent() : Possible.of(this.addedMembers_list);
        }

        private List<ThreadMemberData> addedMembers_getOrCreate() {
            if (this.addedMembers_list == null) {
                this.addedMembers_list = new ArrayList<ThreadMemberData>();
            }
            return this.addedMembers_list;
        }

        private Possible<List<Id>> removedMemberIds_build() {
            return this.removedMemberIds_list == null ? Possible.absent() : Possible.of(this.removedMemberIds_list);
        }

        private List<Id> removedMemberIds_getOrCreate() {
            if (this.removedMemberIds_list == null) {
                this.removedMemberIds_list = new ArrayList<Id>();
            }
            return this.removedMemberIds_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ThreadMembersUpdate", generator="Immutables")
    static final class Json
    implements ThreadMembersUpdate {
        Id id;
        Id guildId;
        int memberCount;
        boolean memberCountIsSet;
        Possible<List<ThreadMemberData>> addedMembers = Possible.absent();
        Possible<List<Id>> removedMemberIds = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="member_count")
        public void setMemberCount(int memberCount) {
            this.memberCount = memberCount;
            this.memberCountIsSet = true;
        }

        @JsonProperty(value="added_members")
        public void setAddedMembers(Possible<List<ThreadMemberData>> addedMembers) {
            this.addedMembers = addedMembers;
        }

        @JsonProperty(value="removed_member_ids")
        public void setRemovedMemberIds(Possible<List<Id>> removedMemberIds) {
            this.removedMemberIds = removedMemberIds;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int memberCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<ThreadMemberData>> addedMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<Id>> removedMemberIds() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ThreadMembersUpdate", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ThreadMembersUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

