/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.jdk;

import discord4j.store.api.Store;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class JdkCachingStore<K extends Comparable<K>, V>
implements Store<K, V> {
    private final Store<K, V> delegate;
    private final Function<K, Duration> ttlFactory;
    private final Map<K, Mono<V>> caches = new ConcurrentHashMap<K, Mono<V>>();

    public JdkCachingStore(Store<K, V> delegate, Function<K, Duration> ttlFactory) {
        this.delegate = delegate;
        this.ttlFactory = ttlFactory;
    }

    @Override
    public Mono<V> find(K id) {
        return Mono.defer(() -> this.caches.computeIfAbsent((Comparable)id, k -> {
            Duration ttl = this.ttlFactory.apply(id);
            return this.delegate.find((Comparable)id).cache(v -> ttl, t -> Duration.ZERO, () -> Duration.ZERO);
        }));
    }

    @Override
    public Flux<V> findInRange(K start, K end) {
        return this.delegate.findInRange(start, end);
    }

    @Override
    public Mono<Long> count() {
        return this.delegate.count();
    }

    @Override
    public Flux<K> keys() {
        return this.delegate.keys();
    }

    @Override
    public Flux<V> values() {
        return this.delegate.values();
    }

    @Override
    public Mono<Void> save(K key, V value) {
        return this.delegate.save(key, value).doOnTerminate(() -> this.caches.put((Comparable)key, (Mono<Mono<Object>>)Mono.just(value)));
    }

    @Override
    public Mono<Void> save(Publisher<Tuple2<K, V>> entryStream) {
        return Flux.from(entryStream).map(t2 -> this.save((Comparable)t2.getT1(), t2.getT2())).then();
    }

    @Override
    public Mono<Void> delete(K id) {
        return this.delegate.delete(id).doOnTerminate(() -> this.caches.remove(id));
    }

    @Override
    public Mono<Void> delete(Publisher<K> ids) {
        return Flux.from(ids).map(this::delete).then();
    }

    @Override
    public Mono<Void> deleteInRange(K start, K end) {
        return this.delegate.deleteInRange(start, end);
    }

    @Override
    public Mono<Void> deleteAll() {
        return this.delegate.deleteAll().doOnTerminate(this.caches::clear);
    }

    @Override
    public Mono<Void> invalidate() {
        return this.delegate.invalidate().doOnTerminate(this.caches::clear);
    }
}

