/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.common.util.Snowflake;
import discord4j.voice.VoiceConnection;
import discord4j.voice.VoiceConnectionRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class LocalVoiceConnectionRegistry
implements VoiceConnectionRegistry {
    private static final Logger log = Loggers.getLogger(LocalVoiceConnectionRegistry.class);
    private final Map<Long, VoiceConnection> voiceConnections = new ConcurrentHashMap<Long, VoiceConnection>();

    @Override
    public Mono<VoiceConnection> getVoiceConnection(Snowflake guildId) {
        return Mono.fromCallable(() -> this.voiceConnections.get(guildId.asLong())).flatMap(vc -> vc.stateEvents().next().doOnNext(state -> log.debug("Connection found to guild {} with state: {}", guildId.asLong(), state)).thenReturn(vc)).switchIfEmpty(Mono.empty().doOnSubscribe(s2 -> log.debug("No connection in registry to guild {}", guildId.asLong())));
    }

    @Override
    public Mono<Void> registerVoiceConnection(Snowflake guildId, VoiceConnection voiceConnection) {
        return Mono.fromCallable(() -> this.voiceConnections.put(guildId.asLong(), voiceConnection)).flatMap(previous -> {
            if (!previous.equals(voiceConnection)) {
                log.debug("Removing previous guild {} connection from registry", guildId.asLong());
                return previous.disconnect();
            }
            return Mono.empty();
        }).doFinally(signal -> log.debug("Connection registry to guild {} done after {}", guildId.asLong(), signal));
    }

    @Override
    public Mono<Void> disconnect(Snowflake guildId) {
        return this.getVoiceConnection(guildId).flatMap(connection -> connection.disconnect().doFinally(signal -> {
            this.voiceConnections.remove(guildId.asLong());
            log.debug("Connection registry to guild {} removed after {}", guildId.asLong(), signal);
        }));
    }
}

