/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.legacy;

import discord4j.common.store.api.layout.DataAccessor;
import discord4j.common.store.api.layout.GatewayDataUpdater;
import discord4j.common.store.api.layout.StoreLayout;
import discord4j.common.store.api.object.InvalidationCause;
import discord4j.common.store.api.object.PresenceAndUserData;
import discord4j.common.store.legacy.ListUtil;
import discord4j.common.store.legacy.StateHolder;
import discord4j.common.util.Snowflake;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ClientStatusData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildCreateData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.ImmutableGuildData;
import discord4j.discordjson.json.ImmutableMemberData;
import discord4j.discordjson.json.ImmutableMessageData;
import discord4j.discordjson.json.ImmutablePresenceData;
import discord4j.discordjson.json.ImmutableReactionData;
import discord4j.discordjson.json.ImmutableUserData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.PartialMessageData;
import discord4j.discordjson.json.PartialStickerData;
import discord4j.discordjson.json.PartialUserData;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.ReactionData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleDataFields;
import discord4j.discordjson.json.StageInstanceData;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.ChannelCreate;
import discord4j.discordjson.json.gateway.ChannelDelete;
import discord4j.discordjson.json.gateway.ChannelUpdate;
import discord4j.discordjson.json.gateway.GuildCreate;
import discord4j.discordjson.json.gateway.GuildDelete;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import discord4j.discordjson.json.gateway.GuildMemberAdd;
import discord4j.discordjson.json.gateway.GuildMemberRemove;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.GuildRoleCreate;
import discord4j.discordjson.json.gateway.GuildRoleDelete;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import discord4j.discordjson.json.gateway.GuildScheduledEventCreate;
import discord4j.discordjson.json.gateway.GuildScheduledEventDelete;
import discord4j.discordjson.json.gateway.GuildScheduledEventUpdate;
import discord4j.discordjson.json.gateway.GuildScheduledEventUserAdd;
import discord4j.discordjson.json.gateway.GuildScheduledEventUserRemove;
import discord4j.discordjson.json.gateway.GuildStickersUpdate;
import discord4j.discordjson.json.gateway.GuildUpdate;
import discord4j.discordjson.json.gateway.MessageCreate;
import discord4j.discordjson.json.gateway.MessageDelete;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.json.gateway.MessageReactionRemoveEmoji;
import discord4j.discordjson.json.gateway.MessageUpdate;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.StageInstanceCreate;
import discord4j.discordjson.json.gateway.StageInstanceDelete;
import discord4j.discordjson.json.gateway.StageInstanceUpdate;
import discord4j.discordjson.json.gateway.ThreadCreate;
import discord4j.discordjson.json.gateway.ThreadDelete;
import discord4j.discordjson.json.gateway.ThreadListSync;
import discord4j.discordjson.json.gateway.ThreadMemberUpdate;
import discord4j.discordjson.json.gateway.ThreadMembersUpdate;
import discord4j.discordjson.json.gateway.ThreadUpdate;
import discord4j.discordjson.json.gateway.UserUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdateDispatch;
import discord4j.discordjson.possible.Possible;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.LongLongTuple2;
import discord4j.store.api.util.LongObjTuple2;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.function.Tuples;

public class LegacyStoreLayout
implements StoreLayout,
DataAccessor,
GatewayDataUpdater {
    private static final Logger log = Loggers.getLogger(LegacyStoreLayout.class);
    private final StateHolder stateHolder;

    private LegacyStoreLayout(StoreService storeService) {
        this.stateHolder = new StateHolder(storeService);
    }

    public static LegacyStoreLayout of(StoreService storeService) {
        return new LegacyStoreLayout(storeService);
    }

    @Override
    public DataAccessor getDataAccessor() {
        return this;
    }

    @Override
    public GatewayDataUpdater getGatewayDataUpdater() {
        return this;
    }

    @Override
    public Mono<Long> countChannels() {
        return this.stateHolder.getChannelStore().count();
    }

    @Override
    public Mono<Long> countChannelsInGuild(long guildId) {
        return this.getChannelsInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countStickers() {
        return this.stateHolder.getGuildStickerStore().count();
    }

    @Override
    public Mono<Long> countStickersInGuild(long guildId) {
        return this.getStickersInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countEmojis() {
        return this.stateHolder.getGuildEmojiStore().count();
    }

    @Override
    public Mono<Long> countEmojisInGuild(long guildId) {
        return this.getEmojisInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countGuilds() {
        return this.stateHolder.getGuildStore().count();
    }

    @Override
    public Mono<Long> countMembers() {
        return this.stateHolder.getMemberStore().count();
    }

    @Override
    public Mono<Long> countMembersInGuild(long guildId) {
        return this.getMembersInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countExactMembersInGuild(long guildId) {
        return this.countMembersInGuild(guildId);
    }

    @Override
    public Mono<Long> countMessages() {
        return this.stateHolder.getMessageStore().count();
    }

    @Override
    public Mono<Long> countMessagesInChannel(long channelId) {
        return this.getMessagesInChannel(channelId).count();
    }

    @Override
    public Mono<Long> countPresences() {
        return this.stateHolder.getPresenceStore().count();
    }

    @Override
    public Mono<Long> countPresencesInGuild(long guildId) {
        return this.getPresencesInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countRoles() {
        return this.stateHolder.getRoleStore().count();
    }

    @Override
    public Mono<Long> countRolesInGuild(long guildId) {
        return this.getRolesInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countUsers() {
        return this.stateHolder.getUserStore().count();
    }

    @Override
    public Mono<Long> countVoiceStates() {
        return this.stateHolder.getVoiceStateStore().count();
    }

    @Override
    public Mono<Long> countVoiceStatesInGuild(long guildId) {
        return this.getVoiceStatesInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countVoiceStatesInChannel(long guildId, long channelId) {
        return this.getVoiceStatesInChannel(guildId, channelId).count();
    }

    @Override
    public Flux<ChannelData> getChannels() {
        return this.stateHolder.getChannelStore().values();
    }

    @Override
    public Flux<ChannelData> getChannelsInGuild(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromStream(guild.channels().stream().map(Snowflake::asLong))).flatMap(id -> this.stateHolder.getChannelStore().find((Long)id));
    }

    @Override
    public Mono<ChannelData> getChannelById(long channelId) {
        return this.stateHolder.getChannelStore().find(channelId);
    }

    @Override
    public Flux<StickerData> getStickers() {
        return this.stateHolder.getGuildStickerStore().values();
    }

    @Override
    public Flux<StickerData> getStickersInGuild(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromStream(guild.stickers().toOptional().orElse(Collections.emptyList()).stream().map(Snowflake::asLong))).flatMap(id -> this.stateHolder.getGuildStickerStore().find((Long)id));
    }

    @Override
    public Mono<StickerData> getStickerById(long guildId, long stickerId) {
        return this.stateHolder.getGuildStickerStore().find(stickerId);
    }

    @Override
    public Flux<EmojiData> getEmojis() {
        return this.stateHolder.getGuildEmojiStore().values();
    }

    @Override
    public Flux<EmojiData> getEmojisInGuild(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromStream(guild.emojis().stream().map(Snowflake::asLong))).flatMap(id -> this.stateHolder.getGuildEmojiStore().find((Long)id));
    }

    @Override
    public Mono<EmojiData> getEmojiById(long guildId, long emojiId) {
        return this.stateHolder.getGuildEmojiStore().find(emojiId);
    }

    @Override
    public Flux<GuildData> getGuilds() {
        return this.stateHolder.getGuildStore().values();
    }

    @Override
    public Mono<GuildData> getGuildById(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId);
    }

    @Override
    public Flux<GuildScheduledEventData> getScheduledEventsInGuild(long guildId) {
        return this.stateHolder.getGuildEventsStore().findInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, Long.MAX_VALUE));
    }

    @Override
    public Mono<GuildScheduledEventData> getScheduledEventById(long guildId, long eventId) {
        return this.stateHolder.getGuildEventsStore().find(LongLongTuple2.of(guildId, eventId));
    }

    @Override
    public Flux<Id> getScheduledEventUsersInEvent(long guildId, long eventId) {
        return this.stateHolder.getGuildEventsUsersStore().find(LongLongTuple2.of(guildId, eventId)).flatMapIterable(list -> list).map(value -> Id.of((Long)value));
    }

    @Override
    public Flux<MemberData> getMembers() {
        return this.stateHolder.getMemberStore().values();
    }

    @Override
    public Flux<MemberData> getMembersInGuild(long guildId) {
        return this.stateHolder.getMemberStore().findInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, Long.MAX_VALUE));
    }

    @Override
    public Flux<MemberData> getExactMembersInGuild(long guildId) {
        return this.stateHolder.getMemberStore().findInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, Long.MAX_VALUE));
    }

    @Override
    public Mono<MemberData> getMemberById(long guildId, long userId) {
        return this.stateHolder.getMemberStore().find(LongLongTuple2.of(guildId, userId));
    }

    @Override
    public Flux<MessageData> getMessages() {
        return this.stateHolder.getMessageStore().values();
    }

    @Override
    public Flux<MessageData> getMessagesInChannel(long channelId) {
        return this.stateHolder.getMessageStore().values().filter(data -> Snowflake.asLong(data.channelId()) == channelId);
    }

    @Override
    public Mono<MessageData> getMessageById(long channelId, long messageId) {
        return this.stateHolder.getMessageStore().find(messageId);
    }

    @Override
    public Flux<PresenceData> getPresences() {
        return this.stateHolder.getPresenceStore().values();
    }

    @Override
    public Flux<PresenceData> getPresencesInGuild(long guildId) {
        return this.stateHolder.getPresenceStore().findInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, Long.MAX_VALUE));
    }

    @Override
    public Mono<PresenceData> getPresenceById(long guildId, long userId) {
        return this.stateHolder.getPresenceStore().find(LongLongTuple2.of(guildId, userId));
    }

    @Override
    public Flux<RoleData> getRoles() {
        return this.stateHolder.getRoleStore().values();
    }

    @Override
    public Flux<RoleData> getRolesInGuild(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromStream(guild.roles().stream().map(Snowflake::asLong))).flatMap(id -> this.stateHolder.getRoleStore().find((Long)id));
    }

    @Override
    public Mono<RoleData> getRoleById(long guildId, long roleId) {
        return this.stateHolder.getRoleStore().find(roleId);
    }

    @Override
    public Flux<UserData> getUsers() {
        return this.stateHolder.getUserStore().values();
    }

    @Override
    public Mono<UserData> getUserById(long userId) {
        return this.stateHolder.getUserStore().find(userId);
    }

    @Override
    public Flux<VoiceStateData> getVoiceStates() {
        return this.stateHolder.getVoiceStateStore().values();
    }

    @Override
    public Flux<VoiceStateData> getVoiceStatesInChannel(long guildId, long channelId) {
        return this.stateHolder.getVoiceStateStore().findInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, Long.MAX_VALUE)).filter(data -> data.channelId().filter(id -> Snowflake.asLong(id) == channelId).isPresent());
    }

    @Override
    public Flux<VoiceStateData> getVoiceStatesInGuild(long guildId) {
        return this.stateHolder.getVoiceStateStore().findInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, Long.MAX_VALUE));
    }

    @Override
    public Mono<VoiceStateData> getVoiceStateById(long guildId, long userId) {
        return this.stateHolder.getVoiceStateStore().find(LongLongTuple2.of(guildId, userId));
    }

    @Override
    public Mono<StageInstanceData> getStageInstanceByChannelId(long channelId) {
        return this.stateHolder.getStageInstanceStore().find(channelId);
    }

    @Override
    public Mono<ThreadMemberData> getThreadMemberById(long threadId, long userId) {
        return this.stateHolder.getThreadMemberStore().find(LongLongTuple2.of(threadId, userId));
    }

    @Override
    public Flux<ThreadMemberData> getMembersInThread(long threadId) {
        return this.stateHolder.getThreadMemberStore().findInRange(LongLongTuple2.of(threadId, 0L), LongLongTuple2.of(threadId, Long.MAX_VALUE));
    }

    @Override
    public Mono<Void> onChannelCreate(int shardIndex, ChannelCreate dispatch) {
        Type type = Type.of(dispatch.channel().type());
        switch (type) {
            case GUILD_TEXT: 
            case GUILD_VOICE: 
            case GUILD_CATEGORY: 
            case GUILD_NEWS: 
            case GUILD_STORE: 
            case GUILD_STAGE_VOICE: {
                return this.saveChannel(dispatch);
            }
            case DM: 
            case GROUP_DM: {
                return Mono.empty();
            }
        }
        throw new IllegalArgumentException("Unhandled channel type " + dispatch.channel().type());
    }

    private Mono<Void> saveChannel(ChannelCreate data) {
        ChannelData channel = data.channel();
        Mono addChannelToGuild = this.stateHolder.getGuildStore().find(Snowflake.asLong(channel.guildId().get())).map(guildData -> GuildData.builder().from((GuildData)guildData).channels(ListUtil.add(guildData.channels(), channel.id())).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Snowflake.asLong(guild.id()), (GuildData)guild));
        Mono<Void> saveChannel = this.stateHolder.getChannelStore().save(Snowflake.asLong(channel.id()), channel);
        return addChannelToGuild.then(saveChannel);
    }

    @Override
    public Mono<ChannelData> onChannelDelete(int shardIndex, ChannelDelete dispatch) {
        Type type = Type.of(dispatch.channel().type());
        switch (type) {
            case GUILD_TEXT: 
            case GUILD_VOICE: 
            case GUILD_CATEGORY: 
            case GUILD_NEWS: 
            case GUILD_STORE: 
            case GUILD_STAGE_VOICE: {
                return this.deleteChannel(dispatch);
            }
            case DM: 
            case GROUP_DM: {
                return Mono.empty();
            }
        }
        throw new IllegalArgumentException("Unhandled channel type " + dispatch.channel().type());
    }

    private Mono<ChannelData> deleteChannel(ChannelDelete data) {
        ChannelData channel = data.channel();
        Mono removeChannelFromGuild = this.stateHolder.getGuildStore().find(Snowflake.asLong(channel.guildId().get())).map(guildData -> GuildData.builder().from((GuildData)guildData).channels(ListUtil.remove(guildData.channels(), ch -> channel.id().equals(ch))).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Snowflake.asLong(guild.id()), (GuildData)guild));
        Mono<Void> deleteChannel = this.stateHolder.getChannelStore().delete(Snowflake.asLong(channel.id()));
        return removeChannelFromGuild.then(deleteChannel).thenReturn(channel);
    }

    @Override
    public Mono<ChannelData> onChannelUpdate(int shardIndex, ChannelUpdate dispatch) {
        Type type = Type.of(dispatch.channel().type());
        switch (type) {
            case GUILD_TEXT: 
            case GUILD_VOICE: 
            case GUILD_CATEGORY: 
            case GUILD_NEWS: 
            case GUILD_STORE: 
            case GUILD_STAGE_VOICE: {
                return this.updateChannel(dispatch.channel());
            }
            case DM: 
            case GROUP_DM: {
                return Mono.empty();
            }
        }
        throw new IllegalArgumentException("Unhandled channel type " + dispatch.channel().type());
    }

    private Mono<ChannelData> updateChannel(ChannelData channel) {
        Mono<Void> saveNew = this.stateHolder.getChannelStore().save(Snowflake.asLong(channel.id()), channel);
        return this.stateHolder.getChannelStore().find(Snowflake.asLong(channel.id())).flatMap(saveNew::thenReturn).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<Void> onGuildCreate(int shardIndex, GuildCreate dispatch) {
        ImmutableGuildData guild;
        GuildCreateData createData;
        if (dispatch.guild().large()) {
            createData = GuildCreateData.builder().from(dispatch.guild()).members(Collections.emptyList()).build();
            guild = GuildData.builder().from(createData).roles(createData.roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(createData.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).channels(createData.channels().stream().map(ChannelData::id).collect(Collectors.toList())).build();
        } else {
            createData = dispatch.guild();
            guild = GuildData.builder().from(createData).roles(createData.roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(createData.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).members(createData.members().stream().map(data -> data.user().id()).distinct().collect(Collectors.toList())).channels(createData.channels().stream().map(ChannelData::id).collect(Collectors.toList())).build();
        }
        long guildId = Snowflake.asLong(guild.id());
        Mono<Void> saveGuild = this.stateHolder.getGuildStore().save(guildId, (GuildData)guild).doOnSubscribe(s2 -> log.trace("GuildCreate doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildCreate doFinally {}: {}", guildId, s2));
        Mono<Void> saveChannels = this.stateHolder.getChannelStore().save(Flux.fromIterable(createData.channels()).map(channel -> Tuples.of(Snowflake.asLong(channel.id()), ChannelData.builder().from((ChannelData)channel).guildId(guild.id()).build())));
        Mono<Void> saveRoles = this.stateHolder.getRoleStore().save(Flux.fromIterable(createData.roles()).map(role -> Tuples.of(Snowflake.asLong(role.id()), role)));
        Mono<Void> saveEmojis = this.stateHolder.getGuildEmojiStore().save(Flux.fromIterable(createData.emojis()).map(emoji -> Tuples.of(Snowflake.asLong(emoji.id().orElseThrow(NoSuchElementException::new)), emoji)));
        Mono<Void> saveMembers = this.stateHolder.getMemberStore().save(Flux.fromIterable(createData.members()).map(member -> Tuples.of(LongLongTuple2.of(guildId, Snowflake.asLong(member.user().id())), member)));
        Mono<Void> saveUsers = this.stateHolder.getUserStore().save(Flux.fromIterable(createData.members()).map(MemberData::user).map(user -> Tuples.of(Snowflake.asLong(user.id()), user)));
        Mono<Void> saveVoiceStates = this.stateHolder.getVoiceStateStore().save(Flux.fromIterable(createData.voiceStates()).map(voiceState -> Tuples.of(LongLongTuple2.of(guildId, Snowflake.asLong(voiceState.userId())), VoiceStateData.builder().from((VoiceStateData)voiceState).guildId(guild.id()).build())));
        Mono<Void> saveThreads = this.stateHolder.getChannelStore().save(Flux.fromIterable(createData.threads()).map(thread -> Tuples.of(Snowflake.asLong(thread.id()), thread)));
        Mono<Void> savePresences = this.stateHolder.getPresenceStore().save(Flux.fromIterable(createData.presences()).map(presence -> Tuples.of(LongLongTuple2.of(guildId, Snowflake.asLong(presence.user().id())), presence)));
        Mono<Void> saveOfflinePresences = Flux.fromIterable(createData.members()).filterWhen(member -> this.stateHolder.getPresenceStore().find(LongLongTuple2.of(guildId, Snowflake.asLong(member.user().id()))).hasElement().map(id -> id == false)).flatMap(member -> this.stateHolder.getPresenceStore().save(LongLongTuple2.of(guildId, Snowflake.asLong(member.user().id())), this.createPresence((MemberData)member))).then();
        return saveGuild.and(saveChannels).and(saveRoles).and(saveEmojis).and(saveMembers).and(saveUsers).and(saveVoiceStates).and(saveThreads).and(savePresences).and(saveOfflinePresences);
    }

    private PresenceData createPresence(MemberData member) {
        return PresenceData.builder().user(PartialUserData.builder().id(member.user().id()).globalName(Possible.of(member.user().globalName())).username(member.user().username()).discriminator(member.user().discriminator()).avatar(Possible.of(member.user().avatar())).bot(member.user().bot()).system(member.user().system()).mfaEnabled(member.user().mfaEnabled()).locale(member.user().locale()).verified(member.user().verified()).email(member.user().email().isAbsent() ? Possible.absent() : member.user().email().get().map(Possible::of).orElse(Possible.absent())).flags(member.user().flags()).premiumType(member.user().premiumType()).build()).status("offline").clientStatus(ClientStatusData.builder().desktop(Possible.absent()).mobile(Possible.absent()).web(Possible.absent()).build()).build();
    }

    @Override
    public Mono<GuildData> onGuildDelete(int shardIndex, GuildDelete dispatch) {
        long guildId = Snowflake.asLong(dispatch.guild().id());
        Mono<Void> deleteGuild = this.stateHolder.getGuildStore().delete(guildId);
        return this.stateHolder.getGuildStore().find(guildId).flatMap(guild -> {
            Flux<Long> channels = Flux.fromIterable(guild.channels()).map(Snowflake::asLong);
            Flux<Long> roles = Flux.fromIterable(guild.roles()).map(Snowflake::asLong);
            Flux<Long> emojis = Flux.fromIterable(guild.emojis()).map(Snowflake::asLong);
            Mono<Void> deleteChannels = this.stateHolder.getChannelStore().delete((Publisher<Long>)channels);
            Mono<Void> deleteRoles = this.stateHolder.getRoleStore().delete((Publisher<Long>)roles);
            Mono<Void> deleteEmojis = this.stateHolder.getGuildEmojiStore().delete((Publisher<Long>)emojis);
            Mono<Void> deleteMembers = this.stateHolder.getMemberStore().deleteInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, -1L));
            Mono<Void> deleteVoiceStates = this.stateHolder.getVoiceStateStore().deleteInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, -1L));
            Mono<Void> deletePresences = this.stateHolder.getPresenceStore().deleteInRange(LongLongTuple2.of(guildId, 0L), LongLongTuple2.of(guildId, -1L));
            return deleteChannels.and(deleteRoles).and(deleteEmojis).and(deleteMembers).and(deleteVoiceStates).and(deletePresences).thenReturn(guild);
        }).flatMap(deleteGuild::thenReturn);
    }

    @Override
    public Mono<Set<StickerData>> onGuildStickersUpdate(int shardIndex, GuildStickersUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        Mono updateGuildBean = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from((GuildData)guild).emojis(dispatch.stickers().stream().map(PartialStickerData::id).collect(Collectors.toList())).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(guildId, (GuildData)guild)).doOnSubscribe(s2 -> log.trace("GuildStickersUpdate doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildStickersUpdate doFinally {}: {}", guildId, s2));
        Mono<Void> saveStickers = this.stateHolder.getGuildStickerStore().saveWithLong(Flux.fromIterable(dispatch.stickers()).map(sticker -> LongObjTuple2.of(Snowflake.asLong(sticker.id()), sticker)));
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> updateGuildBean.and(saveStickers).thenMany(Flux.fromIterable(guild.stickers().toOptional().orElse(Collections.emptyList())).map(Snowflake::asLong).flatMap(id -> this.stateHolder.getGuildStickerStore().find((Long)id)))).collect(Collectors.toSet());
    }

    @Override
    public Mono<Set<EmojiData>> onGuildEmojisUpdate(int shardIndex, GuildEmojisUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        Mono updateGuildBean = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from((GuildData)guild).emojis(dispatch.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(guildId, (GuildData)guild)).doOnSubscribe(s2 -> log.trace("GuildEmojisUpdate doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildEmojisUpdate doFinally {}: {}", guildId, s2));
        Mono<Void> saveEmojis = this.stateHolder.getGuildEmojiStore().saveWithLong(Flux.fromIterable(dispatch.emojis()).map(emoji -> LongObjTuple2.of(emoji.id().map(Snowflake::asLong).orElseThrow(NoSuchElementException::new), emoji)));
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> updateGuildBean.and(saveEmojis).thenMany(Flux.fromIterable(guild.emojis()).map(Snowflake::asLong).flatMap(id -> this.stateHolder.getGuildEmojiStore().find((Long)id)))).collect(Collectors.toSet());
    }

    @Override
    public Mono<Void> onGuildMemberAdd(int shardIndex, GuildMemberAdd dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        MemberData member = dispatch.member();
        UserData user = member.user();
        long userId = Snowflake.asLong(user.id());
        Mono addMemberId = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from((GuildData)guild).members(ListUtil.add(guild.members(), member.user().id())).memberCount(guild.memberCount() + 1).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(guildId, (GuildData)guild)).doOnSubscribe(s2 -> log.trace("GuildMemberAdd doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildMemberAdd doFinally {}: {}", guildId, s2));
        Mono<Void> saveMember = this.stateHolder.getMemberStore().save(LongLongTuple2.of(guildId, userId), member);
        Mono<Void> saveUser = this.stateHolder.getUserStore().save(userId, user);
        return addMemberId.and(saveMember).and(saveUser);
    }

    @Override
    public Mono<MemberData> onGuildMemberRemove(int shardIndex, GuildMemberRemove dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        UserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        Mono removeMemberId = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from((GuildData)guild).members(ListUtil.remove(guild.members(), member -> member.equals(userData.id()))).memberCount(guild.memberCount() - 1).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(guildId, (GuildData)guild)).doOnSubscribe(s2 -> log.trace("GuildMemberRemove doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildMemberRemove doFinally {}: {}", guildId, s2));
        Mono member = this.stateHolder.getMemberStore().find(LongLongTuple2.of(guildId, userId));
        Mono<Void> deleteMember = this.stateHolder.getMemberStore().delete(LongLongTuple2.of(guildId, userId));
        Mono<Void> deletePresence = this.stateHolder.getPresenceStore().delete(LongLongTuple2.of(guildId, userId));
        Mono deleteOrphanUser = this.stateHolder.getMemberStore().keys().filter(key -> key.getT1() != guildId && key.getT2() == userId).hasElements().flatMap(hasMutualServers -> Mono.just(userId).filter(__ -> hasMutualServers == false).flatMap(this.stateHolder.getUserStore()::delete));
        return member.flatMap(value -> Mono.when(removeMemberId, deleteMember, deletePresence, deleteOrphanUser).thenReturn(value));
    }

    @Override
    public Mono<Void> onGuildMembersChunk(int shardIndex, GuildMembersChunk dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        List<MemberData> members = dispatch.members();
        Flux memberPairs = Flux.fromIterable(members).map(data -> Tuples.of(LongLongTuple2.of(guildId, Snowflake.asLong(data.user().id())), data));
        Flux userPairs = Flux.fromIterable(members).map(data -> Tuples.of(Snowflake.asLong(data.user().id()), data.user()));
        Mono addMemberIds = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from((GuildData)guild).members(ListUtil.addAllDistinct(guild.members(), members.stream().map(data -> data.user().id()).collect(Collectors.toList()))).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(guildId, (GuildData)guild)).doOnSubscribe(s2 -> log.trace("GuildMembersChunk doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildMembersChunk doFinally {}: {}", guildId, s2));
        Mono<Void> saveMembers = this.stateHolder.getMemberStore().save(memberPairs);
        Mono<Void> saveUsers = this.stateHolder.getUserStore().save(userPairs);
        Mono<Void> saveOfflinePresences = Flux.fromIterable(members).filterWhen(member -> this.stateHolder.getPresenceStore().find(LongLongTuple2.of(guildId, Snowflake.asLong(member.user().id()))).hasElement().map(identity -> identity == false)).flatMap(member -> this.stateHolder.getPresenceStore().save(LongLongTuple2.of(guildId, Snowflake.asLong(member.user().id())), this.createPresence((MemberData)member))).then();
        return addMemberIds.and(saveMembers).and(saveUsers).and(saveOfflinePresences);
    }

    @Override
    public Mono<MemberData> onGuildMemberUpdate(int shardIndex, GuildMemberUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        long memberId = Snowflake.asLong(dispatch.user().id());
        LongLongTuple2 key = LongLongTuple2.of(guildId, memberId);
        return this.stateHolder.getMemberStore().find(key).flatMap(oldMember -> {
            ImmutableMemberData newMember = MemberData.builder().from((MemberData)oldMember).roles(dispatch.roles().stream().map(Id::of).collect(Collectors.toList())).user(dispatch.user()).nick(dispatch.nick()).joinedAt(dispatch.joinedAt()).premiumSince(dispatch.premiumSince()).pending(dispatch.pending()).build();
            return this.stateHolder.getMemberStore().save(key, newMember).thenReturn(oldMember);
        });
    }

    @Override
    public Mono<Void> onGuildRoleCreate(int shardIndex, GuildRoleCreate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        RoleData role = dispatch.role();
        Mono addRoleId = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from((GuildData)guild).addRole(role.id()).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(guildId, (GuildData)guild)).doOnSubscribe(s2 -> log.trace("GuildRoleCreate doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildRoleCreate doFinally {}: {}", guildId, s2));
        Mono<Void> saveRole = this.stateHolder.getRoleStore().save(Snowflake.asLong(role.id()), role);
        return addRoleId.and(saveRole);
    }

    @Override
    public Mono<RoleData> onGuildRoleDelete(int shardIndex, GuildRoleDelete dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        long roleId = Snowflake.asLong(dispatch.roleId());
        Mono removeRoleId = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from((GuildData)guild).roles(ListUtil.remove(guild.roles(), role -> role.equals(dispatch.roleId()))).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(guildId, (GuildData)guild)).doOnSubscribe(s2 -> log.trace("GuildRoleDelete doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildRoleDelete doFinally {}: {}", guildId, s2));
        Mono<Void> deleteRole = this.stateHolder.getRoleStore().delete(roleId);
        Mono<Void> removeRoleFromMembers = this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromIterable(guild.members()).map(Snowflake::asLong)).flatMap(memberId -> this.stateHolder.getMemberStore().find(LongLongTuple2.of(guildId, memberId))).filter(member -> member.roles().contains(dispatch.roleId())).map(member -> MemberData.builder().from((MemberData)member).roles(ListUtil.remove(member.roles(), role -> role.equals(dispatch.roleId()))).build()).flatMap(member -> this.stateHolder.getMemberStore().save(LongLongTuple2.of(guildId, Snowflake.asLong(member.user().id())), (MemberData)member)).then();
        return this.stateHolder.getRoleStore().find(roleId).flatMap(removeRoleId::thenReturn).flatMap(deleteRole::thenReturn).flatMap(removeRoleFromMembers::thenReturn);
    }

    @Override
    public Mono<RoleData> onGuildRoleUpdate(int shardIndex, GuildRoleUpdate dispatch) {
        RoleData role = dispatch.role();
        long roleId = Snowflake.asLong(role.id());
        Mono<Void> saveNew = this.stateHolder.getRoleStore().save(roleId, role);
        return this.stateHolder.getRoleStore().find(roleId).flatMap(saveNew::thenReturn).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<Void> onGuildScheduledEventCreate(int shardIndex, GuildScheduledEventCreate dispatch) {
        LongLongTuple2 key = LongLongTuple2.of(dispatch.scheduledEvent().guildId().asLong(), dispatch.scheduledEvent().id().asLong());
        return this.stateHolder.getGuildEventsStore().save(key, dispatch.scheduledEvent());
    }

    @Override
    public Mono<GuildScheduledEventData> onGuildScheduledEventUpdate(int shardIndex, GuildScheduledEventUpdate dispatch) {
        LongLongTuple2 key = LongLongTuple2.of(dispatch.scheduledEvent().guildId().asLong(), dispatch.scheduledEvent().id().asLong());
        Mono<Void> saveNew = this.stateHolder.getGuildEventsStore().save(key, dispatch.scheduledEvent());
        return this.stateHolder.getGuildEventsStore().find(key).flatMap(saveNew::thenReturn).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<GuildScheduledEventData> onGuildScheduledEventDelete(int shardIndex, GuildScheduledEventDelete dispatch) {
        LongLongTuple2 key = LongLongTuple2.of(dispatch.scheduledEvent().guildId().asLong(), dispatch.scheduledEvent().id().asLong());
        Mono<Void> deletion = this.stateHolder.getGuildEventsStore().delete(key);
        return this.stateHolder.getGuildEventsStore().find(key).flatMap(deletion::thenReturn).switchIfEmpty(deletion.then(Mono.empty()));
    }

    @Override
    public Mono<Void> onGuildScheduledEventUserAdd(int shardIndex, GuildScheduledEventUserAdd dispatch) {
        LongLongTuple2 key = LongLongTuple2.of(dispatch.guildId().asLong(), dispatch.scheduledEventId().asLong());
        return this.stateHolder.getGuildEventsUsersStore().find(key).defaultIfEmpty(new HashSet()).map(set -> {
            set.add(dispatch.userId().asLong());
            return set;
        }).flatMap(set -> this.stateHolder.getGuildEventsUsersStore().save(key, (Set)set));
    }

    @Override
    public Mono<Void> onGuildScheduledEventUserRemove(int shardIndex, GuildScheduledEventUserRemove dispatch) {
        LongLongTuple2 key = LongLongTuple2.of(dispatch.guildId().asLong(), dispatch.scheduledEventId().asLong());
        return this.stateHolder.getGuildEventsUsersStore().find(key).defaultIfEmpty(new HashSet()).map(set -> {
            set.remove(dispatch.userId().asLong());
            return set;
        }).flatMap(set -> this.stateHolder.getGuildEventsUsersStore().save(key, (Set)set));
    }

    @Override
    public Mono<GuildData> onGuildUpdate(int shardIndex, GuildUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guild().id());
        return this.stateHolder.getGuildStore().find(guildId).flatMap(oldGuildData -> {
            ImmutableGuildData newGuildData = GuildData.builder().from((GuildData)oldGuildData).from(dispatch.guild()).roles(dispatch.guild().roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(dispatch.guild().emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).build();
            return this.stateHolder.getGuildStore().save(guildId, (GuildData)newGuildData).doOnSubscribe(s2 -> log.trace("GuildUpdate doOnSubscribe {}", guildId)).doFinally(s2 -> log.trace("GuildUpdate doFinally {}: {}", guildId, s2)).thenReturn(oldGuildData);
        });
    }

    @Override
    public Mono<Void> onShardInvalidation(int shardIndex, InvalidationCause cause) {
        return Mono.empty();
    }

    @Override
    public Mono<Void> onMessageCreate(int shardIndex, MessageCreate dispatch) {
        MessageData message = dispatch.message();
        long messageId = Snowflake.asLong(message.id());
        long channelId = Snowflake.asLong(message.channelId());
        Mono<Void> saveMessage = this.stateHolder.getMessageStore().save(messageId, message);
        Mono editLastMessageId = this.stateHolder.getChannelStore().find(channelId).map(channel -> ChannelData.builder().from((ChannelData)channel).lastMessageId(message.id()).build()).flatMap(channelBean -> this.stateHolder.getChannelStore().save(channelId, (ChannelData)channelBean));
        return saveMessage.and(editLastMessageId);
    }

    @Override
    public Mono<MessageData> onMessageDelete(int shardIndex, MessageDelete dispatch) {
        long messageId = Snowflake.asLong(dispatch.id());
        Mono<Void> deleteMessage = this.stateHolder.getMessageStore().delete(messageId);
        return this.stateHolder.getMessageStore().find(messageId).flatMap(deleteMessage::thenReturn);
    }

    @Override
    public Mono<Set<MessageData>> onMessageDeleteBulk(int shardIndex, MessageDeleteBulk dispatch) {
        List messageIds = dispatch.ids().stream().map(Snowflake::asLong).collect(Collectors.toList());
        Mono<Void> deleteMessages = this.stateHolder.getMessageStore().delete((Publisher<Long>)Flux.fromIterable(messageIds));
        return Flux.fromIterable(messageIds).flatMap(this.stateHolder.getMessageStore()::find).flatMap(deleteMessages::thenReturn).collect(Collectors.toSet());
    }

    @Override
    public Mono<Void> onMessageReactionAdd(int shardIndex, MessageReactionAdd dispatch) {
        long selfId = 0L;
        long userId = Snowflake.asLong(dispatch.userId());
        long messageId = Snowflake.asLong(dispatch.messageId());
        return this.stateHolder.getMessageStore().find(messageId).map(oldMessage -> {
            boolean me = Objects.equals(userId, selfId);
            ImmutableMessageData.Builder newMessageBuilder = MessageData.builder().from((MessageData)oldMessage);
            if (oldMessage.reactions().isAbsent()) {
                newMessageBuilder.addReaction(ReactionData.builder().count(1).me(me).emoji(dispatch.emoji()).build());
            } else {
                List<ReactionData> reactions = oldMessage.reactions().get();
                int i = this.indexOfReactionByEmojiData(reactions, dispatch.emoji());
                if (i < reactions.size()) {
                    ReactionData oldExisting = reactions.get(i);
                    ImmutableReactionData newExisting = ReactionData.builder().from(oldExisting).me(oldExisting.me() || me).count(oldExisting.count() + 1).build();
                    newMessageBuilder.reactions(ListUtil.replace(reactions, oldExisting, newExisting));
                } else {
                    ImmutableReactionData reaction = ReactionData.builder().emoji(dispatch.emoji()).me(me).count(1).build();
                    newMessageBuilder.reactions(ListUtil.add(reactions, reaction));
                }
            }
            return newMessageBuilder.build();
        }).flatMap(message -> this.stateHolder.getMessageStore().save(messageId, (MessageData)message));
    }

    @Override
    public Mono<Void> onMessageReactionRemove(int shardIndex, MessageReactionRemove dispatch) {
        long selfId = 0L;
        long userId = Snowflake.asLong(dispatch.userId());
        long messageId = Snowflake.asLong(dispatch.messageId());
        return this.stateHolder.getMessageStore().find(messageId).filter(message -> !message.reactions().isAbsent()).map(oldMessage -> {
            boolean me = Objects.equals(userId, selfId);
            ImmutableMessageData.Builder newMessageBuilder = MessageData.builder().from((MessageData)oldMessage);
            List<ReactionData> reactions = oldMessage.reactions().get();
            int i = this.indexOfReactionByEmojiData(reactions, dispatch.emoji());
            if (i < reactions.size()) {
                ReactionData existing = reactions.get(i);
                if (existing.count() - 1 == 0) {
                    newMessageBuilder.reactions(ListUtil.remove(reactions, reaction -> reaction.equals(existing)));
                } else {
                    ImmutableReactionData newExisting = ReactionData.builder().from(existing).count(existing.count() - 1).me(!me && existing.me()).build();
                    newMessageBuilder.reactions(ListUtil.replace(reactions, existing, newExisting));
                }
            }
            return newMessageBuilder.build();
        }).flatMap(message -> this.stateHolder.getMessageStore().save(messageId, (MessageData)message));
    }

    @Override
    public Mono<Void> onMessageReactionRemoveAll(int shardIndex, MessageReactionRemoveAll dispatch) {
        long messageId = Snowflake.asLong(dispatch.messageId());
        return this.stateHolder.getMessageStore().find(messageId).map(message -> MessageData.builder().from((MessageData)message).reactions(Possible.absent()).build()).flatMap(message -> this.stateHolder.getMessageStore().save(messageId, (MessageData)message));
    }

    @Override
    public Mono<Void> onMessageReactionRemoveEmoji(int shardIndex, MessageReactionRemoveEmoji dispatch) {
        long messageId = Snowflake.asLong(dispatch.messageId());
        return this.stateHolder.getMessageStore().find(messageId).filter(message -> !message.reactions().isAbsent()).map(oldMessage -> {
            ImmutableMessageData.Builder newMessageBuilder = MessageData.builder().from((MessageData)oldMessage);
            List<ReactionData> reactions = oldMessage.reactions().get();
            int i = this.indexOfReactionByEmojiData(reactions, dispatch.emoji());
            if (i < reactions.size()) {
                ReactionData existing = reactions.get(i);
                newMessageBuilder.reactions(ListUtil.remove(reactions, reaction -> reaction.equals(existing)));
            }
            return newMessageBuilder.build();
        }).flatMap(message -> this.stateHolder.getMessageStore().save(messageId, (MessageData)message));
    }

    private int indexOfReactionByEmojiData(List<ReactionData> reactions, EmojiData emojiData) {
        int i;
        for (i = 0; i < reactions.size(); ++i) {
            ReactionData r = reactions.get(i);
            boolean emojiHasId = emojiData.id().isPresent();
            if (emojiHasId && emojiData.id().equals(r.emoji().id()) || !emojiHasId && emojiData.name().equals(r.emoji().name())) break;
        }
        return i;
    }

    @Override
    public Mono<MessageData> onMessageUpdate(int shardIndex, MessageUpdate dispatch) {
        PartialMessageData messageData = dispatch.message();
        long messageId = Snowflake.asLong(messageData.id());
        return this.stateHolder.getMessageStore().find(messageId).flatMap(oldMessageData -> {
            boolean contentChanged = !messageData.content().isAbsent() && !Objects.equals(oldMessageData.content(), messageData.content().get());
            boolean embedsChanged = !Objects.equals(oldMessageData.embeds(), messageData.embeds());
            ImmutableMessageData newMessageData = MessageData.builder().from((MessageData)oldMessageData).content(messageData.content().toOptional().orElse(oldMessageData.content())).embeds(messageData.embeds()).mentions(messageData.mentions()).mentionRoles(messageData.mentionRoles()).mentionEveryone(messageData.mentionEveryone().toOptional().orElse(oldMessageData.mentionEveryone())).editedTimestamp(messageData.editedTimestamp()).build();
            return this.stateHolder.getMessageStore().save(messageId, (MessageData)newMessageData).thenReturn(oldMessageData);
        });
    }

    @Override
    public Mono<PresenceAndUserData> onPresenceUpdate(int shardIndex, PresenceUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        PartialUserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        LongLongTuple2 key = LongLongTuple2.of(guildId, userId);
        ImmutablePresenceData presenceData = PresenceData.builder().user(dispatch.user()).status(dispatch.status()).activities(dispatch.activities()).clientStatus(dispatch.clientStatus()).build();
        Mono<Void> saveNew = this.stateHolder.getPresenceStore().save(key, presenceData);
        Mono savePresence = this.stateHolder.getPresenceStore().find(key).flatMap(saveNew::thenReturn).map(Optional::of).switchIfEmpty(saveNew.thenReturn(Optional.empty()));
        Mono saveUser = this.stateHolder.getUserStore().find(userId).flatMap(oldUserData -> {
            ImmutableUserData newUserData = UserData.builder().from((UserData)oldUserData).globalName(userData.globalName().isAbsent() ? oldUserData.globalName() : Possible.flatOpt(userData.globalName())).username(userData.username().toOptional().orElse(oldUserData.username())).discriminator(userData.discriminator().toOptional().orElse(oldUserData.discriminator())).avatar(userData.avatar().isAbsent() ? oldUserData.avatar() : Possible.flatOpt(userData.avatar())).build();
            return this.stateHolder.getUserStore().save(userId, (UserData)newUserData).thenReturn(oldUserData);
        }).map(Optional::of).defaultIfEmpty(Optional.empty());
        return Mono.zip(savePresence, saveUser, (p, u) -> PresenceAndUserData.of(p.orElse(null), u.orElse(null)));
    }

    @Override
    public Mono<Void> onReady(Ready dispatch) {
        UserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        return this.stateHolder.getUserStore().save(userId, userData);
    }

    @Override
    public Mono<Void> onStageInstanceCreate(int shardIndex, StageInstanceCreate dispatch) {
        StageInstanceData stageInstance = dispatch.stageInstance();
        long channelId = Snowflake.asLong(stageInstance.id());
        return this.stateHolder.getStageInstanceStore().save(channelId, stageInstance);
    }

    @Override
    public Mono<StageInstanceData> onStageInstanceUpdate(int shardIndex, StageInstanceUpdate dispatch) {
        StageInstanceData stageInstance = dispatch.stageInstance();
        long channelId = Snowflake.asLong(stageInstance.id());
        Mono<Void> saveNew = this.stateHolder.getStageInstanceStore().save(channelId, stageInstance);
        return this.stateHolder.getStageInstanceStore().find(channelId).flatMap(saveNew::thenReturn).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<StageInstanceData> onStageInstanceDelete(int shardIndex, StageInstanceDelete dispatch) {
        StageInstanceData stageInstance = dispatch.stageInstance();
        long channelId = Snowflake.asLong(stageInstance.id());
        Mono<Void> delete = this.stateHolder.getStageInstanceStore().delete(channelId);
        return this.stateHolder.getStageInstanceStore().find(channelId).flatMap(delete::thenReturn).switchIfEmpty(delete.then(Mono.empty()));
    }

    @Override
    public Mono<UserData> onUserUpdate(int shardIndex, UserUpdate dispatch) {
        UserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        Mono<Void> saveNew = this.stateHolder.getUserStore().save(userId, userData);
        return this.stateHolder.getUserStore().find(userId).flatMap(saveNew::thenReturn).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<VoiceStateData> onVoiceStateUpdateDispatch(int shardIndex, VoiceStateUpdateDispatch dispatch) {
        VoiceStateData voiceStateData = dispatch.voiceState();
        long guildId = Snowflake.asLong(voiceStateData.guildId().get());
        long userId = Snowflake.asLong(voiceStateData.userId());
        LongLongTuple2 key = LongLongTuple2.of(guildId, userId);
        Mono<Void> saveNewOrRemove = voiceStateData.channelId().isPresent() ? this.stateHolder.getVoiceStateStore().save(key, voiceStateData) : this.stateHolder.getVoiceStateStore().delete(key);
        return this.stateHolder.getVoiceStateStore().find(key).flatMap(saveNewOrRemove::thenReturn).switchIfEmpty(saveNewOrRemove.then(Mono.empty()));
    }

    @Override
    public Mono<Void> onGuildMembersCompletion(long guildId) {
        return Mono.empty();
    }

    @Override
    public Mono<Void> onThreadCreate(int shardIndex, ThreadCreate dispatch) {
        return this.stateHolder.getChannelStore().save(dispatch.thread().id().asLong(), dispatch.thread());
    }

    @Override
    public Mono<ChannelData> onThreadUpdate(int shardIndex, ThreadUpdate dispatch) {
        return this.updateChannel(dispatch.thread());
    }

    @Override
    public Mono<Void> onThreadDelete(int shardIndex, ThreadDelete dispatch) {
        long threadId = Snowflake.asLong(dispatch.thread().id());
        Mono<Void> deleteThread = this.stateHolder.getChannelStore().delete(threadId);
        Mono<Void> deleteThreadMembers = this.stateHolder.getThreadMemberStore().deleteInRange(LongLongTuple2.of(threadId, 0L), LongLongTuple2.of(threadId, -1L));
        return deleteThread.and(deleteThreadMembers);
    }

    @Override
    public Mono<Void> onThreadListSync(int shardIndex, ThreadListSync dispatch) {
        Mono<Void> saveThreads = Flux.fromIterable(dispatch.threads()).flatMap(thread -> this.stateHolder.getChannelStore().save(thread.id().asLong(), (ChannelData)thread)).then();
        Mono<Void> saveThreadMembers = Flux.fromIterable(dispatch.members()).flatMap(threadMember -> {
            LongLongTuple2 id = LongLongTuple2.of(threadMember.id().get().asLong(), threadMember.userId().get().asLong());
            return this.stateHolder.getThreadMemberStore().save(id, (ThreadMemberData)threadMember);
        }).then();
        return saveThreads.and(saveThreadMembers);
    }

    @Override
    public Mono<ThreadMemberData> onThreadMemberUpdate(int shardIndex, ThreadMemberUpdate dispatch) {
        ThreadMemberData member = dispatch.member();
        LongLongTuple2 id = LongLongTuple2.of(member.id().get().asLong(), member.userId().get().asLong());
        Mono<Void> saveNew = this.stateHolder.getThreadMemberStore().save(id, member);
        return this.stateHolder.getThreadMemberStore().find(id).flatMap(saveNew::thenReturn).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<List<ThreadMemberData>> onThreadMembersUpdate(int shardIndex, ThreadMembersUpdate dispatch) {
        Mono<Void> addThreadMembers = Mono.justOrEmpty(dispatch.addedMembers().toOptional()).flatMapIterable(it -> it).flatMap(threadMember -> {
            LongLongTuple2 id = LongLongTuple2.of(threadMember.id().get().asLong(), threadMember.userId().get().asLong());
            return this.stateHolder.getThreadMemberStore().save(id, (ThreadMemberData)threadMember);
        }).then();
        long threadId = dispatch.id().asLong();
        Mono removeThreadMembers = Mono.justOrEmpty(dispatch.removedMemberIds().toOptional()).flatMapIterable(it -> it).map(id -> LongLongTuple2.of(threadId, id.asLong())).flatMap(id -> {
            Mono<Void> delete = this.stateHolder.getThreadMemberStore().delete((LongLongTuple2)id);
            return this.stateHolder.getThreadMemberStore().find((LongLongTuple2)id).flatMap(delete::thenReturn).switchIfEmpty(delete.then(Mono.empty()));
        }).collectList();
        return addThreadMembers.then(removeThreadMembers);
    }

    private static enum Type {
        UNKNOWN(-1),
        GUILD_TEXT(0),
        DM(1),
        GUILD_VOICE(2),
        GROUP_DM(3),
        GUILD_CATEGORY(4),
        GUILD_NEWS(5),
        GUILD_STORE(6),
        GUILD_NEWS_THREAD(10),
        GUILD_PUBLIC_THREAD(11),
        GUILD_PRIVATE_THREAD(12),
        GUILD_STAGE_VOICE(13);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 0: {
                    return GUILD_TEXT;
                }
                case 1: {
                    return DM;
                }
                case 2: {
                    return GUILD_VOICE;
                }
                case 3: {
                    return GROUP_DM;
                }
                case 4: {
                    return GUILD_CATEGORY;
                }
                case 5: {
                    return GUILD_NEWS;
                }
                case 6: {
                    return GUILD_STORE;
                }
                case 10: {
                    return GUILD_NEWS_THREAD;
                }
                case 11: {
                    return GUILD_PUBLIC_THREAD;
                }
                case 12: {
                    return GUILD_PRIVATE_THREAD;
                }
                case 13: {
                    return GUILD_STAGE_VOICE;
                }
            }
            return UNKNOWN;
        }
    }
}

