/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.VoiceState;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.StageInstance;
import discord4j.core.object.entity.channel.AudioChannel;
import discord4j.core.object.entity.channel.BaseTopLevelGuildChannel;
import discord4j.core.object.entity.channel.CategorizableChannel;
import discord4j.core.spec.StageChannelEditMono;
import discord4j.core.spec.StageChannelEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.StageInstanceCreateRequest;
import discord4j.discordjson.json.StageInstanceData;
import discord4j.rest.http.client.ClientException;
import discord4j.voice.VoiceConnection;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class StageChannel
extends BaseTopLevelGuildChannel
implements AudioChannel,
CategorizableChannel {
    public StageChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    public StageChannelEditMono edit() {
        return StageChannelEditMono.of(this);
    }

    public Mono<StageChannel> edit(StageChannelEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(StageChannel.class);
    }

    public Mono<Boolean> isSpeaker(Snowflake memberId) {
        return this.getSpeakers().map(VoiceState::getUserId).any(memberId::equals);
    }

    @Override
    public Mono<VoiceConnection> getVoiceConnection() {
        return this.getGuild().flatMap(Guild::getVoiceConnection).filterWhen(voiceConnection -> voiceConnection.getChannelId().map(channelId -> channelId.equals(this.getId())));
    }

    public Flux<VoiceState> getRequestsToSpeak() {
        return this.getVoiceStates().filter(voiceState -> voiceState.getRequestedToSpeakAt().isPresent());
    }

    public Flux<VoiceState> getSpeakers() {
        return this.getVoiceStates().filter(voiceState -> !voiceState.isSuppressed() && !voiceState.getRequestedToSpeakAt().isPresent());
    }

    public Mono<Boolean> isStageLive() {
        return this.getClient().getRestClient().getStageInstanceService().getStageInstance(this.getId().asLong()).onErrorResume(ClientException.isStatusCode(404), e -> Mono.empty()).hasElement();
    }

    public Mono<StageInstance> startStageLive(String topic, @Nullable String reason) {
        return this.getClient().getRestClient().getStageInstanceService().createStageInstance(StageInstanceCreateRequest.builder().channelId(this.getId().asLong()).topic(topic).build(), reason).map(stageInstanceData -> new StageInstance(this.getClient(), (StageInstanceData)stageInstanceData));
    }

    @Override
    public String toString() {
        return "StageChannel{} " + super.toString();
    }
}

