/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.audit.ActionType;
import discord4j.core.spec.AuditLogQuerySpecGenerator;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="AuditLogQuerySpecGenerator", generator="Immutables")
public final class AuditLogQuerySpec
implements AuditLogQuerySpecGenerator {
    @Nullable
    private final Snowflake userId;
    @Nullable
    private final ActionType actionType;
    @Nullable
    private final Snowflake before;
    @Nullable
    private final Integer limit;
    private static final AuditLogQuerySpec INSTANCE = AuditLogQuerySpec.validate(new AuditLogQuerySpec());

    private AuditLogQuerySpec() {
        this.userId = null;
        this.actionType = null;
        this.before = null;
        this.limit = null;
    }

    private AuditLogQuerySpec(@Nullable Snowflake userId, @Nullable ActionType actionType, @Nullable Snowflake before, @Nullable Integer limit) {
        this.userId = userId;
        this.actionType = actionType;
        this.before = before;
        this.limit = limit;
    }

    @Override
    @Nullable
    public Snowflake userId() {
        return this.userId;
    }

    @Override
    @Nullable
    public ActionType actionType() {
        return this.actionType;
    }

    @Override
    @Nullable
    public Snowflake before() {
        return this.before;
    }

    @Override
    @Nullable
    public Integer limit() {
        return this.limit;
    }

    public final AuditLogQuerySpec withUserId(@Nullable Snowflake value) {
        if (this.userId == value) {
            return this;
        }
        return AuditLogQuerySpec.validate(new AuditLogQuerySpec(value, this.actionType, this.before, this.limit));
    }

    public final AuditLogQuerySpec withActionType(@Nullable ActionType value) {
        if (this.actionType == value) {
            return this;
        }
        return AuditLogQuerySpec.validate(new AuditLogQuerySpec(this.userId, value, this.before, this.limit));
    }

    public final AuditLogQuerySpec withBefore(@Nullable Snowflake value) {
        if (this.before == value) {
            return this;
        }
        return AuditLogQuerySpec.validate(new AuditLogQuerySpec(this.userId, this.actionType, value, this.limit));
    }

    public final AuditLogQuerySpec withLimit(@Nullable Integer value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return AuditLogQuerySpec.validate(new AuditLogQuerySpec(this.userId, this.actionType, this.before, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuditLogQuerySpec && this.equalTo(0, (AuditLogQuerySpec)another);
    }

    private boolean equalTo(int synthetic, AuditLogQuerySpec another) {
        return Objects.equals(this.userId, another.userId) && Objects.equals((Object)this.actionType, (Object)another.actionType) && Objects.equals(this.before, another.before) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.userId);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.actionType);
        h2 += (h2 << 5) + Objects.hashCode(this.before);
        h2 += (h2 << 5) + Objects.hashCode(this.limit);
        return h2;
    }

    public String toString() {
        return "AuditLogQuerySpec{userId=" + this.userId + ", actionType=" + (Object)((Object)this.actionType) + ", before=" + this.before + ", limit=" + this.limit + "}";
    }

    public static AuditLogQuerySpec create() {
        return INSTANCE;
    }

    private static AuditLogQuerySpec validate(AuditLogQuerySpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static AuditLogQuerySpec copyOf(AuditLogQuerySpecGenerator instance) {
        if (instance instanceof AuditLogQuerySpec) {
            return (AuditLogQuerySpec)instance;
        }
        return AuditLogQuerySpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuditLogQuerySpecGenerator", generator="Immutables")
    public static final class Builder {
        private Snowflake userId;
        private ActionType actionType;
        private Snowflake before;
        private Integer limit;

        private Builder() {
        }

        public final Builder from(AuditLogQuerySpec instance) {
            return this.from((AuditLogQuerySpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(AuditLogQuerySpecGenerator instance) {
            Integer limitValue;
            Snowflake beforeValue;
            ActionType actionTypeValue;
            Objects.requireNonNull(instance, "instance");
            Snowflake userIdValue = instance.userId();
            if (userIdValue != null) {
                this.userId(userIdValue);
            }
            if ((actionTypeValue = instance.actionType()) != null) {
                this.actionType(actionTypeValue);
            }
            if ((beforeValue = instance.before()) != null) {
                this.before(beforeValue);
            }
            if ((limitValue = instance.limit()) != null) {
                this.limit(limitValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userId(@Nullable Snowflake userId) {
            this.userId = userId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder actionType(@Nullable ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder before(@Nullable Snowflake before) {
            this.before = before;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public AuditLogQuerySpec build() {
            return AuditLogQuerySpec.validate(new AuditLogQuerySpec(this.userId, this.actionType, this.before, this.limit));
        }
    }
}

