/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.domain.StageInstanceCreateEvent;
import discord4j.core.event.domain.StageInstanceDeleteEvent;
import discord4j.core.event.domain.StageInstanceUpdateEvent;
import discord4j.core.object.entity.StageInstance;
import discord4j.discordjson.json.StageInstanceData;
import discord4j.discordjson.json.gateway.StageInstanceCreate;
import discord4j.discordjson.json.gateway.StageInstanceDelete;
import discord4j.discordjson.json.gateway.StageInstanceUpdate;
import reactor.core.publisher.Mono;

class StageInstanceDispatchHandlers {
    StageInstanceDispatchHandlers() {
    }

    static Mono<StageInstanceCreateEvent> stageInstanceCreate(DispatchContext<StageInstanceCreate, StageInstanceData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        StageInstanceData stageInstanceData = context.getDispatch().stageInstance();
        StageInstance stageInstance = new StageInstance(gateway, stageInstanceData);
        return Mono.just(new StageInstanceCreateEvent(gateway, context.getShardInfo(), stageInstance));
    }

    static Mono<StageInstanceUpdateEvent> stageInstanceUpdate(DispatchContext<StageInstanceUpdate, StageInstanceData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        StageInstanceData currentData = context.getDispatch().stageInstance();
        StageInstance current = new StageInstance(gateway, currentData);
        return Mono.just(new StageInstanceUpdateEvent(gateway, context.getShardInfo(), current, context.getOldState().map(old -> new StageInstance(gateway, (StageInstanceData)old)).orElse(null)));
    }

    static Mono<StageInstanceDeleteEvent> stageInstanceDelete(DispatchContext<StageInstanceDelete, StageInstanceData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        StageInstanceData stageInstanceData = context.getDispatch().stageInstance();
        StageInstance stageInstance = new StageInstance(gateway, stageInstanceData);
        return Mono.just(new StageInstanceDeleteEvent(gateway, context.getShardInfo(), stageInstance));
    }
}

