/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.VoiceChannelCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="VoiceChannelCreateMonoGenerator", generator="Immutables")
public final class VoiceChannelCreateMono
extends VoiceChannelCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final Integer bitrate_value;
    private final boolean bitrate_absent;
    private final Integer userLimit_value;
    private final boolean userLimit_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private VoiceChannelCreateMono(String name, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible bitrate$impl = Possible.absent();
        Possible userLimit$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        this.bitrate_value = bitrate$impl.toOptional().orElse(null);
        this.bitrate_absent = bitrate$impl.isAbsent();
        this.userLimit_value = userLimit$impl.toOptional().orElse(null);
        this.userLimit_absent = userLimit$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    private VoiceChannelCreateMono(@Nullable String reason, String name, Possible<Integer> bitrate, Possible<Integer> userLimit, Possible<Integer> position, Possible<Integer> rateLimitPerUser, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Snowflake> parentId, Guild guild) {
        this.reason = reason;
        this.name = name;
        Possible<Integer> bitrate$impl = bitrate;
        Possible<Integer> userLimit$impl = userLimit;
        Possible<Integer> position$impl = position;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible<Snowflake> parentId$impl = parentId;
        this.guild = guild;
        this.bitrate_value = bitrate$impl.toOptional().orElse(null);
        this.bitrate_absent = bitrate$impl.isAbsent();
        this.userLimit_value = userLimit$impl.toOptional().orElse(null);
        this.userLimit_absent = userLimit$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Integer> bitrate() {
        return this.bitrate_absent ? Possible.absent() : Possible.of(this.bitrate_value);
    }

    @Override
    public Possible<Integer> userLimit() {
        return this.userLimit_absent ? Possible.absent() : Possible.of(this.userLimit_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Snowflake> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(this.parentId_value);
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final VoiceChannelCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new VoiceChannelCreateMono(value, this.name, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public final VoiceChannelCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new VoiceChannelCreateMono(this.reason, newValue, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withBitrate(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new VoiceChannelCreateMono(this.reason, this.name, newValue, this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withBitrate(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new VoiceChannelCreateMono(this.reason, this.name, newValue, this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withUserLimit(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), newValue, this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withUserLimit(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), newValue, this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), newValue, this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), newValue, this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), this.position(), newValue, this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), this.position(), newValue, this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.guild);
    }

    @SafeVarargs
    public final VoiceChannelCreateMono withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.guild);
    }

    public VoiceChannelCreateMono withParentId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue, this.guild);
    }

    public VoiceChannelCreateMono withParentId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue, this.guild);
    }

    public final VoiceChannelCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new VoiceChannelCreateMono(this.reason, this.name, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VoiceChannelCreateMono && this.equalTo(0, (VoiceChannelCreateMono)another);
    }

    private boolean equalTo(int synthetic, VoiceChannelCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.bitrate().equals(another.bitrate()) && this.userLimit().equals(another.userLimit()) && this.position().equals(another.position()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.bitrate().hashCode();
        h2 += (h2 << 5) + this.userLimit().hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.parentId().hashCode();
        h2 += (h2 << 5) + this.guild.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "VoiceChannelCreateMono{reason=" + this.reason + ", name=" + this.name + ", bitrate=" + this.bitrate().toString() + ", userLimit=" + this.userLimit().toString() + ", position=" + this.position().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + ", guild=" + this.guild + "}";
    }

    public static VoiceChannelCreateMono of(String name, Guild guild) {
        return new VoiceChannelCreateMono(name, guild);
    }

    static VoiceChannelCreateMono copyOf(VoiceChannelCreateMonoGenerator instance) {
        if (instance instanceof VoiceChannelCreateMono) {
            return (VoiceChannelCreateMono)instance;
        }
        return VoiceChannelCreateMono.of(instance.name(), instance.guild()).withReason(instance.reason()).withBitrate(instance.bitrate()).withUserLimit(instance.userLimit()).withPosition(instance.position()).withRateLimitPerUser(instance.rateLimitPerUser()).withPermissionOverwrites(instance.permissionOverwrites()).withParentId(instance.parentId());
    }

    public boolean isBitratePresent() {
        return !this.bitrate_absent;
    }

    public Integer bitrateOrElse(Integer defaultValue) {
        return !this.bitrate_absent ? this.bitrate_value : defaultValue;
    }

    public boolean isUserLimitPresent() {
        return !this.userLimit_absent;
    }

    public Integer userLimitOrElse(Integer defaultValue) {
        return !this.userLimit_absent ? this.userLimit_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    @Generated(from="VoiceChannelCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build VoiceChannelCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

