/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.common.ReactorResources;
import discord4j.rest.http.client.ClientResponse;
import discord4j.rest.http.client.DiscordWebClient;
import discord4j.rest.request.BucketKey;
import discord4j.rest.request.DiscardedRequestException;
import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.request.DiscordWebResponse;
import discord4j.rest.request.RequestCorrelation;
import discord4j.rest.request.RequestStream;
import discord4j.rest.request.ResponseHeaderStrategy;
import discord4j.rest.request.Router;
import discord4j.rest.request.RouterOptions;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.ContextView;

public class DefaultRouter
implements Router {
    private static final Logger log = Loggers.getLogger(DefaultRouter.class);
    private static final ResponseHeaderStrategy HEADER_STRATEGY = new ResponseHeaderStrategy();
    private static final Duration HOUSE_KEEPING_PERIOD = Duration.ofSeconds(30L);
    private final ReactorResources reactorResources;
    private final DiscordWebClient httpClient;
    private final Map<BucketKey, RequestStream> streamMap = new ConcurrentHashMap<BucketKey, RequestStream>();
    private final RouterOptions routerOptions;
    private final AtomicBoolean isHousekeeping = new AtomicBoolean(false);
    private volatile Instant lastHousekeepingTime = Instant.EPOCH;

    public DefaultRouter(RouterOptions routerOptions) {
        this.routerOptions = routerOptions;
        this.reactorResources = routerOptions.getReactorResources();
        this.httpClient = new DiscordWebClient(this.reactorResources.getHttpClient(), routerOptions.getExchangeStrategies(), routerOptions.getAuthorizationScheme(), routerOptions.getToken(), routerOptions.getResponseTransformers(), routerOptions.getDiscordBaseUrl());
    }

    @Override
    public DiscordWebResponse exchange(DiscordWebRequest request) {
        Sinks.Empty cancelSink = Sinks.empty();
        return new DiscordWebResponse(Mono.deferContextual(ctx -> {
            Sinks.One callback = Sinks.one();
            this.housekeepIfNecessary();
            BucketKey bucketKey = BucketKey.of(request);
            RequestStream stream = this.streamMap.computeIfAbsent(bucketKey, key -> this.createStream((BucketKey)key, request));
            if (!stream.push(new RequestCorrelation<ClientResponse>(request, callback, (ContextView)ctx, cancelSink))) {
                callback.emitError(new DiscardedRequestException(request), Sinks.EmitFailureHandler.FAIL_FAST);
            }
            return callback.asMono();
        }).doOnCancel(() -> cancelSink.emitEmpty(Sinks.EmitFailureHandler.FAIL_FAST)).checkpoint("Request to " + request.getDescription() + " [DefaultRouter]"), this.reactorResources);
    }

    private RequestStream createStream(BucketKey bucketKey, DiscordWebRequest request) {
        if (log.isTraceEnabled()) {
            log.trace("Creating RequestStream with key {} for request: {} -> {}", bucketKey, request.getRoute().getUriTemplate(), request.getCompleteUri());
        }
        RequestStream stream = new RequestStream(bucketKey, this.routerOptions, this.httpClient, HEADER_STRATEGY);
        stream.start();
        return stream;
    }

    private void housekeepIfNecessary() {
        Instant now = Instant.now();
        if (this.lastHousekeepingTime.plus(HOUSE_KEEPING_PERIOD).isAfter(now)) {
            return;
        }
        this.tryHousekeep(now);
    }

    private void tryHousekeep(Instant now) {
        if (this.isHousekeeping.compareAndSet(false, true)) {
            try {
                this.doHousekeep(now);
            }
            finally {
                this.lastHousekeepingTime = Instant.now();
                this.isHousekeeping.set(false);
            }
        }
    }

    private void doHousekeep(Instant now) {
        this.streamMap.keySet().forEach(key -> this.streamMap.compute((BucketKey)key, (bucketKey, stream) -> {
            if (stream == null) {
                return null;
            }
            if (stream.getResetAt().isBefore(now) && stream.countRequestsInFlight() < 1L) {
                if (log.isTraceEnabled()) {
                    log.trace("Evicting RequestStream with bucket ID {}", bucketKey);
                }
                stream.stop();
                return null;
            }
            return stream;
        }));
    }
}

