/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.annotation.Requireds;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.discord.ButtonAction;
import com.gmail.berndivader.streamserver.discord.command.Command;
import com.gmail.berndivader.streamserver.discord.permission.Permission;
import com.gmail.berndivader.streamserver.discord.permission.Permissions;
import com.gmail.berndivader.streamserver.discord.permission.User;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.mysql.MakeDownloadable;
import com.gmail.berndivader.streamserver.term.ANSI;
import discord4j.core.event.domain.interaction.ButtonInteractionEvent;
import discord4j.core.object.component.ActionRow;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.spec.EmbedCreateFields;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpec;
import discord4j.core.spec.MessageEditSpec;
import discord4j.rest.util.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

@Permission(required=User.Rank.MEMBER)
@DiscordCommand(name="dl", usage="Download media: .dl [--music][--temp][--link][--click] <valid_url>", requireds={Requireds.DATABASE})
public class DownloadMedia
extends Command<Void> {
    @Override
    public Mono<Void> exec() {
        return Mono.fromRunnable(new ProcessRunnable(this.string, this.channel));
    }

    private class ProcessRunnable
    implements Runnable {
        private String line;
        private final MessageChannel channel;
        private final String uuid;
        private Status status = Status.NONE;

        public ProcessRunnable(String line, MessageChannel channel) {
            this.line = line;
            this.channel = channel;
            this.uuid = UUID.randomUUID().toString();
        }

        @Override
        public void run() {
            Optional<File> opt = Helper.getOrCreateMediaDir(Config.DL_ROOT_PATH);
            if (opt.isEmpty()) {
                this.channel.createMessage(EmbedCreateSpec.builder().title("ERROR").color(Color.RED).description("There was an issue with the download directory configured in Config.DL_ROOT_PATH. It is either a file or the directory couldnt be created by the bot.").build()).subscribe();
                return;
            }
            File directory = opt.get();
            this.channel.createMessage(EmbedCreateSpec.builder().title("Prepare download media file.").color(Color.GREEN).build()).doOnSuccess(message -> {
                Map.Entry<ProcessBuilder, InfoPacket> entry = Helper.createDownloadBuilder(directory, this.line);
                ProcessBuilder builder = entry.getKey();
                InfoPacket infoPacket = entry.getValue();
                this.status = Status.RUNNING;
                try {
                    EmbedCreateSpec.Builder embedBuilder = EmbedCreateSpec.builder().title(infoPacket.title).url(infoPacket.webpage_url).description(infoPacket.description).image(infoPacket.thumbnail).color(Color.BLUE).footer(infoPacket.format, null);
                    MessageEditSpec.Builder msgBuilder = MessageEditSpec.builder();
                    msgBuilder.addComponent(ActionRow.of(ButtonAction.Builder.cancel(this.uuid))).contentOrNull("```css\n.Starting download...```").addEmbed(embedBuilder.build());
                    message.edit(msgBuilder.build()).doOnCancel(() -> ANSI.printRaw("[BR]CANCELLED[BR]")).doOnError(e -> ANSI.printErr(e.getMessage(), e.getCause())).subscribe();
                    Disposable listener = message.getClient().on(ButtonInteractionEvent.class, event -> {
                        if (event.getCustomId().equals(this.uuid)) {
                            long creatorId = DownloadMedia.this.member.getId().asLong();
                            long clickerId = event.getInteraction().getUser().getId().asLong();
                            if (!Permissions.Users.permitted(clickerId, User.Rank.MOD) || creatorId != clickerId) {
                                return Mono.empty();
                            }
                            this.status = Status.ABORTED;
                            return event.edit(InteractionApplicationCommandCallbackSpec.create().withContent("").withEmbeds(EmbedCreateSpec.create().withTitle("Aborted").withDescription("Media download aborted by user.").withColor(Color.RED)).withComponents(new ArrayList()));
                        }
                        return Mono.empty();
                    }).subscribe();
                    Process process = builder.start();
                    long time = System.currentTimeMillis();
                    StringBuilder errorBuilder = new StringBuilder();
                    try (InputStream input = process.getInputStream();
                         BufferedReader error = process.errorReader();){
                        while (this.status == Status.RUNNING) {
                            if (!process.isAlive()) {
                                this.status = Status.FINISHED;
                                break;
                            }
                            int avail = input.available();
                            if (avail > 0) {
                                String[] temp;
                                time = System.currentTimeMillis();
                                String line2 = new String(input.readNBytes(avail));
                                if (line2.contains("[Metadata]") && (temp = line2.split("\"")).length > 0) {
                                    infoPacket.local_filename = temp[1];
                                }
                                message.edit(MessageEditSpec.create().withContentOrNull("```css\n." + line2 + "```")).subscribe();
                                continue;
                            }
                            if (System.currentTimeMillis() - time <= Config.DL_TIMEOUT_SECONDS * 1000L) continue;
                            this.status = Status.TIMEOUT;
                            break;
                        }
                        error.lines().filter(line -> !line.startsWith("WARNING")).forEach(line -> errorBuilder.append((String)line));
                        if (errorBuilder.length() > 0) {
                            this.status = Status.ERROR;
                        }
                    }
                    MessageEditSpec.Builder edit = MessageEditSpec.builder();
                    edit.componentsOrNull(new ArrayList());
                    switch (this.status) {
                        case TIMEOUT: {
                            edit.contentOrNull("").addEmbed(EmbedCreateSpec.builder().title("TIMOUT").description("Download will be terminated, because it appears, that the process is stalled since " + Config.DL_TIMEOUT_SECONDS / 60L + " minutes.").color(Color.RED).build());
                            break;
                        }
                        case FINISHED: {
                            File file;
                            edit.contentOrNull("```diff\n+FINISHED```");
                            EmbedCreateSpec.Builder embed = EmbedCreateSpec.builder().title("Download finished....").url(infoPacket.webpage_url).description(infoPacket.title).image(infoPacket.thumbnail).color(Color.GREEN).footer(infoPacket.format, null);
                            if (infoPacket.downloadable.booleanValue() && (file = new File(builder.directory().getAbsolutePath() + "/" + infoPacket.local_filename)).exists() && file.isFile() && file.canRead()) {
                                MakeDownloadable downloadable = new MakeDownloadable(file, infoPacket.temp);
                                Optional<Object> optLink = Optional.ofNullable(null);
                                try {
                                    optLink = downloadable.future.get(2L, TimeUnit.MINUTES);
                                }
                                catch (InterruptedException | ExecutionException | TimeoutException e2) {
                                    ANSI.printErr(e2.getMessage(), e2);
                                }
                                optLink.ifPresentOrElse(link -> embed.addField(EmbedCreateFields.Field.of("Downloadlink", link, false)), () -> embed.addField(EmbedCreateFields.Field.of("Downloadlink", "Failed to create download link.", false)));
                            }
                            edit.addEmbed(embed.build());
                            break;
                        }
                        case ERROR: {
                            edit.contentOrNull("");
                            edit.addEmbed(EmbedCreateSpec.builder().title("ERROR").color(Color.RED).description("Something went wront.\n\n".concat(errorBuilder.toString())).build());
                            break;
                        }
                        case ABORTED: {
                            edit.contentOrNull("");
                            edit.addEmbed(EmbedCreateSpec.builder().title("ABORTED").color(Color.MOON_YELLOW).description("Download aborted by cancelling the download.").build());
                            break;
                        }
                        default: {
                            edit.contentOrNull("");
                            edit.addEmbed(EmbedCreateSpec.builder().title("WARNING").description("Mediafile already downloaded and exists.").color(Color.ORANGE).build());
                        }
                    }
                    message.edit(edit.build()).subscribe();
                    if (listener != null && !listener.isDisposed()) {
                        listener.dispose();
                    }
                    if (process.isAlive()) {
                        process.destroyForcibly();
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }).doOnError(error -> ANSI.printErr("Error while downloading media in discord command.", error)).subscribe();
        }

        private static enum Status {
            NONE,
            RUNNING,
            ABORTED,
            TIMEOUT,
            EXISTS,
            ERROR,
            WARNING,
            FINISHED;

        }
    }
}

