/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.reaction.DefaultReaction;
import discord4j.core.spec.AuditSpec;
import discord4j.core.spec.ForumTagCreateSpec;
import discord4j.core.spec.ForumTagCreateSpecGenerator;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface ForumChannelCreateSpecGenerator
extends AuditSpec<ChannelCreateRequest> {
    public String name();

    public Possible<String> topic();

    public Possible<Integer> rateLimitPerUser();

    public Possible<Integer> position();

    public Possible<List<PermissionOverwrite>> permissionOverwrites();

    public Possible<Snowflake> parentId();

    public Possible<Boolean> nsfw();

    public Possible<Optional<Integer>> defaultAutoArchiveDuration();

    public Possible<EnumSet<Channel.Flag>> flags();

    public Possible<Optional<DefaultReaction>> defaultReactionEmoji();

    public List<ForumTagCreateSpec> availableTags();

    public Possible<Optional<Integer>> defaultSortOrder();

    public Possible<Optional<Integer>> defaultForumLayout();

    @Override
    default public ChannelCreateRequest asRequest() {
        return ChannelCreateRequest.builder().type(Channel.Type.GUILD_FORUM.getValue()).name(this.name()).topic(this.topic()).rateLimitPerUser(this.rateLimitPerUser()).permissionOverwrites(InternalSpecUtils.mapPossible(this.permissionOverwrites(), po -> po.stream().map(PermissionOverwrite::getData).collect(Collectors.toList()))).parentId(InternalSpecUtils.mapPossible(this.parentId(), Snowflake::asString)).nsfw(this.nsfw()).defaultAutoArchiveDuration(this.defaultAutoArchiveDuration()).flags(InternalSpecUtils.mapPossible(this.flags(), Channel.Flag::toBitfield)).defaultReactionEmoji(InternalSpecUtils.mapPossible(this.defaultReactionEmoji(), opt -> opt.map(DefaultReaction::getData))).defaultForumLayout(this.defaultForumLayout()).availableTags(this.availableTags().stream().map(ForumTagCreateSpecGenerator::asRequest).collect(Collectors.toList())).defaultSortOrder(this.defaultSortOrder()).build();
    }
}

