/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.legacy.LegacyAuditSpec;
import discord4j.discordjson.json.ChannelModifyRequest;
import discord4j.discordjson.json.ImmutableChannelModifyRequest;
import discord4j.discordjson.possible.Possible;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class LegacyTextChannelEditSpec
implements LegacyAuditSpec<ChannelModifyRequest> {
    private final ImmutableChannelModifyRequest.Builder requestBuilder = ChannelModifyRequest.builder();
    @Nullable
    private String reason;

    public LegacyTextChannelEditSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public LegacyTextChannelEditSpec setPosition(int position) {
        this.requestBuilder.position(position);
        return this;
    }

    public LegacyTextChannelEditSpec setTopic(String topic) {
        this.requestBuilder.topic(topic);
        return this;
    }

    public LegacyTextChannelEditSpec setNsfw(boolean nsfw) {
        this.requestBuilder.nsfw(nsfw);
        return this;
    }

    public LegacyTextChannelEditSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List raw = permissionOverwrites.stream().map(PermissionOverwrite::getData).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public LegacyTextChannelEditSpec setParentId(@Nullable Snowflake parentId) {
        this.requestBuilder.parentId(parentId == null ? Possible.of(Optional.empty()) : Possible.of(Optional.of(parentId.asString())));
        return this;
    }

    public LegacyTextChannelEditSpec setRateLimitPerUser(int rateLimitPerUser) {
        this.requestBuilder.rateLimitPerUser(rateLimitPerUser);
        return this;
    }

    public LegacyTextChannelEditSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelModifyRequest asRequest() {
        return this.requestBuilder.build();
    }
}

