/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.StageInstanceCreateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="StageInstanceCreateRequest", generator="Immutables")
public final class ImmutableStageInstanceCreateRequest
implements StageInstanceCreateRequest {
    private final long channelId_value;
    private final String topic;
    private final Integer privacyLevel_value;
    private final boolean privacyLevel_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStageInstanceCreateRequest(Id channelId, String topic, Possible<Integer> privacyLevel) {
        Id channelId$impl = channelId;
        this.topic = Objects.requireNonNull(topic, "topic");
        Possible<Integer> privacyLevel$impl = privacyLevel;
        this.channelId_value = channelId$impl.asLong();
        this.privacyLevel_value = privacyLevel$impl.toOptional().orElse(null);
        this.privacyLevel_absent = privacyLevel$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableStageInstanceCreateRequest(ImmutableStageInstanceCreateRequest original, Id channelId, String topic, Possible<Integer> privacyLevel) {
        Id channelId$impl = channelId;
        this.topic = topic;
        Possible<Integer> privacyLevel$impl = privacyLevel;
        this.channelId_value = channelId$impl.asLong();
        this.privacyLevel_value = privacyLevel$impl.toOptional().orElse(null);
        this.privacyLevel_absent = privacyLevel$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of(this.channelId_value);
    }

    @Override
    @JsonProperty(value="topic")
    public String topic() {
        return this.topic;
    }

    @Override
    @JsonProperty(value="privacy_level")
    public Possible<Integer> privacyLevel() {
        return this.privacyLevel_absent ? Possible.absent() : Possible.of(this.privacyLevel_value);
    }

    public ImmutableStageInstanceCreateRequest withChannelId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableStageInstanceCreateRequest(this, newValue, this.topic, this.privacyLevel());
    }

    public ImmutableStageInstanceCreateRequest withChannelId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableStageInstanceCreateRequest(this, newValue, this.topic, this.privacyLevel());
    }

    public final ImmutableStageInstanceCreateRequest withTopic(String value) {
        String newValue = Objects.requireNonNull(value, "topic");
        if (this.topic.equals(newValue)) {
            return this;
        }
        return new ImmutableStageInstanceCreateRequest(this, this.channelId(), newValue, this.privacyLevel());
    }

    public ImmutableStageInstanceCreateRequest withPrivacyLevel(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableStageInstanceCreateRequest(this, this.channelId(), this.topic, newValue);
    }

    public ImmutableStageInstanceCreateRequest withPrivacyLevel(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new ImmutableStageInstanceCreateRequest(this, this.channelId(), this.topic, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStageInstanceCreateRequest && this.equalTo(0, (ImmutableStageInstanceCreateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableStageInstanceCreateRequest another) {
        return Objects.equals(this.channelId_value, another.channelId_value) && this.topic.equals(another.topic) && this.privacyLevel().equals(another.privacyLevel());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.channelId_value);
        h2 += (h2 << 5) + this.topic.hashCode();
        h2 += (h2 << 5) + this.privacyLevel().hashCode();
        return h2;
    }

    public String toString() {
        return "StageInstanceCreateRequest{channelId=" + Objects.toString(this.channelId_value) + ", topic=" + this.topic + ", privacyLevel=" + this.privacyLevel().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStageInstanceCreateRequest fromJson(Json json) {
        Builder builder = ImmutableStageInstanceCreateRequest.builder();
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.topic != null) {
            builder.topic(json.topic);
        }
        if (json.privacyLevel != null) {
            builder.privacyLevel(json.privacyLevel);
        }
        return builder.build();
    }

    public static ImmutableStageInstanceCreateRequest of(Id channelId, String topic, Possible<Integer> privacyLevel) {
        return new ImmutableStageInstanceCreateRequest(channelId, topic, privacyLevel);
    }

    public static ImmutableStageInstanceCreateRequest copyOf(StageInstanceCreateRequest instance) {
        if (instance instanceof ImmutableStageInstanceCreateRequest) {
            return (ImmutableStageInstanceCreateRequest)instance;
        }
        return ImmutableStageInstanceCreateRequest.builder().from(instance).build();
    }

    public boolean isPrivacyLevelPresent() {
        return !this.privacyLevel_absent;
    }

    public Integer privacyLevelOrElse(Integer defaultValue) {
        return !this.privacyLevel_absent ? this.privacyLevel_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StageInstanceCreateRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TOPIC = 1L;
        private long initBits = 1L;
        private Id channelId_id = null;
        private Possible<Integer> privacyLevel_possible = Possible.absent();
        private String topic;

        private Builder() {
        }

        public final Builder from(StageInstanceCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.channelId(instance.channelId());
            this.topic(instance.topic());
            this.privacyLevel(instance.privacyLevel());
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_id = Id.of(value);
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Id value) {
            this.channelId_id = value;
            return this;
        }

        @JsonProperty(value="topic")
        public final Builder topic(String topic) {
            this.topic = Objects.requireNonNull(topic, "topic");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="privacy_level")
        public Builder privacyLevel(Possible<Integer> value) {
            this.privacyLevel_possible = value;
            return this;
        }

        public Builder privacyLevel(Integer value) {
            this.privacyLevel_possible = Possible.of(value);
            return this;
        }

        public ImmutableStageInstanceCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStageInstanceCreateRequest(null, this.channelId_build(), this.topic, this.privacyLevel_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("topic");
            }
            return "Cannot build StageInstanceCreateRequest, some of required attributes are not set " + attributes;
        }

        private Id channelId_build() {
            return this.channelId_id;
        }

        private Possible<Integer> privacyLevel_build() {
            return this.privacyLevel_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StageInstanceCreateRequest", generator="Immutables")
    static final class Json
    implements StageInstanceCreateRequest {
        Id channelId;
        String topic;
        Possible<Integer> privacyLevel = Possible.absent();

        Json() {
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="topic")
        public void setTopic(String topic) {
            this.topic = topic;
        }

        @JsonProperty(value="privacy_level")
        public void setPrivacyLevel(Possible<Integer> privacyLevel) {
            this.privacyLevel = privacyLevel;
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String topic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> privacyLevel() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="StageInstanceCreateRequest", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StageInstanceCreateRequest, attribute initializers form cycle " + attributes;
        }
    }
}

