/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.thread;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.thread.ThreadEvent;
import discord4j.core.object.entity.ThreadMember;
import discord4j.discordjson.json.gateway.ThreadMembersUpdate;
import discord4j.gateway.ShardInfo;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class ThreadMembersUpdateEvent
extends ThreadEvent {
    private final ThreadMembersUpdate dispatch;
    private final List<ThreadMember> members;
    private final List<ThreadMember> old;

    public ThreadMembersUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, ThreadMembersUpdate dispatch, List<ThreadMember> members, @Nullable List<ThreadMember> old) {
        super(gateway, shardInfo);
        this.dispatch = dispatch;
        this.members = members;
        this.old = old;
    }

    public Snowflake getThreadId() {
        return Snowflake.of(this.dispatch.id());
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.dispatch.guildId());
    }

    public int getMemberCount() {
        return this.dispatch.memberCount();
    }

    public List<ThreadMember> getMembers() {
        return this.members;
    }

    public Optional<List<ThreadMember>> getOld() {
        return Optional.ofNullable(this.old);
    }

    public List<Snowflake> getRemovedMemberIds() {
        return this.dispatch.removedMemberIds().toOptional().orElse(Collections.emptyList()).stream().map(Snowflake::of).collect(Collectors.toList());
    }

    public String toString() {
        return "ThreadMembersUpdateEvent{dispatch=" + this.dispatch + ", members=" + this.members + ", old=" + this.old + '}';
    }
}

