/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.TextChannelCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="TextChannelCreateMonoGenerator", generator="Immutables")
public final class TextChannelCreateMono
extends TextChannelCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final String topic_value;
    private final boolean topic_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private final Boolean nsfw_value;
    private final boolean nsfw_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private TextChannelCreateMono(String name, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible topic$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        Possible nsfw$impl = Possible.absent();
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.initShim = null;
    }

    private TextChannelCreateMono(@Nullable String reason, String name, Possible<String> topic, Possible<Integer> rateLimitPerUser, Possible<Integer> position, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Snowflake> parentId, Possible<Boolean> nsfw, Guild guild) {
        this.reason = reason;
        this.name = name;
        Possible<String> topic$impl = topic;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<Integer> position$impl = position;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible<Snowflake> parentId$impl = parentId;
        Possible<Boolean> nsfw$impl = nsfw;
        this.guild = guild;
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<String> topic() {
        return this.topic_absent ? Possible.absent() : Possible.of(this.topic_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Snowflake> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(this.parentId_value);
    }

    @Override
    public Possible<Boolean> nsfw() {
        return this.nsfw_absent ? Possible.absent() : Possible.of(this.nsfw_value);
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final TextChannelCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new TextChannelCreateMono(value, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.guild);
    }

    public final TextChannelCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new TextChannelCreateMono(this.reason, newValue, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withTopic(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateMono(this.reason, this.name, newValue, this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withTopic(String value) {
        Possible<String> newValue = Possible.of(value);
        return new TextChannelCreateMono(this.reason, this.name, newValue, this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), newValue, this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), newValue, this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), newValue, this.permissionOverwrites(), this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), newValue, this.permissionOverwrites(), this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw(), this.guild);
    }

    @SafeVarargs
    public final TextChannelCreateMono withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withParentId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), newValue, this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withParentId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), newValue, this.nsfw(), this.guild);
    }

    public TextChannelCreateMono withNsfw(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), newValue, this.guild);
    }

    public TextChannelCreateMono withNsfw(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), newValue, this.guild);
    }

    public final TextChannelCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new TextChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TextChannelCreateMono && this.equalTo(0, (TextChannelCreateMono)another);
    }

    private boolean equalTo(int synthetic, TextChannelCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.topic().equals(another.topic()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && this.position().equals(another.position()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId()) && this.nsfw().equals(another.nsfw()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.topic().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.parentId().hashCode();
        h2 += (h2 << 5) + this.nsfw().hashCode();
        h2 += (h2 << 5) + this.guild.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "TextChannelCreateMono{reason=" + this.reason + ", name=" + this.name + ", topic=" + this.topic().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", position=" + this.position().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + ", nsfw=" + this.nsfw().toString() + ", guild=" + this.guild + "}";
    }

    public static TextChannelCreateMono of(String name, Guild guild) {
        return new TextChannelCreateMono(name, guild);
    }

    static TextChannelCreateMono copyOf(TextChannelCreateMonoGenerator instance) {
        if (instance instanceof TextChannelCreateMono) {
            return (TextChannelCreateMono)instance;
        }
        return TextChannelCreateMono.of(instance.name(), instance.guild()).withReason(instance.reason()).withTopic(instance.topic()).withRateLimitPerUser(instance.rateLimitPerUser()).withPosition(instance.position()).withPermissionOverwrites(instance.permissionOverwrites()).withParentId(instance.parentId()).withNsfw(instance.nsfw());
    }

    public boolean isTopicPresent() {
        return !this.topic_absent;
    }

    public String topicOrElse(String defaultValue) {
        return !this.topic_absent ? this.topic_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public boolean isNsfwPresent() {
        return !this.nsfw_absent;
    }

    public Boolean nsfwOrElse(Boolean defaultValue) {
        return !this.nsfw_absent ? this.nsfw_value : defaultValue;
    }

    @Generated(from="TextChannelCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build TextChannelCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

