/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class ContextAwareChannelMetricsRecorder
implements ChannelMetricsRecorder {
    public abstract void incrementErrorsCount(ContextView var1, SocketAddress var2);

    public abstract void recordConnectTime(ContextView var1, SocketAddress var2, Duration var3, String var4);

    public abstract void recordDataReceived(ContextView var1, SocketAddress var2, long var3);

    public abstract void recordDataSent(ContextView var1, SocketAddress var2, long var3);

    public abstract void recordTlsHandshakeTime(ContextView var1, SocketAddress var2, Duration var3, String var4);

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
        this.incrementErrorsCount(Context.empty(), remoteAddress);
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        this.recordConnectTime(Context.empty(), remoteAddress, time, status);
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
        this.recordDataReceived(Context.empty(), remoteAddress, bytes);
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
        this.recordDataSent(Context.empty(), remoteAddress, bytes);
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
        this.recordTlsHandshakeTime(Context.empty(), remoteAddress, time, status);
    }
}

