/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.common;

import com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import com.sedmelluq.discord.lavaplayer.filter.volume.AudioFrameVolumeChanger;
import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.OpusAudioDataFormat;
import com.sedmelluq.discord.lavaplayer.natives.opus.OpusDecoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameFlags;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpusPacketRouter {
    private static final Logger log = LoggerFactory.getLogger(OpusPacketRouter.class);
    private final AudioProcessingContext context;
    private final int inputFrequency;
    private final int inputChannels;
    private final byte[] headerBytes;
    private final MutableAudioFrame offeredFrame;
    private long currentTimecode;
    private long requestedTimecode;
    private OpusDecoder opusDecoder;
    private AudioPipeline downstream;
    private ByteBuffer directInput;
    private ShortBuffer frameBuffer;
    private AudioDataFormat inputFormat;
    private int lastFrameSize;

    public OpusPacketRouter(AudioProcessingContext context, int inputFrequency, int inputChannels) {
        this.context = context;
        this.inputFrequency = inputFrequency;
        this.inputChannels = inputChannels;
        this.headerBytes = new byte[2];
        this.offeredFrame = new MutableAudioFrame();
        this.lastFrameSize = 0;
        this.offeredFrame.setVolume(100);
        this.offeredFrame.setFormat(context.outputFormat);
    }

    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.requestedTimecode = requestedTimecode;
        this.currentTimecode = providedTimecode;
        if (this.downstream != null) {
            this.downstream.seekPerformed(requestedTimecode, providedTimecode);
        }
    }

    public void flush() throws InterruptedException {
        if (this.downstream != null) {
            this.downstream.flush();
        }
    }

    public void process(ByteBuffer buffer) throws InterruptedException {
        int frameSize = this.processFrameSize(buffer);
        if (frameSize != 0) {
            this.checkDecoderNecessity();
            if (this.opusDecoder != null) {
                this.passDownstream(buffer, frameSize);
            } else {
                this.passThrough(buffer);
            }
        }
    }

    public void close() {
        this.destroyDecoder();
    }

    private int processFrameSize(ByteBuffer buffer) {
        int frameSize;
        if (buffer.isDirect()) {
            buffer.mark();
            buffer.get(this.headerBytes);
            buffer.reset();
            frameSize = OpusDecoder.getPacketFrameSize(this.inputFrequency, this.headerBytes, 0, this.headerBytes.length);
        } else {
            frameSize = OpusDecoder.getPacketFrameSize(this.inputFrequency, buffer.array(), buffer.position(), buffer.remaining());
        }
        if (frameSize == 0) {
            return 0;
        }
        if (frameSize != this.lastFrameSize) {
            this.lastFrameSize = frameSize;
            this.inputFormat = new OpusAudioDataFormat(this.inputChannels, this.inputFrequency, frameSize);
        }
        this.currentTimecode += (long)frameSize * 1000L / (long)this.inputFrequency;
        return frameSize;
    }

    private void passDownstream(ByteBuffer buffer, int frameSize) throws InterruptedException {
        ByteBuffer nativeBuffer;
        if (!buffer.isDirect()) {
            if (this.directInput == null || this.directInput.capacity() < buffer.remaining()) {
                this.directInput = ByteBuffer.allocateDirect(buffer.remaining() + 200);
            }
            this.directInput.clear();
            this.directInput.put(buffer);
            this.directInput.flip();
            nativeBuffer = this.directInput;
        } else {
            nativeBuffer = buffer;
        }
        if (this.frameBuffer == null || this.frameBuffer.capacity() < frameSize * this.inputChannels) {
            this.frameBuffer = ByteBuffer.allocateDirect(frameSize * this.inputChannels * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        }
        this.frameBuffer.clear();
        this.frameBuffer.limit(frameSize);
        this.opusDecoder.decode(nativeBuffer, this.frameBuffer);
        this.downstream.process(this.frameBuffer);
    }

    private void passThrough(ByteBuffer buffer) throws InterruptedException {
        if (this.requestedTimecode < this.currentTimecode) {
            this.offeredFrame.setTimecode(this.currentTimecode);
            this.offeredFrame.setBuffer(buffer);
            this.context.frameBuffer.consume(this.offeredFrame);
        }
    }

    private void checkDecoderNecessity() {
        if (AudioPipelineFactory.isProcessingRequired(this.context, this.inputFormat)) {
            if (this.opusDecoder == null) {
                log.debug("Enabling reencode mode on opus track.");
                this.initialiseDecoder();
                AudioFrameVolumeChanger.apply(this.context);
            }
        } else {
            this.offeredFrame.setFlags(AudioFrameFlags.OPUS_PASSTHROUGH);
            if (this.opusDecoder != null) {
                log.debug("Enabling passthrough mode on opus track.");
                this.destroyDecoder();
                AudioFrameVolumeChanger.apply(this.context);
            }
        }
    }

    private void initialiseDecoder() {
        this.offeredFrame.setFlags(new String[0]);
        this.opusDecoder = new OpusDecoder(this.inputFrequency, this.inputChannels);
        try {
            this.downstream = AudioPipelineFactory.create(this.context, new PcmFormat(this.inputChannels, this.inputFrequency));
            this.downstream.seekPerformed(Math.max(this.currentTimecode, this.requestedTimecode), this.currentTimecode);
        }
        finally {
            if (this.downstream == null) {
                this.destroyDecoder();
            }
        }
    }

    private void destroyDecoder() {
        if (this.opusDecoder != null) {
            this.opusDecoder.close();
            this.opusDecoder = null;
        }
        if (this.downstream != null) {
            this.downstream.close();
            this.downstream = null;
        }
        this.directInput = null;
        this.frameBuffer = null;
    }
}

