/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska.format;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MatroskaEbmlReader {
    public static long readFixedSizeEbmlInteger(DataInput input, int codeLength, Type type) throws IOException {
        long code = 0L;
        for (int i = 1; i <= codeLength; ++i) {
            code |= MatroskaEbmlReader.applyNextByte(codeLength, input.readByte() & 0xFF, i);
        }
        return MatroskaEbmlReader.applyType(code, codeLength, type);
    }

    public static long readEbmlInteger(DataInput input, Type type) throws IOException {
        int firstByte = input.readByte() & 0xFF;
        int codeLength = MatroskaEbmlReader.getCodeLength(firstByte);
        long code = MatroskaEbmlReader.applyFirstByte(firstByte, codeLength);
        for (int i = 2; i <= codeLength; ++i) {
            code |= MatroskaEbmlReader.applyNextByte(codeLength, input.readByte() & 0xFF, i);
        }
        return MatroskaEbmlReader.applyType(code, codeLength, type);
    }

    public static long readEbmlInteger(ByteBuffer buffer, Type type) {
        int firstByte = buffer.get() & 0xFF;
        int codeLength = MatroskaEbmlReader.getCodeLength(firstByte);
        long code = MatroskaEbmlReader.applyFirstByte(firstByte, codeLength);
        for (int i = 2; i <= codeLength; ++i) {
            code |= MatroskaEbmlReader.applyNextByte(codeLength, buffer.get() & 0xFF, i);
        }
        return MatroskaEbmlReader.applyType(code, codeLength, type);
    }

    private static int getCodeLength(int firstByte) {
        int codeLength = Integer.numberOfLeadingZeros(firstByte) - 23;
        if (codeLength > 8) {
            throw new IllegalStateException("More than 4 bytes for length, probably invalid data");
        }
        return codeLength;
    }

    private static long applyFirstByte(long firstByte, int codeLength) {
        return (firstByte & 255L >> codeLength) << (codeLength - 1 << 3);
    }

    private static long applyNextByte(int codeLength, int value, int index) {
        return (long)value << (codeLength - index << 3);
    }

    private static long applyType(long code, int codeLength, Type type) {
        if (type != null) {
            switch (type) {
                case SIGNED: {
                    return MatroskaEbmlReader.signEbmlInteger(code, codeLength);
                }
                case LACE_SIGNED: {
                    return MatroskaEbmlReader.laceSignEbmlInteger(code, codeLength);
                }
            }
            return code;
        }
        return code;
    }

    private static long laceSignEbmlInteger(long code, int codeLength) {
        switch (codeLength) {
            case 1: {
                return code - 63L;
            }
            case 2: {
                return code - 8191L;
            }
            case 3: {
                return code - 1048575L;
            }
            case 4: {
                return code - 0x7FFFFFFL;
            }
        }
        throw new IllegalStateException("Code length out of bounds.");
    }

    private static long signEbmlInteger(long code, int codeLength) {
        long mask = MatroskaEbmlReader.getSignMask(codeLength);
        if ((code & mask) != 0L) {
            return code | mask;
        }
        return code;
    }

    private static long getSignMask(int codeLength) {
        switch (codeLength) {
            case 1: {
                return -64L;
            }
            case 2: {
                return -8192L;
            }
            case 3: {
                return -1048576L;
            }
            case 4: {
                return -134217728L;
            }
            case 5: {
                return -17179869184L;
            }
            case 6: {
                return -2199023255552L;
            }
            case 7: {
                return -281474976710656L;
            }
            case 8: {
                return -36028797018963968L;
            }
        }
        throw new IllegalStateException("Code length out of bounds.");
    }

    public static enum Type {
        SIGNED,
        LACE_SIGNED,
        UNSIGNED;

    }
}

