/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.twitch;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchStreamAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final Logger log = LoggerFactory.getLogger(TwitchStreamAudioSourceManager.class);
    private static final String STREAM_NAME_REGEX = "^https://(?:www\\.|go\\.|m\\.)?twitch.tv/([^/]+)$";
    private static final Pattern streamNameRegex = Pattern.compile("^https://(?:www\\.|go\\.|m\\.)?twitch.tv/([^/]+)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private String twitchClientId;
    private String twitchDeviceId;

    public TwitchStreamAudioSourceManager() {
        try {
            this.initRequestHeaders();
        }
        catch (FriendlyException e) {
            log.warn("Failed to fetch Twitch source keys. Key fetching will be retried upon loading a Twitch track. This warning can be ignored unless the issue persists.", e);
        }
    }

    public String getClientId() {
        return this.twitchClientId;
    }

    public String getDeviceId() {
        return this.twitchDeviceId;
    }

    @Override
    public String getSourceName() {
        return "twitch";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String streamName = TwitchStreamAudioSourceManager.getChannelIdentifierFromUrl(reference.identifier);
        if (streamName == null) {
            return null;
        }
        this.initRequestHeaders();
        JsonBrowser channelInfo = this.fetchStreamChannelInfo(streamName).get("data").get("user");
        if (channelInfo == null || channelInfo.get("stream").get("type").isNull()) {
            return AudioReference.NO_TRACK;
        }
        String title = channelInfo.get("lastBroadcast").get("title").text();
        return new TwitchStreamAudioTrack(new AudioTrackInfo(title, streamName, Long.MAX_VALUE, reference.identifier, true, reference.identifier), this);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new TwitchStreamAudioTrack(trackInfo, this);
    }

    public static String getChannelIdentifierFromUrl(String url) {
        Matcher matcher = streamNameRegex.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1).toLowerCase(Locale.ROOT);
    }

    public HttpUriRequest createGetRequest(String url) {
        return TwitchStreamAudioSourceManager.addClientHeaders(new HttpGet(url), this.twitchClientId, this.twitchDeviceId);
    }

    public HttpUriRequest createGetRequest(URI url) {
        return TwitchStreamAudioSourceManager.addClientHeaders(new HttpGet(url), this.twitchClientId, this.twitchDeviceId);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    private static HttpUriRequest addClientHeaders(HttpUriRequest request, String clientId, String deviceId) {
        request.setHeader("Client-ID", clientId);
        request.setHeader("X-Device-ID", deviceId);
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonBrowser fetchAccessToken(String name) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            HttpPost post = new HttpPost("https://gql.twitch.tv/gql");
            TwitchStreamAudioSourceManager.addClientHeaders(post, this.twitchClientId, this.twitchDeviceId);
            post.setEntity(new StringEntity(String.format("{\"operationName\":\"PlaybackAccessToken_Template\",\"query\":\"query PlaybackAccessToken_Template($login: String!,$isLive:Boolean!,$vodID:ID!,$isVod:Boolean!,$playerType:String!){streamPlaybackAccessToken(channelName:$login,params:{platform:\\\"web\\\",playerBackend:\\\"mediaplayer\\\",playerType:$playerType})@include(if:$isLive){value signature __typename}videoPlaybackAccessToken(id:$vodID,params:{platform:\\\"web\\\",playerBackend:\\\"mediaplayer\\\",playerType:$playerType})@include(if:$isVod){value signature __typename}}\",\"variables\":{\"isLive\":true,\"login\":\"%s\",\"isVod\":false,\"vodID\":\"\",\"playerType\":\"site\"}}", name)));
            JsonBrowser jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, post);
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Twitch channel access token failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonBrowser fetchStreamChannelInfo(String channelId) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            HttpPost post = new HttpPost("https://gql.twitch.tv/gql");
            TwitchStreamAudioSourceManager.addClientHeaders(post, this.twitchClientId, this.twitchDeviceId);
            post.setEntity(new StringEntity(String.format("{\"operationName\":\"StreamMetadata\",\"variables\":{\"channelLogin\":\"%s\"},\"extensions\":{\"persistedQuery\":{\"version\":1,\"sha256Hash\":\"1c719a40e481453e5c48d9bb585d971b8b372f8ebb105b17076722264dfa5b3e\"}}}", channelId)));
            JsonBrowser jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, post);
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Twitch channel information failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRequestHeaders() {
        if (this.twitchClientId != null) {
            return;
        }
        TwitchStreamAudioSourceManager twitchStreamAudioSourceManager = this;
        synchronized (twitchStreamAudioSourceManager) {
            if (this.twitchClientId != null) {
                return;
            }
            try (HttpInterface httpInterface = this.getHttpInterface();){
                HttpGet get = new HttpGet("https://www.twitch.tv");
                get.setHeader("Accept", "text/html");
                CloseableHttpResponse response = httpInterface.execute(get);
                HttpClientTools.assertSuccessWithContent(response, "twitch main page");
                String responseText = EntityUtils.toString(response.getEntity());
                this.twitchClientId = DataFormatTools.extractBetween(responseText, "clientId=\"", "\"");
                for (Header header : response.getAllHeaders()) {
                    if (!header.getName().contains("Set-Cookie") || !header.getValue().contains("unique_id=")) continue;
                    this.twitchDeviceId = DataFormatTools.extractBetween(header.toString(), "unique_id=", ";");
                }
            }
            catch (IOException e) {
                throw new FriendlyException("Loading Twitch main page failed.", FriendlyException.Severity.SUSPICIOUS, e);
            }
        }
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }
}

