/*
 * Decompiled with CFR 0.152.
 */
package ibxm;

import ibxm.Data;
import ibxm.IBXM;
import ibxm.Module;
import ibxm.Note;
import ibxm.Sample;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class IBXMPlayer3
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener,
WindowListener {
    private static final String[] KEYS = new String[]{"F1-F4: Keyboard transpose.", "F5: Toggle reverb effect.", "F6: No interpolation filter.", "F7: Linear interpolation filter.", "F8: Sinc interpolation filter.", "Q-P: Keyboard octave 1.", "Z-M: Keyboard octave 2.", "Shift: Sustain notes.", "Space: All notes off."};
    private static final long[] TOPAZ_8 = new long[]{0L, 0x1818181818001800L, 0x6C6C000000000000L, 7812899197659409408L, 1746939516389431296L, 28900492250369024L, 4065739423328664320L, 1736190432909459456L, 871499511419636736L, 3465533159143649280L, 28777514552131584L, 6782329290227712L, 1579056L, 0x7E00000000L, 0x181800L, 217874930004443136L, 4352287579331509248L, 1745276900484847616L, 4352172738915368448L, 4352172807336377344L, 2034620759355952128L, 9106414811862154240L, 2031229519354280960L, 9080952347652790272L, 4352278499502210048L, 4352278506475632640L, 0x18180000181800L, 6781787721701424L, 1715650859237376L, 0x7E007E000000L, 27048012222038016L, 4352172738912196608L, 8991118720533297152L, 4352278782970062336L, 8963964792807521280L, 2175344587066842624L, 8677423172027185152L, 9106384516672421376L, 9106384516672413696L, 4352272117180808704L, 7378697732563035648L, 4330237533479255040L, 434041037034765312L, -4121681030009797120L, 6944656592455368192L, -4112069211331312128L, -4114329772744063488L, 4352278679890836480L, 8963964792706457600L, 8704557359782723072L, 8963964792908178944L, 4352289493142092800L, 9086038739982489600L, 7378697629483809792L, 7378697628776404992L, -4123389782108748288L, -4366736713898867968L, -4366736714508003328L, -140710892294570496L, 0x3C30303030303C00L, -4584611540824096000L, 0x3C0C0C0C0C0C3C00L, 1168803700961968128L, 254L, 1736150850490859520L, 65997514358272L, 6944687404651805696L, 66384631446528L, 434103023613394432L, 66410904566784L, 2031259978352832512L, 68609522927164L, 6944687404651800064L, 1729408748672781312L, 864704374336392312L, 6944663241468175872L, 1736164148113837056L, 260579269199360L, 136779246495232L, 66410502306816L, 136779247935584L, 68609522927110L, 136779145437184L, 66384021584896L, 3472411859111386112L, 112589990673920L, 112589987911680L, 218557312822272L, 218168105420288L, 112589987911728L, 138590410538496L, 1015588585691680256L, 0x1818181818181800L, 8077232380501848064L, 8258475816690647040L};
    private static final Color SHADOW = IBXMPlayer3.toColor(0);
    private static final Color HIGHLIGHT = IBXMPlayer3.toColor(4095);
    private static final Color BACKGROUND = IBXMPlayer3.toColor(2730);
    private static final Color SELECTED = IBXMPlayer3.toColor(1675);
    private static final int TEXT_SHADOW_BACKGROUND = 0;
    private static final int TEXT_HIGHLIGHT_BACKGROUND = 1;
    private static final int TEXT_SHADOW_SELECTED = 2;
    private static final int TEXT_HIGHLIGHT_SELECTED = 3;
    private static final int TEXT_BLUE = 4;
    private static final int TEXT_GREEN = 5;
    private static final int TEXT_CYAN = 6;
    private static final int TEXT_RED = 7;
    private static final int TEXT_MAGENTA = 8;
    private static final int TEXT_YELLOW = 9;
    private static final int TEXT_WHITE = 10;
    private static final int TEXT_LIME = 11;
    private static final int[] FX_COLOURS = new int[]{5, 5, 5, 5, 5, 11, 11, 9, 9, 8, 0, 0, 0, 0, 0, 0, 0, 9, 10, 9, 10, 4, 10, 9, 9, 4, 4, 4, 8, 4, 4, 4, 9, 4, 8, 4, 9, 4, 4, 4, 5, 4, 4, 0, 0, 0, 0, 0, 0, 10, 10, 10, 9, 5, 5, 5, 5, 9, 5, 11, 11, 4, 4, 8, 4, 8, 9, 4, 10, 5, 9, 4, 4, 4, 4, 0, 0, 0, 0};
    private static final int[] EX_COLOURS = new int[]{4, 5, 5, 5, 5, 5, 10, 9, 4, 8, 0, 0, 0, 0, 0, 0, 0, 9, 9, 8, 8, 8, 8};
    private static final int[] SX_COLOURS = new int[]{9, 8, 5, 5, 9, 4, 4, 4, 9, 4, 0, 0, 0, 0, 0, 0, 0, 9, 8, 8, 8, 8, 8};
    private static final int[] VC_COLOURS = new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 5, 5, 9, 9, 9, 5};
    private static final int[] KEY_MAP = new int[]{90, 83, 88, 68, 67, 86, 71, 66, 72, 78, 74, 77, 81, 50, 87, 51, 69, 82, 53, 84, 54, 89, 55, 85, 73, 57, 79, 48, 80};
    private static final int[] HEX_MAP = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final String KEY_TO_STR = "A-A#B-C-C#D-D#E-F-F#G-G#";
    private static final String HEX_TO_STR = "0123456789ABCDEF";
    private static final int GAD_COUNT = 32;
    private static final int GAD_TYPE_LABEL = 1;
    private static final int GAD_TYPE_BUTTON = 2;
    private static final int GAD_TYPE_TEXTBOX = 3;
    private static final int GAD_TYPE_VSLIDER = 4;
    private static final int GAD_TYPE_HSLIDER = 5;
    private static final int GAD_TYPE_LISTBOX = 6;
    private static final int GAD_TYPE_PATTERN = 7;
    private static final int KEY_ESCAPE = 27;
    private static final int KEY_BACKSPACE = 8;
    private static final int KEY_DELETE = 127;
    private static final int KEY_HOME = 36;
    private static final int KEY_END = 35;
    private static final int KEY_PAGE_UP = 33;
    private static final int KEY_PAGE_DOWN = 34;
    private static final int KEY_UP = 38;
    private static final int KEY_DOWN = 40;
    private static final int KEY_LEFT = 37;
    private static final int KEY_RIGHT = 39;
    private static final int GADNUM_PATTERN = 1;
    private static final int GADNUM_PATTERN_VSLIDER = 2;
    private static final int GADNUM_PATTERN_HSLIDER = 3;
    private static final int GADNUM_DIR_TEXTBOX = 4;
    private static final int GADNUM_DIR_BUTTON = 5;
    private static final int GADNUM_DIR_LISTBOX = 6;
    private static final int GADNUM_DIR_SLIDER = 7;
    private static final int GADNUM_TITLE_LABEL = 8;
    private static final int GADNUM_TITLE_TEXTBOX = 9;
    private static final int GADNUM_INST_LABEL = 10;
    private static final int GADNUM_INST_TEXTBOX = 11;
    private static final int GADNUM_INST_DEC_BUTTON = 12;
    private static final int GADNUM_INST_INC_BUTTON = 13;
    private static final int GADNUM_INST_LISTBOX = 14;
    private static final int GADNUM_INST_SLIDER = 15;
    private static final int GADNUM_SEQ_LISTBOX = 16;
    private static final int GADNUM_SEQ_SLIDER = 17;
    private static final int GADNUM_LOAD_BUTTON = 18;
    private static final int GADNUM_VER_LABEL = 19;
    private static final int GADNUM_PLAY_BUTTON = 20;
    private static final int SAMPLING_RATE = 48000;
    private int displayChannels;
    private int width;
    private int height;
    private int clickX;
    private int clickY;
    private int focus;
    private int[] gadType = new int[32];
    private int[] gadX = new int[32];
    private int[] gadY = new int[32];
    private int[] gadWidth = new int[32];
    private int[] gadHeight = new int[32];
    private boolean[] gadRedraw = new boolean[32];
    private String[][] gadText = new String[32][];
    private int[][] gadValues = new int[32][];
    private boolean[] gadSelected = new boolean[32];
    private int[] gadValue = new int[32];
    private int[] gadRange = new int[32];
    private int[] gadMax = new int[32];
    private int[] gadItem = new int[32];
    private int[] gadLink = new int[32];
    private Image charset;
    private Image image;
    private Module module = new Module();
    private IBXM ibxm = new IBXM(this.module, 48000);
    private int instrument;
    private int octave = 4;
    private int selectedFile;
    private int triggerChannel;
    private int[] keyChannel = new int[97];
    private boolean reverb;
    private String error;
    private long mute;

    private static int reverb(int[] buf, int[] reverbBuf, int reverbIdx, int count) {
        for (int idx = 0; idx < count; ++idx) {
            buf[idx * 2] = buf[idx * 2] * 3 + reverbBuf[reverbIdx + 1] >> 2;
            buf[idx * 2 + 1] = buf[idx * 2 + 1] * 3 + reverbBuf[reverbIdx] >> 2;
            reverbBuf[reverbIdx] = buf[idx * 2];
            reverbBuf[reverbIdx + 1] = buf[idx * 2 + 1];
            if ((reverbIdx += 2) < reverbBuf.length) continue;
            reverbIdx = 0;
        }
        return reverbIdx;
    }

    private static void clip(int[] inputBuf, byte[] outputBuf, int count) {
        for (int idx = 0; idx < count; ++idx) {
            int ampl = inputBuf[idx];
            if (ampl > Short.MAX_VALUE) {
                ampl = Short.MAX_VALUE;
            }
            if (ampl < Short.MIN_VALUE) {
                ampl = Short.MIN_VALUE;
            }
            outputBuf[idx * 2] = (byte)ampl;
            outputBuf[idx * 2 + 1] = (byte)(ampl >> 8);
        }
    }

    private static String pad(String string, char chr, int length, boolean left) {
        if (string.length() < length) {
            char[] chars = new char[length];
            for (int idx = 0; idx < chars.length; ++idx) {
                chars[idx] = chr;
            }
            string.getChars(0, string.length(), chars, left ? length - string.length() : 0);
            return new String(chars);
        }
        return string.substring(0, length);
    }

    private static String[] split(String input, char sep) {
        int count = 0;
        int len = input.length();
        for (int idx = 0; idx < len; ++idx) {
            if (input.charAt(idx) != sep) continue;
            ++count;
        }
        String[] output = new String[count + 1];
        int offset = 0;
        count = 0;
        int len2 = input.length();
        for (int idx = 0; idx < len2; ++idx) {
            if (input.charAt(idx) != sep) continue;
            output[count++] = input.substring(offset, idx);
            offset = idx + 1;
        }
        output[count] = input.substring(offset, input.length());
        return output;
    }

    private static Color toColor(int rgb12) {
        return new Color((rgb12 >> 8 & 0xF) * 17, (rgb12 >> 4 & 0xF) * 17, (rgb12 & 0xF) * 17);
    }

    private static int toRgb12(Color clr) {
        return clr.getRed() / 17 << 8 | clr.getGreen() / 17 << 4 | clr.getBlue() / 17;
    }

    private static int toRgb24(int rgb12) {
        int r = ((rgb12 & 0xF00) >> 8) * 17;
        int g2 = ((rgb12 & 0xF0) >> 4) * 17;
        int b = (rgb12 & 0xF) * 17;
        return r << 16 | g2 << 8 | b;
    }

    private void createDiskGadgets(int x, int y, int rows, int cols) {
        this.createTextbox(4, x, y, (cols - 1) * 8, 28, "");
        this.createButton(5, x + (cols - 1) * 8 + 4, y + 2, 44, 24, "Dir");
        this.createListbox(6, x, y + 32, (cols + 2) * 8, rows * 16 + 12, 7);
        this.createVSlider(7, x + (cols + 2) * 8 + 4, y + 32, 20, rows * 16 + 12, 1, 1);
        this.createButton(18, x, y + rows * 16 + 48, 96, 24, "Load");
    }

    private void createInstGadgets(int x, int y, int rows, int cols) {
        this.createLabel(10, x, y + 6, "Instrument", 2);
        this.createTextbox(11, x + 80 + 4, y, 32, 28, "00");
        this.createButton(12, x + 120, y + 2, 24, 24, "<");
        this.createButton(13, x + 120 + 28, y + 2, 24, 24, ">");
        this.createListbox(14, x, y + 32, (cols + 2) * 8, rows * 16 + 12, 15);
        this.createVSlider(15, x + (cols + 2) * 8 + 4, y + 32, 20, rows * 16 + 12, 1, 1);
    }

    private void createSequenceGadgets(int x, int y, int rows) {
        this.createListbox(16, x, y, 72, rows * 16 + 12, 17);
        this.gadText[16] = new String[]{"000   0"};
        this.createVSlider(17, x + 72 + 4, y, 20, rows * 16 + 12, 1, 1);
        this.createButton(20, x, y + rows * 16 + 16, 96, 24, "Play");
    }

    public IBXMPlayer3(int channels) {
        int rows = 9;
        this.displayChannels = channels;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.createPattern(1, 4, 80 + rows * 16, channels, 2);
        this.createVSlider(2, this.gadWidth[1] + 8, 80 + rows * 16, 20, 256, 15, 78);
        this.createHSlider(3, 4, 340 + rows * 16, this.gadWidth[1], 20, channels, channels);
        this.gadLink[3] = 1;
        this.createDiskGadgets(4, 4, rows, (channels - 8) * 11 + 36);
        this.createLabel(8, (channels * 11 - 21) * 8, 10, "Title", 2);
        this.createTextbox(9, (channels * 11 - 16) * 8 + 4, 4, 184, 28, this.module.songName);
        this.createInstGadgets((channels * 11 - 46) * 8, 4, rows, 36);
        this.createSequenceGadgets((channels * 11 - 5) * 8 + 4, 36, rows);
        String version = "IBXM a75 (c)2021 mumart@gmail.com";
        int x = 4 + ((channels * 11 + 4) * 8 - version.length() * 8) / 2;
        this.createLabel(19, x, 6 + rows * 16 + 50, version, 3);
        this.ibxm.setSequencerEnabled(false);
        this.setInstrument(1);
        this.listDir(this.getDir());
        this.gadRedraw[0] = true;
        this.width = this.gadWidth[1] + 32;
        this.height = this.gadY[1] + this.gadHeight[1] + 28;
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        try {
            block1 : switch (e.getKeyCode()) {
                case 112: {
                    this.octave = 3;
                    break;
                }
                case 113: {
                    this.octave = 4;
                    break;
                }
                case 114: {
                    this.octave = 5;
                    break;
                }
                case 115: {
                    this.octave = 6;
                    break;
                }
                case 116: {
                    this.reverb = !this.reverb;
                    break;
                }
                case 117: {
                    this.ibxm.setInterpolation(0);
                    break;
                }
                case 118: {
                    this.ibxm.setInterpolation(1);
                    break;
                }
                case 119: {
                    this.ibxm.setInterpolation(2);
                    break;
                }
                default: {
                    switch (this.gadType[this.focus]) {
                        case 3: {
                            this.keyTextbox(this.focus, e.getKeyChar(), e.getKeyCode(), e.isShiftDown());
                            break block1;
                        }
                        case 6: {
                            this.keyListbox(this.focus, e.getKeyChar(), e.getKeyCode(), e.isShiftDown());
                            this.trigger(-1, this.mapNoteKey(e), e.isShiftDown());
                            break block1;
                        }
                    }
                    this.trigger(-1, this.mapNoteKey(e), e.isShiftDown());
                    break;
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            this.setError(x.getMessage());
        }
        this.repaint();
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
        switch (this.gadType[this.focus]) {
            case 3: {
                break;
            }
            default: {
                this.release(this.mapNoteKey(e));
            }
        }
    }

    @Override
    public synchronized void keyTyped(KeyEvent e) {
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.clickX = e.getX();
        this.clickY = e.getY();
        int clicked = this.findGadget(this.clickX, this.clickY);
        if (this.focus > 0 && this.focus != clicked) {
            this.escape(this.focus);
            this.gadRedraw[this.focus] = true;
        }
        switch (this.gadType[clicked]) {
            case 2: {
                this.gadSelected[clicked] = true;
                this.gadRedraw[clicked] = true;
                break;
            }
            case 3: {
                this.clickTextbox(clicked);
                break;
            }
            case 4: {
                this.clickVSlider(clicked, e.isShiftDown());
                break;
            }
            case 5: {
                this.clickHSlider(clicked, e.isShiftDown());
                break;
            }
            case 6: {
                this.clickListbox(clicked, e.isShiftDown());
                break;
            }
            case 7: {
                this.clickPattern(clicked, e.isShiftDown());
                break;
            }
            default: {
                if (clicked <= 0) break;
                this.action(clicked, e.isShiftDown());
            }
        }
        this.focus = clicked;
        this.repaint();
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
        if (this.focus > 0) {
            switch (this.gadType[this.focus]) {
                case 2: {
                    if (this.findGadget(e.getX(), e.getY()) != this.focus) break;
                    this.gadSelected[this.focus] = false;
                    this.gadRedraw[this.focus] = true;
                    this.action(this.focus, e.isShiftDown());
                    this.focus = 0;
                    this.repaint();
                    break;
                }
                case 4: 
                case 5: {
                    this.action(this.focus, e.isShiftDown());
                    this.focus = 0;
                    this.repaint();
                }
            }
        }
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        if (this.focus > 0) {
            switch (this.gadType[this.focus]) {
                case 2: {
                    boolean selected;
                    boolean bl = selected = this.findGadget(e.getX(), e.getY()) == this.focus;
                    if (this.gadSelected[this.focus] == selected) break;
                    this.gadSelected[this.focus] = selected;
                    this.gadRedraw[this.focus] = true;
                    this.repaint();
                    break;
                }
                case 4: {
                    this.dragVSlider(this.focus, e.getY());
                    break;
                }
                case 5: {
                    this.dragHSlider(this.focus, e.getX());
                }
            }
        }
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
    }

    @Override
    public synchronized void windowActivated(WindowEvent e) {
    }

    @Override
    public synchronized void windowClosed(WindowEvent e) {
    }

    @Override
    public synchronized void windowClosing(WindowEvent e) {
        e.getWindow().dispose();
    }

    @Override
    public synchronized void windowDeactivated(WindowEvent e) {
    }

    @Override
    public synchronized void windowDeiconified(WindowEvent e) {
    }

    @Override
    public synchronized void windowIconified(WindowEvent e) {
    }

    @Override
    public synchronized void windowOpened(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paint(Graphics g2) {
        if (this.charset == null) {
            this.charset = this.createImage(IBXMPlayer3.charsetImage(TOPAZ_8).getSource());
        }
        if (this.image == null) {
            this.image = this.createImage(this.width, this.height);
        }
        boolean redraw = this.gadRedraw[0];
        for (int idx = 1; idx < 32 && !redraw; ++idx) {
            redraw = this.gadRedraw[idx];
        }
        if (redraw) {
            Graphics imageGraphics = this.image.getGraphics();
            try {
                if (this.gadRedraw[0]) {
                    imageGraphics.setColor(SELECTED);
                    imageGraphics.fillRect(0, 0, this.width, this.height);
                }
                for (int idx = 1; idx < 32; ++idx) {
                    if (!this.gadRedraw[idx] && !this.gadRedraw[0]) continue;
                    switch (this.gadType[idx]) {
                        case 1: {
                            this.drawLabel(imageGraphics, idx);
                            break;
                        }
                        case 2: {
                            this.drawButton(imageGraphics, idx);
                            break;
                        }
                        case 3: {
                            this.drawTextbox(imageGraphics, idx);
                            break;
                        }
                        case 4: {
                            if (this.gadLink[this.gadLink[idx]] == idx) break;
                            this.drawVSlider(imageGraphics, idx);
                            break;
                        }
                        case 5: {
                            if (this.gadLink[this.gadLink[idx]] == idx) break;
                            this.drawHSlider(imageGraphics, idx);
                            break;
                        }
                        case 6: {
                            this.drawListbox(imageGraphics, idx);
                            break;
                        }
                        case 7: {
                            this.drawPattern(imageGraphics, idx);
                        }
                    }
                    this.gadRedraw[idx] = false;
                }
                this.gadRedraw[0] = false;
            }
            finally {
                imageGraphics.dispose();
            }
        }
        g2.drawImage(this.image, 0, 0, null);
    }

    @Override
    public synchronized void update(Graphics g2) {
        this.paint(g2);
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    private static int readIntBe(InputStream inputStream, int length) throws IOException {
        int value = 0;
        for (int idx = 0; idx < length; ++idx) {
            value = value << 8 | inputStream.read();
        }
        return value;
    }

    private static int readIntLe(InputStream inputStream, int length) throws IOException {
        int value = 0;
        for (int idx = 0; idx < length; ++idx) {
            value |= inputStream.read() << idx * 8;
        }
        return value;
    }

    private static void drawChar(long[] source, int chr, int x, int y, int bg, int fg, int[] dest, int stride) {
        int destIdx = y * stride + x;
        for (int cy = 0; cy < 8; ++cy) {
            for (int cx = 0; cx < 8; ++cx) {
                int pixel;
                int n = pixel = (source[chr] >> 63 - cy * 8 - cx & 1L) == 0L ? bg : fg;
                dest[destIdx + cx + stride] = n;
                dest[destIdx + cx] = n;
            }
            destIdx += stride * 2;
        }
    }

    private static Image iconImage() {
        BufferedImage image = new BufferedImage(32, 32, 1);
        int[] pixels = new int[1024];
        IBXMPlayer3.drawChar(TOPAZ_8, 41, 0, 9, 0, IBXMPlayer3.toRgb24(127), pixels, 32);
        IBXMPlayer3.drawChar(TOPAZ_8, 34, 8, 9, 0, IBXMPlayer3.toRgb24(127), pixels, 32);
        IBXMPlayer3.drawChar(TOPAZ_8, 56, 16, 9, 0, IBXMPlayer3.toRgb24(3952), pixels, 32);
        IBXMPlayer3.drawChar(TOPAZ_8, 45, 24, 9, 0, IBXMPlayer3.toRgb24(3952), pixels, 32);
        image.setRGB(0, 0, 32, 32, pixels, 0, 32);
        return image;
    }

    private static Image charsetImage(long[] source) {
        int[] pal = new int[]{IBXMPlayer3.toRgb12(BACKGROUND) << 12 | IBXMPlayer3.toRgb12(SHADOW), IBXMPlayer3.toRgb12(BACKGROUND) << 12 | IBXMPlayer3.toRgb12(HIGHLIGHT), IBXMPlayer3.toRgb12(SELECTED) << 12 | IBXMPlayer3.toRgb12(SHADOW), IBXMPlayer3.toRgb12(SELECTED) << 12 | IBXMPlayer3.toRgb12(HIGHLIGHT), 12, 128, 136, 2048, 2056, 2144, 2184, 1664, 111, 240, 255, 3840, 3855, 4032, 4095, 3312};
        int w = 8 * source.length;
        int h2 = 16 * pal.length;
        int[] pixels = new int[w * h2];
        for (int clr = 0; clr < pal.length; ++clr) {
            int bg = IBXMPlayer3.toRgb24(pal[clr] >> 12);
            int fg = IBXMPlayer3.toRgb24(pal[clr] & 0xFFF);
            for (int chr = 0; chr < source.length; ++chr) {
                IBXMPlayer3.drawChar(source, chr, chr * 8, clr * 16, bg, fg, pixels, w);
            }
        }
        BufferedImage image = new BufferedImage(w, h2, 1);
        image.setRGB(0, 0, w, h2, pixels, 0, w);
        return image;
    }

    private void setError(String message) {
        this.error = message;
        this.gadRedraw[1] = true;
    }

    private void drawText(Graphics g2, int x, int y, String text, int colour) {
        int len = text.length();
        for (int idx = 0; idx < len; ++idx) {
            int chr = text.charAt(idx);
            if (chr < 32 || chr > 126 && chr < 192 || chr > 255) {
                chr = 32;
            } else if (chr >= 192) {
                chr = "AAAAAAECEEEEIIIIDNOOOOO*0UUUUYPSaaaaaaeceeeeiiiidnooooo/0uuuuypy".charAt(chr - 192);
            }
            g2.setClip(x, y, 8, 16);
            g2.drawImage(this.charset, x - (chr - 32) * 8, y - colour * 16, null);
            x += 8;
        }
        g2.setClip(null);
    }

    private void drawInt(Graphics g2, int x, int y, int value, int len, int colour) {
        char[] chars = new char[len];
        while (len > 0) {
            chars[--len] = (char)(48 + value % 10);
            value /= 10;
        }
        this.drawText(g2, x, y, new String(chars), colour);
    }

    private void raiseBox(Graphics g2, int x, int y, int w, int h2) {
        g2.setColor(SHADOW);
        g2.fillRect(x + w - 2, y, 2, h2);
        g2.setColor(HIGHLIGHT);
        g2.fillRect(x, y, 2, h2);
        g2.setColor(SHADOW);
        g2.fillRect(x + 1, y + h2 - 2, w - 1, 2);
        g2.setColor(HIGHLIGHT);
        g2.fillRect(x, y, w - 1, 2);
    }

    private void lowerBox(Graphics g2, int x, int y, int w, int h2) {
        g2.setColor(HIGHLIGHT);
        g2.fillRect(x + w - 2, y, 2, h2);
        g2.setColor(SHADOW);
        g2.fillRect(x, y, 2, h2);
        g2.setColor(HIGHLIGHT);
        g2.fillRect(x + 1, y + h2 - 2, w - 1, 2);
        g2.setColor(SHADOW);
        g2.fillRect(x, y, w - 1, 2);
    }

    private void bevelBox(Graphics g2, int x, int y, int w, int h2) {
        this.raiseBox(g2, x, y, w, h2);
        this.lowerBox(g2, x + 2, y + 2, w - 4, h2 - 4);
    }

    private void drawLabel(Graphics g2, int gadnum) {
        this.drawText(g2, this.gadX[gadnum], this.gadY[gadnum], this.gadText[gadnum][0], this.gadValue[gadnum]);
    }

    private void drawButton(Graphics g2, int gadnum) {
        int textColour;
        int x = this.gadX[gadnum];
        int y = this.gadY[gadnum];
        int w = this.gadWidth[gadnum];
        int h2 = this.gadHeight[gadnum];
        if (this.gadSelected[gadnum]) {
            g2.setColor(SELECTED);
            g2.fillRect(x, y, w, h2);
            this.lowerBox(g2, x, y, w, h2);
            textColour = 3;
        } else {
            g2.setColor(BACKGROUND);
            g2.fillRect(x, y, w, h2);
            this.raiseBox(g2, x, y, w, h2);
            textColour = 0;
        }
        String text = this.gadText[gadnum][0];
        this.drawText(g2, x + (w - text.length() * 8) / 2, y + (h2 - 14) / 2, text, textColour);
    }

    private void drawTextbox(Graphics g2, int gadnum) {
        int offset;
        int x = this.gadX[gadnum];
        int y = this.gadY[gadnum];
        int w = this.gadWidth[gadnum];
        int h2 = this.gadHeight[gadnum];
        String text = this.gadText[gadnum][0];
        int cursor = this.gadItem[gadnum];
        int columns = (w - 16) / 8;
        int n = offset = this.focus == gadnum ? this.gadValue[gadnum] : text.length() - columns;
        if (offset < 0 || offset > text.length()) {
            offset = 0;
        }
        if (offset + columns > text.length()) {
            columns = text.length() - offset;
        }
        g2.setColor(BACKGROUND);
        g2.fillRect(x, y, w, h2);
        this.drawText(g2, x + 8, y + 6, text.substring(offset, offset + columns), 0);
        if (this.focus == gadnum && cursor >= offset && cursor <= offset + columns) {
            String chr = cursor < offset + columns ? String.valueOf(text.charAt(cursor)) : " ";
            this.drawText(g2, x + (cursor - offset + 1) * 8, y + 6, chr, 2);
        }
        this.bevelBox(g2, x, y, w, h2);
    }

    private void clickTextbox(int gadnum) {
        int cursor;
        int offset;
        int columns = (this.gadWidth[gadnum] - 16) / 8;
        String text = this.gadText[gadnum][0];
        int n = offset = this.focus == gadnum ? this.gadValue[gadnum] : text.length() - columns;
        if (offset < 0 || offset > text.length()) {
            offset = 0;
        }
        if (offset + columns > text.length()) {
            columns = text.length() - offset;
        }
        if ((cursor = offset + (this.clickX - this.gadX[gadnum]) / 8 - 1) > text.length()) {
            cursor = text.length();
        }
        if (cursor < 0) {
            cursor = 0;
        }
        this.gadValue[gadnum] = offset;
        this.gadItem[gadnum] = cursor;
        this.gadRedraw[gadnum] = true;
    }

    private void keyTextbox(int gadnum, char chr, int key, boolean shift) {
        int cursor;
        int columns = (this.gadWidth[gadnum] - 16) / 8;
        String text = this.gadText[gadnum][0];
        int offset = this.gadValue[gadnum];
        if (offset < 0 || offset > text.length()) {
            offset = 0;
        }
        if ((cursor = this.gadItem[gadnum]) > text.length()) {
            cursor = text.length();
        }
        switch (key) {
            case 8: {
                if (cursor <= 0) break;
                text = text.substring(0, cursor - 1) + text.substring(cursor);
                if (--cursor >= offset) break;
                offset = cursor;
                break;
            }
            case 127: {
                if (cursor >= text.length()) break;
                text = text.substring(0, cursor) + text.substring(cursor + 1);
                break;
            }
            case 35: {
                cursor = text.length();
                if (cursor - offset < columns) break;
                offset = cursor - columns;
                break;
            }
            case 27: {
                this.escape(gadnum);
                text = this.gadText[gadnum][0];
                this.focus = 0;
                break;
            }
            case 36: {
                cursor = 0;
                offset = 0;
                break;
            }
            case 37: {
                if (cursor <= 0 || --cursor >= offset) break;
                offset = cursor;
                break;
            }
            case 39: {
                if (cursor >= text.length() || ++cursor - offset < columns) break;
                offset = cursor - columns + 1;
                break;
            }
            default: {
                if (chr == '\n') {
                    this.action(gadnum, shift);
                    text = this.gadText[gadnum][0];
                    this.focus = 0;
                    break;
                }
                if (chr < ' ' || chr >= '\u007f') break;
                text = text.substring(0, cursor) + String.valueOf(chr) + text.substring(cursor);
                if (++cursor - offset <= columns) break;
                offset = cursor - columns;
            }
        }
        this.gadText[gadnum][0] = text;
        this.gadValue[gadnum] = offset;
        this.gadItem[gadnum] = cursor;
        this.gadRedraw[gadnum] = true;
    }

    private void drawVSlider(Graphics g2, int gadnum) {
        int x = this.gadX[gadnum];
        int y = this.gadY[gadnum];
        int w = this.gadWidth[gadnum];
        int h2 = this.gadHeight[gadnum];
        int s2 = (h2 - 12) * this.gadRange[gadnum] / this.gadMax[gadnum] + 8;
        int d = (h2 - 12) * this.gadValue[gadnum] / this.gadMax[gadnum];
        g2.setColor(SELECTED);
        g2.fillRect(x, y, w, h2);
        this.lowerBox(g2, x, y, w, h2);
        g2.setColor(BACKGROUND);
        g2.fillRect(x + 2, y + d + 2, w - 4, s2);
        this.raiseBox(g2, x + 2, y + d + 2, w - 4, s2);
    }

    private void drawHSlider(Graphics g2, int gadnum) {
        int x = this.gadX[gadnum];
        int y = this.gadY[gadnum];
        int w = this.gadWidth[gadnum];
        int h2 = this.gadHeight[gadnum];
        int s2 = (w - 12) * this.gadRange[gadnum] / this.gadMax[gadnum] + 8;
        int d = (w - 12) * this.gadValue[gadnum] / this.gadMax[gadnum];
        g2.setColor(SELECTED);
        g2.fillRect(x, y, w, h2);
        this.lowerBox(g2, x, y, w, h2);
        g2.setColor(BACKGROUND);
        g2.fillRect(x + d + 2, y + 2, s2, h2 - 4);
        this.raiseBox(g2, x + d + 2, y + 2, s2, h2 - 4);
    }

    private void clickVSlider(int gadnum, boolean shift) {
        int ss = (this.gadHeight[gadnum] - 12) * this.gadRange[gadnum] / this.gadMax[gadnum] + 8;
        int so = (this.gadHeight[gadnum] - 12) * this.gadValue[gadnum] / this.gadMax[gadnum];
        int sy = this.gadY[gadnum] + so + 2;
        if (this.clickY < sy) {
            int sp = this.gadValue[gadnum] - this.gadRange[gadnum];
            if (sp < 0) {
                sp = 0;
            }
            this.gadValue[gadnum] = sp;
            if (this.gadLink[gadnum] > 0) {
                this.gadRedraw[this.gadLink[gadnum]] = true;
            }
            if (this.gadLink[this.gadLink[gadnum]] != gadnum) {
                this.gadRedraw[gadnum] = true;
            }
            this.action(gadnum, shift);
        } else if (this.clickY > sy + ss) {
            int sp = this.gadValue[gadnum] + this.gadRange[gadnum];
            if (sp > this.gadMax[gadnum] - this.gadRange[gadnum]) {
                sp = this.gadMax[gadnum] - this.gadRange[gadnum];
            }
            this.gadValue[gadnum] = sp;
            if (this.gadLink[gadnum] > 0) {
                this.gadRedraw[this.gadLink[gadnum]] = true;
            }
            if (this.gadLink[this.gadLink[gadnum]] != gadnum) {
                this.gadRedraw[gadnum] = true;
            }
            this.action(gadnum, shift);
        }
    }

    private void clickHSlider(int gadnum, boolean shift) {
        int ss = (this.gadWidth[gadnum] - 12) * this.gadRange[gadnum] / this.gadMax[gadnum] + 8;
        int so = (this.gadWidth[gadnum] - 12) * this.gadValue[gadnum] / this.gadMax[gadnum];
        int sx = this.gadX[gadnum] + so + 2;
        if (this.clickX < sx) {
            int sp = this.gadValue[gadnum] - this.gadRange[gadnum];
            if (sp < 0) {
                sp = 0;
            }
            this.gadValue[gadnum] = sp;
            if (this.gadLink[gadnum] > 0) {
                this.gadRedraw[this.gadLink[gadnum]] = true;
            }
            if (this.gadLink[this.gadLink[gadnum]] != gadnum) {
                this.gadRedraw[gadnum] = true;
            }
            this.action(gadnum, shift);
        } else if (this.clickX > sx + ss) {
            int sp = this.gadValue[gadnum] + this.gadRange[gadnum];
            if (sp > this.gadMax[gadnum] - this.gadRange[gadnum]) {
                sp = this.gadMax[gadnum] - this.gadRange[gadnum];
            }
            this.gadValue[gadnum] = sp;
            if (this.gadLink[gadnum] > 0) {
                this.gadRedraw[this.gadLink[gadnum]] = true;
            }
            if (this.gadLink[this.gadLink[gadnum]] != gadnum) {
                this.gadRedraw[gadnum] = true;
            }
            this.action(gadnum, shift);
        }
    }

    private void dragVSlider(int gadnum, int y) {
        int ss = (this.gadHeight[gadnum] - 12) * this.gadRange[gadnum] / this.gadMax[gadnum] + 8;
        int so = (this.gadHeight[gadnum] - 12) * this.gadValue[gadnum] / this.gadMax[gadnum];
        int sg = this.gadHeight[gadnum] - 4 - ss;
        int sy = this.gadY[gadnum] + so + 2;
        if (this.clickY > sy && this.clickY < sy + ss) {
            int sp = so + y - this.clickY;
            if (sp < 0) {
                sp = 0;
            }
            if (sp > sg) {
                sp = sg;
            }
            this.gadValue[gadnum] = sp > 0 ? sp * (this.gadMax[gadnum] - this.gadRange[gadnum]) / sg : 0;
            this.clickY += (this.gadHeight[gadnum] - 12) * this.gadValue[gadnum] / this.gadMax[gadnum] - so;
            if (this.gadLink[gadnum] > 0) {
                this.gadRedraw[this.gadLink[gadnum]] = true;
            }
            if (this.gadLink[this.gadLink[gadnum]] != gadnum) {
                this.gadRedraw[gadnum] = true;
            }
            this.repaint();
        }
    }

    private void dragHSlider(int gadnum, int x) {
        int ss = (this.gadWidth[gadnum] - 12) * this.gadRange[gadnum] / this.gadMax[gadnum] + 8;
        int so = (this.gadWidth[gadnum] - 12) * this.gadValue[gadnum] / this.gadMax[gadnum];
        int sg = this.gadWidth[gadnum] - 4 - ss;
        int sx = this.gadX[gadnum] + so + 2;
        if (this.clickX > sx && this.clickX < sx + ss) {
            int sp = so + x - this.clickX;
            if (sp < 0) {
                sp = 0;
            }
            if (sp > sg) {
                sp = sg;
            }
            this.gadValue[gadnum] = sp > 0 ? sp * (this.gadMax[gadnum] - this.gadRange[gadnum]) / sg : 0;
            this.clickX += (this.gadWidth[gadnum] - 12) * this.gadValue[gadnum] / this.gadMax[gadnum] - so;
            if (this.gadLink[gadnum] > 0) {
                this.gadRedraw[this.gadLink[gadnum]] = true;
            }
            if (this.gadLink[this.gadLink[gadnum]] != gadnum) {
                this.gadRedraw[gadnum] = true;
            }
            this.repaint();
        }
    }

    private void drawListbox(Graphics g2, int gadnum) {
        int idx;
        int x = this.gadX[gadnum];
        int y = this.gadY[gadnum];
        int w = this.gadWidth[gadnum];
        int h2 = this.gadHeight[gadnum];
        int tw = (w - 16) / 8;
        int th = (h2 - 12) / 16;
        if (this.gadLink[gadnum] > 0) {
            this.scrollListbox(gadnum, this.gadLink[gadnum]);
            this.drawVSlider(g2, this.gadLink[gadnum]);
        }
        g2.setColor(BACKGROUND);
        g2.fillRect(x, y, w, h2);
        this.lowerBox(g2, x, y, w, h2);
        int end = this.gadText[gadnum].length;
        if (this.gadValue[gadnum] + th > end) {
            th = end - this.gadValue[gadnum];
        }
        int ty = y + 6;
        int len = idx + th;
        for (idx = this.gadValue[gadnum]; idx < len; ++idx) {
            if (this.gadText[gadnum] != null && idx < this.gadText[gadnum].length) {
                String text = this.gadText[gadnum][idx];
                if (text.length() > tw) {
                    text = text.substring(0, tw);
                } else if (text.length() < tw) {
                    char[] chars = new char[tw];
                    text.getChars(0, text.length(), chars, 0);
                    for (int c = text.length(); c < chars.length; ++c) {
                        chars[c] = 32;
                    }
                    text = new String(chars);
                }
                int clr = 0;
                if (this.gadItem[gadnum] == idx) {
                    clr = 3;
                } else if (this.gadValues[gadnum] != null && idx < this.gadValues[gadnum].length) {
                    clr = this.gadValues[gadnum][idx];
                }
                this.drawText(g2, x + 8, ty, text, clr);
            }
            ty += 16;
        }
    }

    private void clickListbox(int gadnum, boolean shift) {
        int time = (int)System.currentTimeMillis();
        int dt = time - this.gadRange[gadnum];
        int item = this.gadValue[gadnum] + (this.clickY - this.gadY[gadnum] - 6) / 16;
        if (item == this.gadItem[gadnum] && dt > 0 && dt < 500) {
            this.action(gadnum, shift);
            this.gadRange[gadnum] = 0;
        } else {
            if (item < this.gadText[gadnum].length) {
                this.gadItem[gadnum] = item;
            }
            this.gadRange[gadnum] = time;
            this.gadRedraw[gadnum] = true;
        }
    }

    private void keyListbox(int gadnum, char chr, int key, boolean shift) {
        int item = this.gadItem[gadnum];
        switch (key) {
            case 38: {
                int link;
                if (item <= 0) break;
                this.gadItem[gadnum] = --item;
                int n = link = this.gadLink[gadnum] > 0 ? this.gadLink[gadnum] : gadnum;
                if (this.gadValue[link] > item) {
                    this.gadValue[link] = item;
                }
                this.gadRedraw[gadnum] = true;
                break;
            }
            case 40: {
                int link;
                if (item >= this.gadText[gadnum].length - 1) break;
                this.gadItem[gadnum] = ++item;
                int rows = (this.gadHeight[gadnum] - 12) / 16;
                int n = link = this.gadLink[gadnum] > 0 ? this.gadLink[gadnum] : gadnum;
                if (this.gadValue[link] + rows <= item) {
                    this.gadValue[link] = item - rows + 1;
                }
                this.gadRedraw[gadnum] = true;
                break;
            }
            default: {
                if (chr != '\n') break;
                this.action(gadnum, shift);
            }
        }
    }

    private void scrollListbox(int listbox, int slider) {
        this.gadRange[slider] = (this.gadHeight[listbox] - 12) / 16;
        if (this.gadText[listbox] != null) {
            this.gadMax[slider] = this.gadText[listbox].length;
        }
        if (this.gadRange[slider] > this.gadMax[slider]) {
            this.gadRange[slider] = this.gadMax[slider];
        }
        if (this.gadValue[slider] + this.gadRange[slider] > this.gadMax[slider]) {
            this.gadValue[slider] = this.gadMax[slider] - this.gadRange[slider];
        }
        if (this.gadValue[slider] < 0) {
            this.gadValue[slider] = 0;
        }
        this.gadValue[listbox] = this.gadValue[slider];
    }

    private void drawPattern(Graphics g2, int gadnum) {
        int scroll = this.gadValue[3];
        int pat = this.module.sequence[this.ibxm.getSequencePos()];
        int rows = this.module.patterns[pat].numRows;
        int x = this.gadX[gadnum];
        int y = this.gadY[gadnum];
        if (this.gadLink[gadnum] > 0) {
            this.gadMax[this.gadLink[gadnum]] = rows + 14;
            this.gadValue[gadnum] = this.gadValue[this.gadLink[gadnum]];
            if (this.gadValue[gadnum] >= rows) {
                this.gadValue[gadnum] = rows - 1;
            }
            this.drawVSlider(g2, this.gadLink[gadnum]);
        }
        this.drawInt(g2, x, y, pat, 3, 7);
        this.drawText(g2, x + 24, y, " ", 7);
        for (int c = 0; c < this.displayChannels; ++c) {
            int clr = (this.mute >> c + scroll & 1L) > 0L ? 7 : 4;
            this.drawText(g2, x + (c * 11 + 4) * 8, y, clr == 7 ? " Muted     " : "Channel    ", clr);
            this.drawInt(g2, x + (c * 11 + 12) * 8, y, c + scroll + 1, 2, clr);
        }
        Note note = new Note();
        char[] chars = new char[10];
        for (int r = 1; r < 16; ++r) {
            int dr = this.gadValue[gadnum] - 8 + r;
            if (r == 15 && this.error != null) {
                String msg = this.error.length() > 11 * this.displayChannels ? this.error.substring(0, 11 * this.displayChannels) : this.error;
                this.drawText(g2, x, y + r * 16, "*** " + IBXMPlayer3.pad(this.error, ' ', 11 * this.displayChannels, false), 7);
                continue;
            }
            if (dr < 0 || dr >= rows) {
                g2.setColor(Color.BLACK);
                g2.fillRect(x, y + r * 16, (4 + 11 * this.displayChannels) * 8, 16);
                continue;
            }
            int hl = r == 8 ? 8 : 0;
            this.drawText(g2, x, y + r * 16, "    ", 4 + hl);
            this.drawInt(g2, x, y + r * 16, dr, 3, 4 + hl);
            for (int c = 0; c < this.displayChannels; ++c) {
                if (c + scroll >= this.module.numChannels) {
                    this.drawText(g2, x + (c * 11 + 4) * 8, y + r * 16, "           ", 4);
                    continue;
                }
                this.module.patterns[pat].getNote(dr * this.module.numChannels + c + scroll, note).toChars(chars);
                if ((this.mute >> c + scroll & 1L) > 0L) {
                    this.drawText(g2, x + (c * 11 + 4) * 8, y + r * 16, new String(chars), 4);
                    this.drawText(g2, x + (c * 11 + 14) * 8, y + r * 16, " ", 4);
                    continue;
                }
                int clr = chars[0] == '-' ? 4 : 6;
                this.drawText(g2, x + (c * 11 + 4) * 8, y + r * 16, new String(chars, 0, 3), clr + hl);
                clr = chars[3] == '-' ? 4 : 7;
                this.drawText(g2, x + (c * 11 + 7) * 8, y + r * 16, new String(chars, 3, 1), clr + hl);
                clr = chars[4] == '-' ? 4 : 7;
                this.drawText(g2, x + (c * 11 + 8) * 8, y + r * 16, new String(chars, 4, 1), clr + hl);
                clr = chars[5] >= '0' && chars[5] <= 'F' ? VC_COLOURS[chars[5] - 48] : 4;
                this.drawText(g2, x + (c * 11 + 9) * 8, y + r * 16, new String(chars, 5, 2), clr + hl);
                clr = chars[7] == 'E' && chars[8] >= '0' && chars[8] <= 'F' ? EX_COLOURS[chars[8] - 48] : (chars[7] == 's' && chars[8] >= '0' && chars[8] <= 'F' ? SX_COLOURS[chars[8] - 48] : (chars[7] >= '0' && chars[7] <= '~' ? FX_COLOURS[chars[7] - 48] : 4));
                if (chars[7] >= 'a') {
                    chars[7] = (char)(chars[7] - 32);
                }
                this.drawText(g2, x + (c * 11 + 11) * 8, y + r * 16, new String(chars, 7, 3), clr + hl);
                this.drawText(g2, x + (c * 11 + 14) * 8, y + r * 16, " ", clr + hl);
            }
        }
    }

    private void clickPattern(int gadnum, boolean shift) {
        int scroll = this.gadValue[3];
        int dspRow = (this.clickY - this.gadY[gadnum]) / 16;
        int dspCol = (this.clickX - this.gadX[gadnum]) / 8;
        int chn = scroll + (dspCol - 4) / 11;
        int row = this.gadValue[gadnum] + dspRow - 8;
        long mask = 1 << chn;
        this.mute = this.mute == (mask ^ 0xFFFFFFFFFFFFFFFFL) || dspCol < 4 || chn >= this.module.numChannels ? 0L : ((this.mute & mask) > 0L ? (this.mute ^= mask) : 0xFFFFFFFFFFFFFFFFL ^ mask);
        this.ibxm.setMuted(-1, false);
        for (int idx = 0; idx < this.module.numChannels; ++idx) {
            this.ibxm.setMuted(idx, ((long)(1 << idx) & this.mute) != 0L);
        }
        this.gadRedraw[1] = true;
    }

    private int mapNoteKey(KeyEvent event) {
        int keyCode = event.getKeyCode();
        for (int idx = 0; idx < KEY_MAP.length; ++idx) {
            if (KEY_MAP[idx] != keyCode) continue;
            return idx + 1 + this.octave * 12;
        }
        return -1;
    }

    private void trigger(int channel, int noteKey, boolean sustain) {
        if (!this.ibxm.getSequencerEnabled()) {
            if (noteKey < 1 || noteKey > 96) {
                this.stop();
            } else if (this.keyChannel[noteKey] < 1) {
                if (channel < 0) {
                    for (int chn = 0; chn < this.module.numChannels; ++chn) {
                        this.triggerChannel = (this.triggerChannel + 1) % this.module.numChannels;
                        if ((this.mute >> this.triggerChannel & 1L) == 0L) break;
                    }
                    channel = this.triggerChannel;
                }
                Note note = new Note();
                note.key = noteKey;
                note.instrument = this.instrument;
                this.ibxm.trigger(channel, note);
                this.keyChannel[noteKey] = sustain ? 0 : channel + 1;
            }
        }
    }

    private void release(int noteKey) {
        int channel;
        if (!this.ibxm.getSequencerEnabled() && noteKey > 0 && noteKey < 97 && (channel = this.keyChannel[noteKey] - 1) >= 0) {
            Note note = new Note();
            note.key = 97;
            this.ibxm.trigger(channel, note);
            this.keyChannel[noteKey] = 0;
        }
    }

    private int findGadget(int x, int y) {
        for (int idx = 0; idx < 32; ++idx) {
            if (this.gadType[idx] <= 0) continue;
            int x0 = this.gadX[idx];
            int y0 = this.gadY[idx];
            int x1 = x0 + this.gadWidth[idx];
            int y1 = y0 + this.gadHeight[idx];
            if (x < x0 || y < y0 || x >= x1 || y >= y1) continue;
            return idx;
        }
        return 0;
    }

    private void createGadget(int gadnum, int type, int x, int y, int w, int h2) {
        this.gadType[gadnum] = type;
        this.gadX[gadnum] = x;
        this.gadY[gadnum] = y;
        this.gadWidth[gadnum] = w;
        this.gadHeight[gadnum] = h2;
    }

    private void createLabel(int gadnum, int x, int y, String text, int colour) {
        this.createGadget(gadnum, 1, x, y, text.length() * 8, 16);
        this.gadText[gadnum] = new String[]{text};
        this.gadValue[gadnum] = colour;
    }

    private void createButton(int gadnum, int x, int y, int w, int h2, String text) {
        this.createGadget(gadnum, 2, x, y, w, h2);
        this.gadText[gadnum] = new String[]{text};
    }

    private void createTextbox(int gadnum, int x, int y, int w, int h2, String text) {
        this.createGadget(gadnum, 3, x, y, w, h2);
        this.gadText[gadnum] = new String[]{text};
    }

    private void createVSlider(int gadnum, int x, int y, int w, int h2, int range, int max) {
        this.createGadget(gadnum, 4, x, y, w, h2);
        this.gadValue[gadnum] = 0;
        this.gadRange[gadnum] = range;
        this.gadMax[gadnum] = max;
    }

    private void createHSlider(int gadnum, int x, int y, int w, int h2, int range, int max) {
        this.createGadget(gadnum, 5, x, y, w, h2);
        this.gadValue[gadnum] = 0;
        this.gadRange[gadnum] = range;
        this.gadMax[gadnum] = max;
    }

    private void createListbox(int gadnum, int x, int y, int w, int h2, int slider) {
        this.createGadget(gadnum, 6, x, y, w, h2);
        this.gadLink[gadnum] = slider;
        this.gadLink[slider] = gadnum;
    }

    private void createPattern(int gadnum, int x, int y, int channels, int slider) {
        this.createGadget(gadnum, 7, x, y, (4 + 11 * channels) * 8, 256);
        this.gadLink[gadnum] = slider;
        this.gadLink[slider] = gadnum;
    }

    private void escape(int gadnum) {
        switch (gadnum) {
            case 9: {
                this.gadText[gadnum][0] = this.module.songName;
            }
        }
    }

    private void action(int gadnum, boolean shift) {
        try {
            switch (gadnum) {
                case 4: {
                    this.selectedFile = 0;
                }
                case 5: {
                    this.listDir(this.getDir());
                    this.gadItem[6] = this.selectedFile;
                    this.gadValue[7] = this.selectedFile - 3;
                    break;
                }
                case 6: 
                case 18: {
                    if (this.gadValues[6][0] == 0) {
                        this.setInstrument(this.gadItem[6] + 1);
                        break;
                    }
                    File file = new File(this.gadText[4][0]);
                    if (this.gadItem[6] > 0) {
                        if ((file = new File(file, this.gadText[6][this.gadItem[6]].substring(6))).isDirectory()) {
                            this.selectedFile = 0;
                            this.listDir(file);
                            break;
                        }
                        this.selectedFile = this.gadItem[6];
                        this.load(file);
                        break;
                    }
                    if ((file = file.getParentFile()) != null) {
                        this.selectedFile = 0;
                        this.listDir(file);
                    }
                    break;
                }
                case 13: {
                    this.setInstrument(this.instrument + 1);
                    this.listInstruments();
                    break;
                }
                case 12: {
                    this.setInstrument(this.instrument - 1);
                    this.listInstruments();
                    break;
                }
                case 9: {
                    this.gadText[gadnum][0] = this.module.songName;
                    break;
                }
                case 16: {
                    this.setSeqPos(this.gadItem[gadnum]);
                    this.setRow(0);
                    if (this.ibxm.getSequencerEnabled()) {
                        this.ibxm.seekSequencePos(this.getSeqPos(), 0);
                        break;
                    }
                    this.ibxm.setSequencePos(this.getSeqPos());
                    this.stop();
                    break;
                }
                case 20: {
                    if (this.ibxm.getSequencerEnabled()) {
                        this.stop();
                        break;
                    }
                    this.play();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError(e.getMessage());
        }
    }

    private static String[] getFileNames(File[] files, String[] names) {
        File file;
        int idx;
        if (names != null) {
            names[0] = "[Parent Dir]";
        }
        int len = 1;
        for (idx = 0; idx < files.length; ++idx) {
            file = files[idx];
            if (file.isHidden() || !file.isDirectory()) continue;
            if (names != null) {
                names[len] = "[Dir] " + file.getName();
            }
            ++len;
        }
        for (idx = 0; idx < files.length; ++idx) {
            file = files[idx];
            if (file.isHidden() || !file.isFile()) continue;
            if (names != null) {
                long size = file.length();
                String prefix = size > 0x40000000L ? "(>9g) " : (size > 10238976L ? IBXMPlayer3.pad(Long.toString(size / 0x100000L), ' ', 4, true) + "m " : (size > 9999L ? IBXMPlayer3.pad(Long.toString(size / 1024L), ' ', 4, true) + "k " : IBXMPlayer3.pad(Long.toString(size), ' ', 5, true) + " "));
                names[len] = prefix + file.getName();
            }
            ++len;
        }
        return names != null ? names : IBXMPlayer3.getFileNames(files, new String[len]);
    }

    private File getDir() {
        File file = new File(this.gadText[4][0]);
        if (!file.isDirectory()) {
            file = new File(System.getProperty("user.home"));
        }
        return file;
    }

    private void listDir(File file) {
        Object[] files = file.listFiles();
        Arrays.sort(files);
        String[] names = IBXMPlayer3.getFileNames((File[])files, null);
        int[] values = new int[names.length];
        for (int idx = 0; idx < names.length; ++idx) {
            values[idx] = names[idx].charAt(0) == '[' ? 1 : 0;
        }
        this.gadText[4][0] = file.getAbsolutePath();
        this.gadText[6] = names;
        this.gadItem[6] = 0;
        this.gadValue[7] = 0;
        this.gadValues[6] = values;
        this.gadText[14] = KEYS;
        this.gadRedraw[4] = true;
        this.gadRedraw[6] = true;
        this.gadRedraw[14] = true;
    }

    private static int parsePositiveInt(String str, int max) {
        int value = 0;
        int len = str.length();
        for (int idx = 0; idx < len; ++idx) {
            char chr = str.charAt(idx);
            if (chr < '0' || chr > '9') continue;
            value = value * 10 + chr - 48;
        }
        return value > max ? max : value;
    }

    private void setSequence(int[] sequence) {
        String[] items = new String[sequence.length];
        for (int idx = 0; idx < items.length; ++idx) {
            String pat = String.valueOf(sequence[idx]);
            items[idx] = IBXMPlayer3.pad(String.valueOf(idx), '0', 3, true) + ' ' + IBXMPlayer3.pad(pat, ' ', 3, true);
        }
        this.gadText[16] = items;
        this.module.sequence = sequence;
        int seqPos = this.getSeqPos();
        if (seqPos >= sequence.length) {
            seqPos = sequence.length - 1;
        }
        this.setSeqPos(seqPos);
    }

    private int getRow() {
        return this.gadValue[2];
    }

    private void setRow(int row) {
        this.gadValue[2] = row;
        this.gadRedraw[1] = true;
    }

    private int getSeqPos() {
        return this.gadItem[16];
    }

    private void setSeqPos(int seqPos) {
        if (seqPos >= this.module.sequenceLength) {
            seqPos = 0;
        }
        this.gadItem[16] = seqPos;
        this.gadRedraw[16] = true;
        this.gadRedraw[1] = true;
    }

    private void setInstrument(int idx) {
        if (idx < 1) {
            idx = 1;
        }
        if (idx > this.module.numInstruments) {
            idx = this.module.numInstruments;
        }
        this.instrument = idx;
        this.gadText[11][0] = String.valueOf(this.instrument);
        StringBuffer sb = new StringBuffer();
        this.module.instruments[this.instrument].toStringBuffer(sb);
        this.gadText[14] = IBXMPlayer3.split(sb.toString(), '\n');
        this.gadRedraw[11] = true;
        this.gadRedraw[14] = true;
    }

    private void listInstruments() {
        int cols = (this.gadWidth[6] - 16) / 8;
        String[] names = new String[this.module.numInstruments];
        for (int ins = 1; ins <= names.length; ++ins) {
            Sample sam2 = this.module.instruments[ins].samples[0];
            String name = IBXMPlayer3.pad(this.module.instruments[ins].name, ' ', cols - 11, false);
            String len = IBXMPlayer3.pad(String.valueOf(sam2.getLoopStart() + sam2.getLoopLength()), ' ', 7, true);
            names[ins - 1] = IBXMPlayer3.pad(String.valueOf(ins), '0', 3, true) + ' ' + name + len;
        }
        this.gadValues[6] = new int[names.length];
        this.gadItem[6] = this.instrument - 1;
        this.gadText[6] = names;
        this.gadValue[7] = this.instrument - 4;
        this.gadRedraw[6] = true;
    }

    private void play() {
        this.error = null;
        this.ibxm.setSequencerEnabled(true);
        this.ibxm.seekSequencePos(this.getSeqPos(), this.gadValue[1]);
        this.gadText[20][0] = "Stop";
        this.gadRedraw[20] = true;
    }

    private void stop() {
        int idx;
        Note note = new Note();
        note.effect = 16;
        note.param = 256;
        this.ibxm.trigger(0, note);
        this.ibxm.setSequencerEnabled(false);
        for (idx = 0; idx < this.module.numChannels; ++idx) {
            note.volume = 16;
            note.effect = 8;
            note.param = (idx & 3) == 1 || (idx & 3) == 2 ? 204 : 51;
            this.ibxm.trigger(idx, note);
        }
        for (idx = 0; idx < this.keyChannel.length; ++idx) {
            this.keyChannel[idx] = 0;
        }
        this.gadText[20][0] = "Play";
        this.gadRedraw[20] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file) throws IOException {
        System.out.println("Load " + file.getAbsolutePath());
        try (FileInputStream inputStream = new FileInputStream(file);){
            Module module = new Module(new Data(inputStream));
            IBXM ibxm = new IBXM(module, 48000);
            ibxm.setInterpolation(this.ibxm.getInterpolation());
            this.module = module;
            this.ibxm = ibxm;
        }
        int[] sequence = new int[this.module.sequenceLength];
        System.arraycopy(this.module.sequence, 0, sequence, 0, sequence.length);
        this.setSequence(sequence);
        this.gadItem[1] = 0;
        this.gadText[9][0] = this.module.songName.trim();
        this.gadRedraw[9] = true;
        this.setSeqPos(0);
        this.gadValue[17] = 0;
        this.setRow(0);
        this.gadValue[7] = 0;
        int max = this.module.numChannels;
        if (max < this.displayChannels) {
            max = this.displayChannels;
        }
        this.gadMax[3] = max;
        this.gadValue[3] = 0;
        this.gadRedraw[3] = true;
        this.setInstrument(1);
        this.listInstruments();
        this.mute = 0L;
        this.stop();
    }

    private synchronized int getAudio(int[] output) {
        int count = this.ibxm.getAudio(output);
        if (this.ibxm.getSequencerEnabled() && this.focus != 2) {
            int seqPos = this.ibxm.getSequencePos();
            int row = this.ibxm.getRow();
            if (seqPos != this.getSeqPos() || row != this.getRow()) {
                int dt = (int)System.currentTimeMillis() - this.gadRange[16];
                if (seqPos != this.getSeqPos() && (dt < 0 || dt > 500)) {
                    this.setSeqPos(seqPos);
                    this.gadValue[17] = seqPos - 4;
                }
                this.setRow(row);
                this.repaint();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int channels = 10;
        if (args.length > 0 && (channels = IBXMPlayer3.parsePositiveInt(args[0], 32)) < 8) {
            channels = 8;
        }
        IBXMPlayer3 ibxmPlayer3 = new IBXMPlayer3(channels);
        Frame frame = new Frame("IBXM a75 (c)2021 mumart@gmail.com");
        frame.setIconImage(ibxmPlayer3.iconImage());
        frame.addWindowListener(ibxmPlayer3);
        frame.add((Component)ibxmPlayer3, "Center");
        frame.pack();
        frame.setResizable(false);
        frame.setVisible(true);
        AudioFormat audioFormat = new AudioFormat(48000.0f, 16, 2, true, false);
        sourceDataLine.open(audioFormat, 16384);
        try (SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, audioFormat));){
            sourceDataLine.start();
            int[] reverbBuf = new int[4800];
            int[] mixBuf = new int[ibxmPlayer3.ibxm.getMixBufferLength()];
            byte[] outBuf = new byte[mixBuf.length * 2];
            boolean mixIdx = false;
            boolean mixLen = false;
            int reverbIdx = 0;
            while (frame.isDisplayable()) {
                int count = ibxmPlayer3.getAudio(mixBuf);
                if (ibxmPlayer3.reverb) {
                    reverbIdx = IBXMPlayer3.reverb(mixBuf, reverbBuf, reverbIdx, count);
                }
                IBXMPlayer3.clip(mixBuf, outBuf, count * 2);
                sourceDataLine.write(outBuf, 0, count * 4);
            }
        }
    }
}

