/*
 * Decompiled with CFR 0.152.
 */
package ibxm;

import ibxm.IBXM;
import ibxm.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WavInputStream
extends InputStream {
    private static final byte[] header = new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 16, 0, 100, 97, 116, 97, 0, 0, 0, 0};
    private IBXM ibxm;
    private int[] mixBuf;
    private byte[] outBuf;
    private int outIdx;
    private int outLen;
    private int remain;
    private int fadeLen;

    public WavInputStream(IBXM ibxm) {
        this(ibxm, ibxm.calculateSongDuration(), 0);
    }

    public WavInputStream(IBXM ibxm, int duration, int fadeOutSeconds) {
        this.ibxm = ibxm;
        this.mixBuf = new int[ibxm.getMixBufferLength()];
        this.outBuf = new byte[this.mixBuf.length * 2];
        int dataLen = duration * 4;
        int samplingRate = ibxm.getSampleRate();
        System.arraycopy(header, 0, this.outBuf, 0, header.length);
        WavInputStream.writeInt32(this.outBuf, 4, dataLen + 36);
        WavInputStream.writeInt32(this.outBuf, 24, samplingRate);
        WavInputStream.writeInt32(this.outBuf, 28, samplingRate * 4);
        WavInputStream.writeInt32(this.outBuf, 40, dataLen);
        this.outIdx = 0;
        this.outLen = header.length;
        this.remain = header.length + dataLen;
        this.fadeLen = samplingRate * 4 * fadeOutSeconds;
    }

    public int getBytesRemaining() {
        return this.remain;
    }

    @Override
    public int available() {
        return this.outLen - this.outIdx;
    }

    @Override
    public int read() {
        int out = -1;
        if (this.remain > 0) {
            out = this.outBuf[this.outIdx++];
            if (this.outIdx >= this.outLen) {
                this.getAudio();
            }
            --this.remain;
        }
        return out;
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        int count = -1;
        if (this.remain > 0) {
            int outRem;
            count = this.remain;
            if (count > len) {
                count = len;
            }
            if (count > (outRem = this.outLen - this.outIdx)) {
                count = outRem;
            }
            System.arraycopy(this.outBuf, this.outIdx, buf, off, count);
            this.outIdx += count;
            if (this.outIdx >= this.outLen) {
                this.getAudio();
            }
            this.remain -= count;
        }
        return count;
    }

    private void getAudio() {
        int mEnd = this.ibxm.getAudio(this.mixBuf) * 2;
        int gain = 1024;
        if (this.remain < this.fadeLen) {
            gain = this.remain / (this.fadeLen >> 10);
            gain = gain * gain * gain >> 20;
        }
        int oIdx = 0;
        for (int mIdx = 0; mIdx < mEnd; ++mIdx) {
            int ampl = this.mixBuf[mIdx] * gain >> 10;
            if (ampl > Short.MAX_VALUE) {
                ampl = Short.MAX_VALUE;
            }
            if (ampl < Short.MIN_VALUE) {
                ampl = Short.MIN_VALUE;
            }
            this.outBuf[oIdx++] = (byte)ampl;
            this.outBuf[oIdx++] = (byte)(ampl >> 8);
        }
        this.outIdx = 0;
        this.outLen = mEnd * 2;
    }

    private static void writeInt32(byte[] buf, int idx, int value) {
        buf[idx] = (byte)value;
        buf[idx + 1] = (byte)(value >> 8);
        buf[idx + 2] = (byte)(value >> 16);
        buf[idx + 3] = (byte)(value >> 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        File modFile = null;
        File wavFile = null;
        boolean fadeOut = false;
        int argIdx = 0;
        int interpolation = 0;
        while (argIdx < args.length) {
            String arg;
            if ("-linear".equals(arg = args[argIdx++])) {
                interpolation = 1;
                continue;
            }
            if ("-sinc".equals(arg)) {
                interpolation = 2;
                continue;
            }
            if ("-fade".equals(arg)) {
                fadeOut = true;
                continue;
            }
            if (modFile == null) {
                modFile = new File(arg);
                continue;
            }
            wavFile = new File(arg);
        }
        if (modFile == null || wavFile == null) {
            System.err.println("Mod to Wav converter for IBXM a75 (c)2021 mumart@gmail.com");
            System.err.println("Usage: java " + WavInputStream.class.getName() + " [-linear] [-sinc] [-fade] modfile wavfile");
        } else if (wavFile.exists()) {
            System.err.println("Output file already exists: " + wavFile.getName());
        } else {
            IBXM ibxm = new IBXM(new Module(new FileInputStream(modFile)), 48000);
            ibxm.setInterpolation(interpolation);
            int duration = ibxm.calculateSongDuration();
            if (fadeOut) {
                duration += ibxm.getSampleRate() * 16;
            }
            WavInputStream in = new WavInputStream(ibxm, duration, fadeOut ? 16 : 0);
            try (FileOutputStream out = new FileOutputStream(wavFile);){
                int count;
                byte[] buf = new byte[ibxm.getMixBufferLength() * 2];
                for (int remain = in.getBytesRemaining(); remain > 0; remain -= count) {
                    count = remain > buf.length ? buf.length : remain;
                    count = in.read(buf, 0, count);
                    ((OutputStream)out).write(buf, 0, count);
                }
            }
        }
    }
}

