/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.musicplayer;

import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.discord.DiscordBot;
import com.gmail.berndivader.streamserver.discord.musicplayer.MusicPlayer;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.PlayerPauseEvent;
import com.sedmelluq.discord.lavaplayer.player.event.PlayerResumeEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackExceptionEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackStartEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackStuckEvent;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import discord4j.core.object.entity.channel.VoiceChannel;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class TrackScheduler
extends AudioEventAdapter {
    private final VoiceChannel voiceChannel;
    private final Map<Class<? extends AudioEvent>, Consumer<AudioEvent>> handlers = new HashMap<Class<? extends AudioEvent>, Consumer<AudioEvent>>();

    public TrackScheduler(VoiceChannel voice) {
        this.voiceChannel = voice;
        this.handlers.put(PlayerPauseEvent.class, event -> this.onPlayerPause(event.player));
        this.handlers.put(PlayerResumeEvent.class, event -> this.onPlayerResume(event.player));
        this.handlers.put(TrackStartEvent.class, event -> {
            TrackStartEvent start = (TrackStartEvent)event;
            this.onTrackStart(start.player, start.track);
        });
        this.handlers.put(TrackEndEvent.class, event -> {
            TrackEndEvent end = (TrackEndEvent)event;
            this.onTrackEnd(end.player, end.track, end.endReason);
        });
        this.handlers.put(TrackExceptionEvent.class, event -> {
            TrackExceptionEvent exception = (TrackExceptionEvent)event;
            this.onTrackException(exception.player, exception.track, exception.exception);
        });
        this.handlers.put(TrackStuckEvent.class, event -> {
            TrackStuckEvent stuck = (TrackStuckEvent)event;
            this.onTrackStuck(stuck.player, stuck.track, stuck.thresholdMs, stuck.stackTrace);
        });
    }

    @Override
    public void onPlayerPause(AudioPlayer player) {
        if (Config.DEBUG.booleanValue()) {
            ANSI.println("Audioplayer paused!");
        }
    }

    @Override
    public void onPlayerResume(AudioPlayer player) {
        if (Config.DEBUG.booleanValue()) {
            ANSI.println("Audioplayer resumed!");
        }
    }

    @Override
    public void onTrackStart(AudioPlayer player, AudioTrack track) {
        this.voiceChannel.createMessage(Paths.get(track.getIdentifier(), new String[0]).getFileName().toString()).subscribe();
    }

    @Override
    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        AudioTrack next = player.getScheduledTrack();
        if (next == null) {
            next = DiscordBot.instance.provider.scheduledTracks.poll();
        }
        if (next != null) {
            player.playTrack(next);
        } else if (Config.DISCORD_MUSIC_AUTOPLAY.booleanValue()) {
            MusicPlayer.playRandomMusic();
        }
    }

    @Override
    public void onTrackException(AudioPlayer player, AudioTrack track, FriendlyException exception) {
        if (Config.DEBUG.booleanValue()) {
            ANSI.error(exception.getMessage(), exception);
        }
    }

    @Override
    public void onTrackStuck(AudioPlayer player, AudioTrack track, long thresholdMs, StackTraceElement[] stackTrace) {
        this.onTrackStuck(player, track, thresholdMs);
    }

    @Override
    public void onTrackStuck(AudioPlayer player, AudioTrack track, long thresholdMs) {
        if (Config.DEBUG.booleanValue()) {
            ANSI.error("AudioTrack stuck: " + track.getIdentifier(), null);
        }
    }

    @Override
    public void onEvent(AudioEvent event) {
        Optional.ofNullable(this.handlers.get(event.getClass())).ifPresentOrElse(handler -> handler.accept(event), () -> {
            if (Config.DEBUG.booleanValue()) {
                ANSI.warn(String.format("Unhandled AudioEvent occured: [GREEN]%s[RESET]", event.getClass().getSimpleName()));
            }
        });
    }
}

