/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.vimeo;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.container.playlists.HlsStreamTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VimeoAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(VimeoAudioTrack.class);
    private final VimeoAudioSourceManager sourceManager;

    public VimeoAudioTrack(AudioTrackInfo trackInfo, VimeoAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        block25: {
            try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
                PlaybackSource playbackSource = this.getPlaybackSource(httpInterface);
                log.debug("Starting Vimeo track. HLS: {}, URL: {}", (Object)playbackSource.isHls, (Object)playbackSource.url);
                if (playbackSource.isHls) {
                    this.processDelegate(new HlsStreamTrack(this.trackInfo, this.extractHlsAudioPlaylistUrl(httpInterface, playbackSource.url), this.sourceManager.getHttpInterfaceManager(), true), localExecutor);
                    break block25;
                }
                try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(playbackSource.url), null);){
                    this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
                }
            }
        }
    }

    private PlaybackSource getPlaybackSource(HttpInterface httpInterface) throws IOException {
        JsonBrowser config = this.loadPlayerConfig(httpInterface);
        if (config == null) {
            throw new FriendlyException("Track information not present on the page.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        String trackConfigUrl = config.get("player").get("config_url").text();
        JsonBrowser trackConfig = this.loadTrackConfig(httpInterface, trackConfigUrl);
        JsonBrowser files = trackConfig.get("request").get("files");
        if (!files.get("progressive").values().isEmpty()) {
            String url = files.get("progressive").index(0).get("url").text();
            return new PlaybackSource(url, false);
        }
        JsonBrowser hls = files.get("hls");
        String defaultCdn = hls.get("default_cdn").text();
        return new PlaybackSource(hls.get("cdns").get(defaultCdn).get("url").text(), true);
    }

    private JsonBrowser loadPlayerConfig(HttpInterface httpInterface) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(this.trackInfo.identifier));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code for player config is " + statusCode));
            }
            JsonBrowser jsonBrowser = this.sourceManager.loadConfigJsonFromPageContent(IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8));
            return jsonBrowser;
        }
    }

    private JsonBrowser loadTrackConfig(HttpInterface httpInterface, String trackAccessInfoUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(trackAccessInfoUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code for track access info is " + statusCode));
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    protected String resolveRelativeUrl(String baseUrl, String url) {
        while (url.startsWith("../")) {
            url = url.substring(3);
            baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47));
        }
        return baseUrl + (url.startsWith("/") ? url : "/" + url);
    }

    private String extractHlsAudioPlaylistUrl(HttpInterface httpInterface, String videoPlaylistUrl) throws IOException {
        String url = null;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(videoPlaylistUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code for track access info is " + statusCode));
            }
            String bodyString = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            for (String rawLine : bodyString.split("\n")) {
                ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(rawLine);
                if (!Objects.equals(line.directiveName, "EXT-X-MEDIA") || !Objects.equals(line.directiveArguments.get("TYPE"), "AUDIO")) continue;
                url = line.directiveArguments.get("URI");
                break;
            }
        }
        if (url == null) {
            throw new FriendlyException("Failed to find audio playlist URL.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Valid audio directive was not found"));
        }
        return this.resolveRelativeUrl(videoPlaylistUrl.substring(0, videoPlaylistUrl.lastIndexOf(47)), url);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new VimeoAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    private static class PlaybackSource {
        public String url;
        public boolean isHls;

        public PlaybackSource(String url, boolean isHls) {
            this.url = url;
            this.isHls = isHls;
        }
    }
}

