/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.grack.nanojson.JsonStringWriter;
import com.grack.nanojson.JsonWriter;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.util.HashMap;
import java.util.Map;

public class YoutubeClientConfig {
    public static final String MOBILE_CLIENT_VERSION = "18.11.34";
    public static final AndroidVersion DEFAULT_ANDROID_VERSION = AndroidVersion.ANDROID_11;
    public static YoutubeClientConfig ANDROID = new YoutubeClientConfig().withApiKey("AIzaSyA8eiZmM1FaDVjRy-df2KTyQ_vz_yYM39w").withUserAgent(String.format("com.google.android.youtube/%s (Linux; U; Android %s) gzip", "18.11.34", DEFAULT_ANDROID_VERSION.getOsVersion())).withClientName("ANDROID").withClientField("clientVersion", "18.11.34").withClientField("androidSdkVersion", DEFAULT_ANDROID_VERSION.getSdkVersion()).withUserField("lockedSafetyMode", false);
    public static YoutubeClientConfig IOS = new YoutubeClientConfig().withApiKey("AIzaSyB-63vPrdThhKuerbB2N_l7Kwwcxj6yUAc").withUserAgent(String.format("com.google.ios.youtube/%s (iPhone14,5; U; CPU iOS 15_6 like Mac OS X)", "18.11.34")).withClientName("IOS").withClientField("clientVersion", "18.11.34").withClientField("osName", "iOS").withClientField("osVersion", "15.6.0.19G71").withClientField("deviceMake", "Apple").withClientField("deviceModel", "iPhone14,5").withClientField("platform", "MOBILE").withClientField("hl", "en-US").withClientField("gl", "US").withUserField("lockedSafetyMode", false);
    public static YoutubeClientConfig TV_EMBEDDED = new YoutubeClientConfig().withApiKey("AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8").withClientName("TVHTML5_SIMPLY_EMBEDDED_PLAYER").withClientField("clientVersion", "2.0");
    public static YoutubeClientConfig WEB = new YoutubeClientConfig().withApiKey("AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8").withClientName("WEB").withClientField("clientVersion", "2.20240224.11.00").withUserField("lockedSafetyMode", false);
    public static YoutubeClientConfig MUSIC = new YoutubeClientConfig().withApiKey("AIzaSyC9XL3ZjWddXya6X74dJoCTL-WEYFDNX30").withClientName("WEB_REMIX").withClientField("clientVersion", "1.20220727.01.00");
    private String name;
    private String userAgent;
    private String apiKey;
    private final Map<String, Object> root;

    public YoutubeClientConfig() {
        this.root = new HashMap<String, Object>();
        this.userAgent = null;
        this.name = null;
    }

    private YoutubeClientConfig(Map<String, Object> context, String userAgent, String name) {
        this.root = context;
        this.userAgent = userAgent;
        this.name = name;
    }

    public YoutubeClientConfig copy() {
        return new YoutubeClientConfig(new HashMap<String, Object>(this.root), this.userAgent, this.name);
    }

    public YoutubeClientConfig withClientName(String name) {
        this.name = name;
        this.withClientField("clientName", name);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public YoutubeClientConfig withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public YoutubeClientConfig withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Map<String, Object> putOnceAndJoin(Map<String, Object> on, String key) {
        return (Map)on.computeIfAbsent(key, __ -> new HashMap());
    }

    public YoutubeClientConfig withClientDefaultScreenParameters() {
        this.withClientField("screenDensityFloat", 1);
        this.withClientField("screenHeightPoints", 1080);
        this.withClientField("screenPixelDensity", 1);
        return this.withClientField("screenWidthPoints", 1920);
    }

    public YoutubeClientConfig withThirdPartyEmbedUrl(String embedUrl) {
        Map<String, Object> context = this.putOnceAndJoin(this.root, "context");
        Map<String, Object> thirdParty = this.putOnceAndJoin(context, "thirdParty");
        thirdParty.put("embedUrl", embedUrl);
        return this;
    }

    public YoutubeClientConfig withPlaybackSignatureTimestamp(String signatureTimestamp) {
        Map<String, Object> playbackContext = this.putOnceAndJoin(this.root, "playbackContext");
        Map<String, Object> contentPlaybackContext = this.putOnceAndJoin(playbackContext, "contentPlaybackContext");
        contentPlaybackContext.put("signatureTimestamp", signatureTimestamp);
        return this;
    }

    public YoutubeClientConfig withRootField(String key, Object value) {
        this.root.put(key, value);
        return this;
    }

    public YoutubeClientConfig withClientField(String key, Object value) {
        Map<String, Object> context = this.putOnceAndJoin(this.root, "context");
        Map<String, Object> client = this.putOnceAndJoin(context, "client");
        client.put(key, value);
        return this;
    }

    public YoutubeClientConfig withUserField(String key, Object value) {
        Map<String, Object> context = this.putOnceAndJoin(this.root, "context");
        Map<String, Object> user = this.putOnceAndJoin(context, "user");
        user.put(key, value);
        return this;
    }

    public YoutubeClientConfig setAttributes(HttpInterface httpInterface) {
        if (this.userAgent != null) {
            httpInterface.getContext().setAttribute("clientUserAgent", this.userAgent);
        }
        return this;
    }

    public String toJsonString() {
        return ((JsonStringWriter)JsonWriter.string().object((Map)this.root)).done();
    }

    public static enum AndroidVersion {
        ANDROID_13("13", 33),
        ANDROID_12("12", 31),
        ANDROID_11("11", 30);

        private final String osVersion;
        private final int sdkVersion;

        private AndroidVersion(String osVersion, int sdkVersion) {
            this.osVersion = osVersion;
            this.sdkVersion = sdkVersion;
        }

        public String getOsVersion() {
            return this.osVersion;
        }

        public int getSdkVersion() {
            return this.sdkVersion;
        }
    }
}

