/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.statistics;

import com.sedmelluq.discord.lavaplayer.natives.statistics.CpuStatisticsLibrary;

public class CpuStatistics {
    private static final int TIMINGS_LENGTH = ((CpuStatisticsLibrary.Timings[])CpuStatisticsLibrary.Timings.class.getEnumConstants()).length;
    private final CpuStatisticsLibrary library = CpuStatisticsLibrary.getInstance();

    public Times getSystemTimes() {
        long[] values = new long[TIMINGS_LENGTH];
        this.library.getSystemTimes(values);
        return new Times(values[CpuStatisticsLibrary.Timings.SYSTEM_TOTAL.id()], values[CpuStatisticsLibrary.Timings.SYSTEM_USER.id()], values[CpuStatisticsLibrary.Timings.SYSTEM_KERNEL.id()], values[CpuStatisticsLibrary.Timings.PROCESS_USER.id()], values[CpuStatisticsLibrary.Timings.PROCESS_KERNEL.id()]);
    }

    public static Times diff(Times old, Times current) {
        return new Times(current.systemTotal - old.systemTotal, current.systemUser - old.systemUser, current.systemKernel - old.systemKernel, current.processUser - old.processUser, current.processKernel - old.processKernel);
    }

    public static class Times {
        public final long systemTotal;
        public final long systemUser;
        public final long systemKernel;
        public final long processUser;
        public final long processKernel;

        public Times(long systemTotal, long systemUser, long systemKernel, long processUser, long processKernel) {
            this.systemTotal = systemTotal;
            this.systemUser = systemUser;
            this.systemKernel = systemKernel;
            this.processUser = processUser;
            this.processKernel = processKernel;
        }

        public float getSystemUsage() {
            if (this.systemTotal == 0L) {
                return 0.0f;
            }
            return (float)(this.systemUser + this.systemKernel) / (float)this.systemTotal;
        }

        public float getProcessUsage() {
            if (this.systemTotal == 0L) {
                return 0.0f;
            }
            return (float)(this.processUser + this.processKernel) / (float)this.systemTotal;
        }
    }
}

