/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.Webhook;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.WebhookMessageEditMonoGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="WebhookMessageEditMonoGenerator", generator="Immutables")
public final class WebhookMessageEditMono
extends WebhookMessageEditMonoGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final List<EmbedCreateSpec> embeds;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private final Snowflake messageId;
    private final Webhook webhook;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private WebhookMessageEditMono(Snowflake messageId, Webhook webhook) {
        this.messageId = Objects.requireNonNull(messageId, "messageId");
        this.webhook = Objects.requireNonNull(webhook, "webhook");
        Possible content$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private WebhookMessageEditMono(Possible<Optional<String>> content, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, List<EmbedCreateSpec> embeds, Possible<Optional<AllowedMentions>> allowedMentions, Possible<List<LayoutComponent>> components, Snowflake messageId, Webhook webhook) {
        Possible content$impl = content;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        this.initShim.embeds(embeds);
        Possible allowedMentions$impl = allowedMentions;
        Possible<List<LayoutComponent>> components$impl = components;
        this.messageId = messageId;
        this.webhook = webhook;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    @Override
    public Possible<Optional<String>> content() {
        return this.content_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.content_value));
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public List<EmbedCreateSpec> embeds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeds() : this.embeds;
    }

    @Override
    public Possible<Optional<AllowedMentions>> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.allowedMentions_value));
    }

    @Override
    public Possible<List<LayoutComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    public Snowflake messageId() {
        return this.messageId;
    }

    @Override
    public Webhook webhook() {
        return this.webhook;
    }

    public WebhookMessageEditMono withContent(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new WebhookMessageEditMono(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    @Deprecated
    public WebhookMessageEditMono withContent(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new WebhookMessageEditMono(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    public WebhookMessageEditMono withContentOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new WebhookMessageEditMono(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    public final WebhookMessageEditMono withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(Arrays.asList(elements), true, false));
        return new WebhookMessageEditMono(this.content(), newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    public final WebhookMessageEditMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(elements, true, false));
        return new WebhookMessageEditMono(this.content(), newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    public final WebhookMessageEditMono withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(Arrays.asList(elements), true, false));
        return new WebhookMessageEditMono(this.content(), this.files, newValue, this.embeds, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    public final WebhookMessageEditMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(elements, true, false));
        return new WebhookMessageEditMono(this.content(), this.files, newValue, this.embeds, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    public final WebhookMessageEditMono withEmbeds(EmbedCreateSpec ... elements) {
        List<EmbedCreateSpec> newValue = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(Arrays.asList(elements), true, false));
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    public final WebhookMessageEditMono withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
        if (this.embeds == elements) {
            return this;
        }
        List<EmbedCreateSpec> newValue = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(elements, true, false));
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components(), this.messageId, this.webhook);
    }

    public WebhookMessageEditMono withAllowedMentions(Possible<Optional<AllowedMentions>> value) {
        Possible<Optional<AllowedMentions>> newValue = Objects.requireNonNull(value);
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components(), this.messageId, this.webhook);
    }

    @Deprecated
    public WebhookMessageEditMono withAllowedMentions(@Nullable AllowedMentions value) {
        Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components(), this.messageId, this.webhook);
    }

    public WebhookMessageEditMono withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
        Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components(), this.messageId, this.webhook);
    }

    public WebhookMessageEditMono withComponents(Possible<List<LayoutComponent>> possible) {
        Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue, this.messageId, this.webhook);
    }

    public WebhookMessageEditMono withComponents(Iterable<LayoutComponent> elements) {
        Possible<List<LayoutComponent>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue, this.messageId, this.webhook);
    }

    @SafeVarargs
    public final WebhookMessageEditMono withComponents(LayoutComponent ... elements) {
        Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue, this.messageId, this.webhook);
    }

    public final WebhookMessageEditMono withMessageId(Snowflake value) {
        if (this.messageId == value) {
            return this;
        }
        Snowflake newValue = Objects.requireNonNull(value, "messageId");
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), newValue, this.webhook);
    }

    public final WebhookMessageEditMono withWebhook(Webhook value) {
        if (this.webhook == value) {
            return this;
        }
        Webhook newValue = Objects.requireNonNull(value, "webhook");
        return new WebhookMessageEditMono(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.messageId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookMessageEditMono && this.equalTo(0, (WebhookMessageEditMono)another);
    }

    private boolean equalTo(int synthetic, WebhookMessageEditMono another) {
        return this.content().equals(another.content()) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.embeds.equals(another.embeds) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value) && this.messageId.equals(another.messageId) && this.webhook.equals(another.webhook);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.content().hashCode();
        h2 += (h2 << 5) + this.files.hashCode();
        h2 += (h2 << 5) + this.fileSpoilers.hashCode();
        h2 += (h2 << 5) + this.embeds.hashCode();
        h2 += (h2 << 5) + this.allowedMentions().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.components_value);
        h2 += (h2 << 5) + this.messageId.hashCode();
        h2 += (h2 << 5) + this.webhook.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "WebhookMessageEditMono{content=" + this.content().toString() + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", embeds=" + this.embeds + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + ", messageId=" + this.messageId + ", webhook=" + this.webhook + "}";
    }

    public static WebhookMessageEditMono of(Snowflake messageId, Webhook webhook) {
        return new WebhookMessageEditMono(messageId, webhook);
    }

    static WebhookMessageEditMono copyOf(WebhookMessageEditMonoGenerator instance) {
        if (instance instanceof WebhookMessageEditMono) {
            return (WebhookMessageEditMono)instance;
        }
        return WebhookMessageEditMono.of(instance.messageId(), instance.webhook()).withContent(instance.content()).withFiles(instance.files()).withFileSpoilers(instance.fileSpoilers()).withEmbeds(instance.embeds()).withAllowedMentions(instance.allowedMentions()).withComponents(instance.components());
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WebhookMessageEditMonoGenerator", generator="Immutables")
    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;
        private byte embedsBuildStage = 0;
        private List<EmbedCreateSpec> embeds;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(WebhookMessageEditMono.super.files(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(WebhookMessageEditMono.super.fileSpoilers(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        List<EmbedCreateSpec> embeds() {
            if (this.embedsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embedsBuildStage == 0) {
                this.embedsBuildStage = (byte)-1;
                this.embeds = WebhookMessageEditMono.createUnmodifiableList(false, WebhookMessageEditMono.createSafeList(WebhookMessageEditMono.super.embeds(), true, false));
                this.embedsBuildStage = 1;
            }
            return this.embeds;
        }

        void embeds(List<EmbedCreateSpec> embeds) {
            this.embeds = embeds;
            this.embedsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            if (this.embedsBuildStage == -1) {
                attributes.add("embeds");
            }
            return "Cannot build WebhookMessageEditMono, attribute initializers form cycle " + attributes;
        }
    }
}

