/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.GuildCreateFromTemplateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="GuildCreateFromTemplateSpecGenerator", generator="Immutables")
public final class GuildCreateFromTemplateSpec
implements GuildCreateFromTemplateSpecGenerator {
    private final String name;
    private final Image icon_value;
    private final boolean icon_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private GuildCreateFromTemplateSpec(String name) {
        this.name = Objects.requireNonNull(name, "name");
        Possible icon$impl = Possible.absent();
        this.icon_value = icon$impl.toOptional().orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.initShim = null;
    }

    private GuildCreateFromTemplateSpec(String name, Possible<Image> icon) {
        this.name = name;
        Possible<Image> icon$impl = icon;
        this.icon_value = icon$impl.toOptional().orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Image> icon() {
        return this.icon_absent ? Possible.absent() : Possible.of(this.icon_value);
    }

    public final GuildCreateFromTemplateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildCreateFromTemplateSpec(newValue, this.icon());
    }

    public GuildCreateFromTemplateSpec withIcon(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return new GuildCreateFromTemplateSpec(this.name, newValue);
    }

    public GuildCreateFromTemplateSpec withIcon(Image value) {
        Possible<Image> newValue = Possible.of(value);
        return new GuildCreateFromTemplateSpec(this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildCreateFromTemplateSpec && this.equalTo(0, (GuildCreateFromTemplateSpec)another);
    }

    private boolean equalTo(int synthetic, GuildCreateFromTemplateSpec another) {
        return this.name.equals(another.name) && this.icon().equals(another.icon());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.icon().hashCode();
        return h2;
    }

    public String toString() {
        return "GuildCreateFromTemplateSpec{name=" + this.name + ", icon=" + this.icon().toString() + "}";
    }

    public static GuildCreateFromTemplateSpec of(String name) {
        return new GuildCreateFromTemplateSpec(name);
    }

    static GuildCreateFromTemplateSpec copyOf(GuildCreateFromTemplateSpecGenerator instance) {
        if (instance instanceof GuildCreateFromTemplateSpec) {
            return (GuildCreateFromTemplateSpec)instance;
        }
        return GuildCreateFromTemplateSpec.builder().from(instance).build();
    }

    public boolean isIconPresent() {
        return !this.icon_absent;
    }

    public Image iconOrElse(Image defaultValue) {
        return !this.icon_absent ? this.icon_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GuildCreateFromTemplateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<Image> icon_possible = Possible.absent();
        private String name;

        private Builder() {
        }

        public final Builder from(GuildCreateFromTemplateSpec instance) {
            return this.from((GuildCreateFromTemplateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GuildCreateFromTemplateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.icon(instance.icon());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder icon(Possible<Image> value) {
            this.icon_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder icon(Image value) {
            this.icon_possible = Possible.of(value);
            return this;
        }

        public GuildCreateFromTemplateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GuildCreateFromTemplateSpec(this.name, this.icon_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build GuildCreateFromTemplateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<Image> icon_build() {
            return this.icon_possible;
        }
    }

    @Generated(from="GuildCreateFromTemplateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildCreateFromTemplateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

