/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command;

import com.gmail.berndivader.streamserver.YAMPB;
import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.discord.DiscordBot;
import com.gmail.berndivader.streamserver.discord.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public final class Commands {
    public static Commands instance;
    private static final String PACKAGE_NAME = "com/gmail/berndivader/streamserver/discord/command/commands";
    private static String fileName;
    public HashMap<String, String> cmds = new HashMap();

    public Commands() {
        try {
            this.loadCommandClasses();
        }
        catch (Exception e) {
            ANSI.error("Failed to instantiate console commands.", e);
        }
    }

    private void loadCommandClasses() throws IOException, ClassNotFoundException {
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(fileName));){
            while (jarStream.available() == 1) {
                Class<?> clazz;
                DiscordCommand anno;
                String clazzName;
                JarEntry entry = jarStream.getNextJarEntry();
                if (entry == null || !(clazzName = entry.getName()).endsWith(".class") || !clazzName.startsWith(PACKAGE_NAME) || (anno = (clazz = Class.forName(clazzName = clazzName.substring(0, clazzName.length() - 6).replace("/", "."))).getAnnotation(DiscordCommand.class)) == null) continue;
                boolean add = true;
                block11: for (int i = 0; i < anno.requireds().length; ++i) {
                    switch (anno.requireds()[i]) {
                        case BROADCASTRUNNER: {
                            add &= BroadcastRunner.instance != null;
                            continue block11;
                        }
                        case DISCORDBOT: {
                            add &= DiscordBot.instance != null;
                            continue block11;
                        }
                        case DATABASE: {
                            add &= DatabaseConnection.status == DatabaseConnection.STATUS.OK;
                            continue block11;
                        }
                        default: {
                            add = true;
                        }
                    }
                }
                if (!add) continue;
                this.cmds.put(anno.name(), clazzName);
            }
        }
    }

    public Optional<Command<?>> build(String name) {
        if (name.isEmpty()) {
            name = "help";
        }
        if (this.cmds.containsKey(name)) {
            String clazzName = this.cmds.get(name);
            try {
                Class<?> clazz = Class.forName(clazzName);
                if (clazz != null) {
                    return Optional.of((Command)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (Exception e) {
                ANSI.error("Error while collect discord commands.", e);
            }
        }
        return Optional.empty();
    }

    static {
        try {
            fileName = URLDecoder.decode(YAMPB.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            try {
                fileName = URLDecoder.decode(YAMPB.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.ISO_8859_1.toString());
            }
            catch (UnsupportedEncodingException e1) {
                ANSI.error("Error, there is no UTF-8 nor a ISO-8859 encoding avaible.", e1);
            }
        }
    }
}

