/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import com.sedmelluq.discord.lavaplayer.filter.AudioPostProcessor;
import com.sedmelluq.discord.lavaplayer.filter.BufferingPostProcessor;
import com.sedmelluq.discord.lavaplayer.filter.ChannelCountPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.FilterChainBuilder;
import com.sedmelluq.discord.lavaplayer.filter.FinalPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import com.sedmelluq.discord.lavaplayer.filter.ResamplingPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.UserProvidedAudioFilters;
import com.sedmelluq.discord.lavaplayer.filter.volume.VolumePostProcessor;
import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.util.Arrays;
import java.util.Collection;

public class AudioPipelineFactory {
    public static boolean isProcessingRequired(AudioProcessingContext context, AudioDataFormat inputFormat) {
        return !context.outputFormat.equals(inputFormat) || context.playerOptions.volumeLevel.get() != 100 || context.playerOptions.filterFactory.get() != null;
    }

    public static AudioPipeline create(AudioProcessingContext context, PcmFormat inputFormat) {
        int inputChannels = inputFormat.channelCount;
        int outputChannels = context.outputFormat.channelCount;
        FinalPcmAudioFilter end = new FinalPcmAudioFilter(context, AudioPipelineFactory.createPostProcessors(context));
        FilterChainBuilder builder = new FilterChainBuilder();
        builder.addFirst(end);
        if (context.filterHotSwapEnabled || context.playerOptions.filterFactory.get() != null) {
            UserProvidedAudioFilters userFilters = new UserProvidedAudioFilters(context, end);
            builder.addFirst(userFilters);
        }
        if (inputFormat.sampleRate != context.outputFormat.sampleRate) {
            builder.addFirst(new ResamplingPcmAudioFilter(context.configuration, outputChannels, builder.makeFirstFloat(outputChannels), inputFormat.sampleRate, context.outputFormat.sampleRate));
        }
        if (inputChannels != outputChannels) {
            builder.addFirst(new ChannelCountPcmAudioFilter(inputChannels, outputChannels, builder.makeFirstUniversal(outputChannels)));
        }
        return new AudioPipeline(builder.build(null, inputChannels));
    }

    private static Collection<AudioPostProcessor> createPostProcessors(AudioProcessingContext context) {
        AudioChunkEncoder chunkEncoder = context.outputFormat.createEncoder(context.configuration);
        return Arrays.asList(new VolumePostProcessor(context), new BufferingPostProcessor(context, chunkEncoder));
    }
}

