/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeCipherOperation;
import java.util.ArrayList;
import java.util.List;

public class YoutubeSignatureCipher {
    private final List<YoutubeCipherOperation> operations = new ArrayList<YoutubeCipherOperation>();

    public String apply(String text) {
        StringBuilder builder = new StringBuilder(text);
        block5: for (YoutubeCipherOperation operation : this.operations) {
            switch (operation.type) {
                case SWAP: {
                    int position = operation.parameter % text.length();
                    char temp = builder.charAt(0);
                    builder.setCharAt(0, builder.charAt(position));
                    builder.setCharAt(position, temp);
                    continue block5;
                }
                case REVERSE: {
                    builder.reverse();
                    continue block5;
                }
                case SLICE: 
                case SPLICE: {
                    builder.delete(0, operation.parameter);
                    continue block5;
                }
            }
            throw new IllegalStateException("All branches should be covered");
        }
        return builder.toString();
    }

    public void addOperation(YoutubeCipherOperation operation) {
        this.operations.add(operation);
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }
}

