/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.config;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.YAMPB;
import com.gmail.berndivader.streamserver.config.Broadcaster;
import com.gmail.berndivader.streamserver.config.Data;
import com.gmail.berndivader.streamserver.config.Discord;
import com.gmail.berndivader.streamserver.config.Downloader;
import com.gmail.berndivader.streamserver.config.MySql;
import com.gmail.berndivader.streamserver.config.WebSocket;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.gmail.berndivader.streamserver.youtube.PrivacyStatus;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.Scanner;

public class Config {
    public static String HELP_TEXT;
    public static String DISCORD_HELP_TEXT;
    public static String DISCORD_HELP_TEXT_TITLE;
    public static String YAMPB_ANSI;
    public static Broadcaster BROADCASTER;
    public static String DATABASE_PREFIX;
    public static MySql MYSQL;
    public static Downloader DOWNLOADER;
    public static Discord DISCORD;
    public static WebSocket WEBSOCKET;
    public static Boolean DEBUG;
    public static String working_dir;
    public static File config_dir;
    public static File config_file;
    public static Data data;
    public static Config instance;
    public static boolean FRESH_INSTALL;
    public static boolean YTDLP_AVAIL;
    public static boolean FFMPEG_AVAIL;

    public Config() {
        ANSI.println("[CYAN]Loading config...");
        if (Config.loadConfig()) {
            ANSI.println("[GREEN]DONE![/GREEN]");
            Config.saveConfig();
        } else {
            ANSI.warn("Failed loading or creating config file. Using default values.");
        }
    }

    private static void createDefault() {
        config_dir.mkdir();
        data = new Data();
        Config.saveConfig();
    }

    public static boolean saveConfig() {
        try (FileWriter writer = new FileWriter(config_file.getAbsoluteFile());){
            Field[] fields;
            for (Field field : fields = Data.class.getDeclaredFields()) {
                try {
                    Field config = Config.class.getField(field.getName());
                    field.set(data, config.get(null));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    ANSI.error(e.getMessage(), e);
                }
            }
            Helper.GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            ANSI.error("Error while saving config file.", e);
            return false;
        }
        return true;
    }

    public static boolean loadConfig() {
        try (FileReader reader = new FileReader(config_file.getAbsoluteFile());){
            Field[] fields;
            data = Helper.GSON.fromJson((Reader)reader, Data.class);
            for (Field field : fields = Data.class.getDeclaredFields()) {
                try {
                    Object value = field.get(data);
                    if (value == null) continue;
                    Field staticField = Config.class.getField(field.getName());
                    staticField.set(null, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    ANSI.error(e.getMessage(), e);
                }
            }
        }
        catch (IOException e) {
            ANSI.error("Error while loading config file.", e);
            return false;
        }
        return true;
    }

    public static String musicPath() {
        return Config.DOWNLOADER.ROOT_PATH + Config.DOWNLOADER.MUSIC_PATH;
    }

    public static String mediaPath() {
        return Config.DOWNLOADER.ROOT_PATH + Config.DOWNLOADER.MEDIA_PATH;
    }

    public static String tempPath() {
        return Config.DOWNLOADER.ROOT_PATH + Config.DOWNLOADER.TEMP_PATH;
    }

    public static String connectionString() {
        return DATABASE_PREFIX + Config.MYSQL.HOST + ":" + Config.MYSQL.PORT + "/" + Config.MYSQL.NAME;
    }

    public static PrivacyStatus broadcastPrivacyStatus() {
        String priv = Config.BROADCASTER.BROADCAST_DEFAULT_PRIVACY.toUpperCase();
        return PrivacyStatus.isEnum(priv) ? PrivacyStatus.valueOf(priv) : PrivacyStatus.UNLISTED;
    }

    private static String inputstreamToString(InputStream is) {
        String output = null;
        try (Scanner s2 = new Scanner(is);){
            s2.useDelimiter("\\A");
            output = s2.hasNext() ? s2.next() : "";
            try {
                is.close();
            }
            catch (IOException e1) {
                ANSI.error("Error while reading from an InputStream", e1);
            }
        }
        return output;
    }

    public static boolean cookiesExists() {
        return Config.getCookies().exists();
    }

    public static File getCookies() {
        return new File(config_dir, "cookies.txt");
    }

    public static boolean torAccessible() {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(Config.DOWNLOADER.TOR_HOST, (int)Config.DOWNLOADER.TOR_PORT), 0);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        DISCORD_HELP_TEXT_TITLE = "YAMPB Discord help";
        BROADCASTER = new Broadcaster();
        DATABASE_PREFIX = "jdbc:mysql://";
        MYSQL = new MySql();
        DOWNLOADER = new Downloader();
        DISCORD = new Discord();
        WEBSOCKET = new WebSocket();
        DEBUG = false;
        FRESH_INSTALL = false;
        YTDLP_AVAIL = Helper.ytdlpAvail();
        FFMPEG_AVAIL = Helper.ffmpegAvail();
        try {
            HELP_TEXT = Config.inputstreamToString(YAMPB.class.getResourceAsStream("/help.txt"));
            DISCORD_HELP_TEXT = Config.inputstreamToString(YAMPB.class.getResourceAsStream("/discord_help.txt"));
            YAMPB_ANSI = Config.inputstreamToString(YAMPB.class.getResourceAsStream("/yampb.ansi"));
            working_dir = new File(YAMPB.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (URISyntaxException ex) {
            ANSI.error("URISyntaxException", ex);
        }
        config_dir = new File(working_dir, "config");
        config_file = new File(config_dir, "config.json");
        if (!config_dir.exists()) {
            FRESH_INSTALL = true;
            config_dir.mkdir();
            Config.createDefault();
        }
        if (!config_file.exists()) {
            FRESH_INSTALL = true;
            Config.createDefault();
        }
    }
}

