/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.youtube;

import com.gmail.berndivader.streamserver.config.Broadcaster;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.mysql.VerifyOAuth2;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.gmail.berndivader.streamserver.youtube.Youtube;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.AbstractMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public final class OAuth2 {
    private static final String OAUTH_URL = "https://accounts.google.com/o/oauth2/v2/auth?client_id=%s&redirect_uri=%s&response_type=code&scope=https://www.googleapis.com/auth/youtube&state=%s&access_type=offline&prompt=consent";
    private static final String OAUTH_API = "https://oauth2.googleapis.com/token";

    private OAuth2() {
    }

    public static boolean build() {
        String state = UUID.randomUUID().toString();
        ANSI.println("Visit the URL and authorize the bot:[BR][GREEN]".concat(String.format(OAUTH_URL, Config.BROADCASTER.YOUTUBE_CLIENT_ID, Config.BROADCASTER.YOUTUBE_AUTH_REDIRECT, state)));
        ANSI.print("[YELLOW]Enter the retrieved code: [CYAN]");
        try {
            String code = ANSI.keyboard.nextLine();
            ANSI.print("[RESET][YELLOW]Try to authorisize your request...");
            VerifyOAuth2 verify = new VerifyOAuth2(code, state);
            try {
                if (!verify.future.get(10L, TimeUnit.SECONDS).booleanValue()) {
                    throw new RuntimeException("Failed to verify OAuth2 request.");
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new Exception("Failed to verify OAuth2 request.", e);
            }
            HttpPost post = new HttpPost(OAUTH_API);
            StringEntity parameter = new StringEntity(String.format("code=%s&client_id=%s&client_secret=%s&redirect_uri=%s&grant_type=authorization_code", code, Config.BROADCASTER.YOUTUBE_CLIENT_ID, Config.BROADCASTER.YOUTUBE_CLIENT_SECRET, Config.BROADCASTER.YOUTUBE_AUTH_REDIRECT));
            post.setEntity(parameter);
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            Map.Entry pair = Youtube.HTTP_CLIENT.execute((HttpUriRequest)post, response -> {
                String accessToken = "";
                String refreshToken = "";
                JsonObject json = JsonParser.parseString(EntityUtils.toString(response.getEntity())).getAsJsonObject();
                if (json.has("refresh_token")) {
                    refreshToken = json.get("refresh_token").getAsString();
                }
                if (json.has("access_token")) {
                    accessToken = json.get("access_token").getAsString();
                }
                if (json.has("error")) {
                    ANSI.println("[RED]failed!");
                    ANSI.error(json.get("error").getAsString() + " Reason: " + json.get("error_description").getAsString(), new RuntimeException("OAuth2 registration failed."));
                }
                return new AbstractMap.SimpleEntry<String, String>(accessToken, refreshToken);
            });
            String token = (String)pair.getKey();
            String refreshToken = (String)pair.getValue();
            if (token.isEmpty()) {
                throw new Exception("Failed to receive token.");
            }
            if (refreshToken.isEmpty()) {
                throw new Exception("Failed to receive refresh token.");
            }
            Config.BROADCASTER.YOUTUBE_ACCESS_TOKEN = token;
            Config.BROADCASTER.YOUTUBE_REFRESH_TOKEN = refreshToken;
            Config.BROADCASTER.YOUTUBE_TOKEN_TIMESTAMP = System.currentTimeMillis() / 1000L;
            Config.saveConfig();
            ANSI.println("[GREEN]done![RESET]");
        }
        catch (Exception e) {
            ANSI.error(e.getMessage(), e);
            return false;
        }
        return true;
    }

    public static boolean refresh() {
        ANSI.print("[WHITE]Try to refresh access token...");
        HttpPost post = new HttpPost(OAUTH_API);
        try {
            StringEntity parameter = new StringEntity(String.format("grant_type=refresh_token&client_id=%s&client_secret=%s&refresh_token=%s", Config.BROADCASTER.YOUTUBE_CLIENT_ID, Config.BROADCASTER.YOUTUBE_CLIENT_SECRET, Config.BROADCASTER.YOUTUBE_REFRESH_TOKEN));
            post.setEntity(parameter);
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            String token = Youtube.HTTP_CLIENT.execute((HttpUriRequest)post, response -> {
                JsonObject json = JsonParser.parseString(EntityUtils.toString(response.getEntity())).getAsJsonObject();
                if (json.has("access_token")) {
                    return json.get("access_token").getAsString();
                }
                return "";
            });
            if (token.isEmpty()) {
                throw new RuntimeException("Failed to refresh access token.");
            }
            Config.BROADCASTER.YOUTUBE_ACCESS_TOKEN = token;
            Config.BROADCASTER.YOUTUBE_TOKEN_TIMESTAMP = System.currentTimeMillis() / 1000L;
            Config.saveConfig();
            ANSI.println("[GREEN]done![/GREEN] Renewed the refresh token for YouTube.[PROMPT]");
            return true;
        }
        catch (Exception e) {
            ANSI.println("[RED]failed![RESET]");
            ANSI.error(e.getMessage(), e);
            return false;
        }
    }

    public static boolean isExpired() {
        return System.currentTimeMillis() / 1000L - Config.BROADCASTER.YOUTUBE_TOKEN_TIMESTAMP > Broadcaster.YOUTUBE_TOKEN_EXPIRE_TIME;
    }
}

