/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.guild;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.guild.GuildEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.gateway.ShardInfo;
import reactor.core.publisher.Mono;

public class MemberJoinEvent
extends GuildEvent {
    private final Member member;
    private final long guildId;

    public MemberJoinEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Member member, long guildId) {
        super(gateway, shardInfo);
        this.member = member;
        this.guildId = guildId;
    }

    public Member getMember() {
        return this.member;
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public String toString() {
        return "MemberJoinEvent{member=" + this.member + ", guildId=" + this.guildId + '}';
    }
}

