/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.ApplicationTeam;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.util.EntityUtil;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.json.ApplicationInfoData;
import discord4j.discordjson.json.ApplicationTeamData;
import discord4j.rest.util.Image;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class ApplicationInfo
implements Entity {
    private static final String ICON_IMAGE_PATH = "app-icons/%s/%s";
    private final GatewayDiscordClient gateway;
    private final ApplicationInfoData data;

    public ApplicationInfo(GatewayDiscordClient gateway, ApplicationInfoData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public ApplicationInfoData getData() {
        return this.data;
    }

    public String getName() {
        return this.data.name();
    }

    public Optional<String> getIconUrl(Image.Format format) {
        return this.data.icon().map(icon -> ImageUtil.getUrl(String.format(ICON_IMAGE_PATH, this.getId().asString(), icon), format));
    }

    public Mono<Image> getIcon(Image.Format format) {
        return Mono.justOrEmpty(this.getIconUrl(format)).flatMap(Image::ofUrl);
    }

    public String getDescription() {
        return this.data.description();
    }

    public boolean isPublic() {
        return this.data.botPublic();
    }

    public boolean requireCodeGrant() {
        return this.data.botRequireCodeGrant();
    }

    public Optional<String> getTermsOfServiceUrl() {
        return this.data.termsOfServiceUrl().toOptional();
    }

    public Optional<String> getPrivacyPolicyUrl() {
        return this.data.privacyPolicyUrl().toOptional();
    }

    public Snowflake getOwnerId() {
        return Snowflake.of(this.data.owner().id());
    }

    public Mono<User> getOwner() {
        return this.gateway.getUserById(this.getOwnerId());
    }

    public Mono<User> getOwner(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getUserById(this.getOwnerId());
    }

    public Optional<ApplicationTeam> getTeam() {
        return this.data.team().map(data -> new ApplicationTeam(this.gateway, (ApplicationTeamData)data));
    }

    public EnumSet<Flag> getFlags() {
        int publicFlags = this.data.flags().toOptional().orElse(0);
        if (publicFlags != 0) {
            return Flag.of(publicFlags);
        }
        return EnumSet.noneOf(Flag.class);
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "ApplicationInfo{data=" + this.data + '}';
    }

    public static enum Flag {
        APPLICATION_AUTO_MODERATION_RULE_CREATE_BADGE(6),
        GATEWAY_PRESENCE(12),
        GATEWAY_PRESENCE_LIMITED(13),
        GATEWAY_GUILD_MEMBERS(14),
        GATEWAY_GUILD_MEMBERS_LIMITED(15),
        VERIFICATION_PENDING_GUILD_LIMIT(16),
        EMBEDDED(17),
        GATEWAY_MESSAGE_CONTENT(18),
        GATEWAY_MESSAGE_CONTENT_LIMITED(19),
        APPLICATION_COMMAND_BADGE(23);

        private final int value;
        private final int flag;

        private Flag(int value) {
            this.value = value;
            this.flag = 1 << value;
        }

        public int getValue() {
            return this.value;
        }

        public int getFlag() {
            return this.flag;
        }

        public static EnumSet<Flag> of(int value) {
            EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                long flagValue = flag.getFlag();
                if ((flagValue & (long)value) != flagValue) continue;
                flagSet.add(flag);
            }
            return flagSet;
        }
    }
}

