/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.WebhookCreateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="WebhookCreateRequest", generator="Immutables")
public final class ImmutableWebhookCreateRequest
implements WebhookCreateRequest {
    private final String name;
    private final String avatar_value;
    private final boolean avatar_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWebhookCreateRequest(String name, Possible<Optional<String>> avatar) {
        this.name = Objects.requireNonNull(name, "name");
        Possible avatar$impl = avatar;
        this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableWebhookCreateRequest(ImmutableWebhookCreateRequest original, String name, Possible<Optional<String>> avatar) {
        this.name = name;
        Possible avatar$impl = avatar;
        this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="avatar")
    public Possible<Optional<String>> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.avatar_value));
    }

    public final ImmutableWebhookCreateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableWebhookCreateRequest(this, newValue, this.avatar());
    }

    public ImmutableWebhookCreateRequest withAvatar(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookCreateRequest(this, this.name, newValue);
    }

    @Deprecated
    public ImmutableWebhookCreateRequest withAvatar(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookCreateRequest(this, this.name, newValue);
    }

    public ImmutableWebhookCreateRequest withAvatarOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookCreateRequest(this, this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookCreateRequest && this.equalTo(0, (ImmutableWebhookCreateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebhookCreateRequest another) {
        return this.name.equals(another.name) && this.avatar().equals(another.avatar());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.avatar().hashCode();
        return h2;
    }

    public String toString() {
        return "WebhookCreateRequest{name=" + this.name + ", avatar=" + this.avatar().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhookCreateRequest fromJson(Json json) {
        Builder builder = ImmutableWebhookCreateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.avatar != null) {
            builder.avatar(json.avatar);
        }
        return builder.build();
    }

    public static ImmutableWebhookCreateRequest of(String name, Possible<Optional<String>> avatar) {
        return new ImmutableWebhookCreateRequest(name, avatar);
    }

    public static ImmutableWebhookCreateRequest copyOf(WebhookCreateRequest instance) {
        if (instance instanceof ImmutableWebhookCreateRequest) {
            return (ImmutableWebhookCreateRequest)instance;
        }
        return ImmutableWebhookCreateRequest.builder().from(instance).build();
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public String avatarOrElse(String defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebhookCreateRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<Optional<String>> avatar_possible = Possible.absent();
        private String name;

        private Builder() {
        }

        public final Builder from(WebhookCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.avatar(instance.avatar());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="avatar")
        public Builder avatar(Possible<Optional<String>> value) {
            this.avatar_possible = value;
            return this;
        }

        @Deprecated
        public Builder avatar(@Nullable String value) {
            this.avatar_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder avatarOrNull(@Nullable String value) {
            this.avatar_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableWebhookCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebhookCreateRequest(null, this.name, this.avatar_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build WebhookCreateRequest, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> avatar_build() {
            return this.avatar_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WebhookCreateRequest", generator="Immutables")
    static final class Json
    implements WebhookCreateRequest {
        String name;
        Possible<Optional<String>> avatar = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="avatar")
        public void setAvatar(Possible<Optional<String>> avatar) {
            this.avatar = avatar;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> avatar() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="WebhookCreateRequest", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookCreateRequest, attribute initializers form cycle " + attributes;
        }
    }
}

