/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.ToLongFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class PaginationUtil {
    public static <T> Flux<T> paginateAfter(Function<Map<String, Object>, Flux<T>> tProducer, ToLongFunction<T> keyExtractor, long startAt, int pageSize) {
        return PaginationUtil.paginateWithQueryParams(tProducer, keyExtractor, startAt, pageSize, "after", false);
    }

    public static <T> Flux<T> paginateBefore(Function<Map<String, Object>, Flux<T>> tProducer, ToLongFunction<T> keyExtractor, long startAt, int pageSize) {
        return PaginationUtil.paginateWithQueryParams(tProducer, keyExtractor, startAt, pageSize, "before", true);
    }

    private static <T> Flux<T> paginateWithQueryParams(Function<Map<String, Object>, Flux<T>> tProducer, ToLongFunction<T> keyExtractor, long startAt, int pageSize, String queryKey, boolean reverse) {
        LongFunction<Flux<T>> nextPage = id -> {
            HashMap<String, Number> parameters = new HashMap<String, Number>(2);
            parameters.put("limit", pageSize);
            parameters.put(queryKey, id);
            return (Flux)tProducer.apply(parameters);
        };
        return PaginationUtil.paginate(nextPage, keyExtractor, startAt, reverse);
    }

    private static <T> Flux<T> paginate(LongFunction<Flux<T>> nextPage, ToLongFunction<T> keyExtractor, long startAt, boolean reverse) {
        ToLongFunction<List> updateLast = list -> list.isEmpty() ? startAt : keyExtractor.applyAsLong(list.get(list.size() - 1));
        Comparator<T> comparator = Comparator.comparingLong(keyExtractor);
        AtomicLong previousStart = new AtomicLong(startAt);
        return Flux.defer(() -> (Publisher)nextPage.apply(previousStart.get())).sort(reverse ? comparator.reversed() : comparator).collectList().doOnNext(list -> previousStart.set(updateLast.applyAsLong((List)list))).flatMapMany(Flux::fromIterable).repeat(() -> previousStart.get() != startAt);
    }
}

