/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe.data;

import com.github.kokorin.jaffree.LogCategory;
import com.github.kokorin.jaffree.LogLevel;
import com.github.kokorin.jaffree.Rational;
import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffprobe.data.ProbeData;
import com.github.kokorin.jaffree.ffprobe.data.ProbeDataConverter;
import com.github.kokorin.jaffree.ffprobe.data.ValueConverter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProbeData
implements ProbeData {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProbeData.class);
    private static final ValueConverter<String> STRING_CONVERTER = new ValueConverter<String>(){

        @Override
        public String convert(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    };
    private static final ValueConverter<Boolean> BOOLEAN_CONVERTER = new ValueConverter<Boolean>(){

        @Override
        public Boolean convert(Object value) {
            if (value == null || value.equals("") || value.equals("N/A")) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() > 0;
            }
            try {
                return Integer.parseInt(value.toString()) > 0;
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse int number: {}", value);
                return null;
            }
        }
    };
    private static final ValueConverter<Long> LONG_CONVERTER = new ValueConverter<Long>(){

        @Override
        public Long convert(Object value) {
            if (value == null || value.equals("") || value.equals("N/A")) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            try {
                return Long.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse long number: {}", value);
                return null;
            }
        }
    };
    private static final ValueConverter<Integer> INTEGER_CONVERTER = new ValueConverter<Integer>(){

        @Override
        public Integer convert(Object value) {
            if (value == null || value.equals("") || value.equals("N/A")) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            try {
                return Integer.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse integer number: {}", value);
                return null;
            }
        }
    };
    private static final ValueConverter<Float> FLOAT_CONVERTER = new ValueConverter<Float>(){

        @Override
        public Float convert(Object value) {
            if (value == null || value.equals("") || value.equals("N/A")) {
                return null;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            try {
                return Float.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse float number: {}", value);
                return null;
            }
        }
    };
    private static final ValueConverter<Double> DOUBLE_CONVERTER = new ValueConverter<Double>(){

        @Override
        public Double convert(Object value) {
            if (value == null || value.equals("") || value.equals("N/A")) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            try {
                return Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse double number: {}", value);
                return null;
            }
        }
    };
    private static final ValueConverter<StreamType> STREAM_TYPE_CONVERTER = new ValueConverter<StreamType>(){

        @Override
        public StreamType convert(Object value) {
            if (value == null || value.equals("") || value.equals("N/A")) {
                return null;
            }
            try {
                return StreamType.valueOf(value.toString().toUpperCase());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse StreamType: {}", value);
                return null;
            }
        }
    };
    private static final ValueConverter<LogLevel> LOG_LEVEL_CONVERTER = new ValueConverter<LogLevel>(){

        @Override
        public LogLevel convert(Object value) {
            if (value == null || value.equals("") || value.equals("N/A")) {
                return null;
            }
            if (value instanceof String) {
                try {
                    return LogLevel.fromCode(Integer.parseInt((String)value));
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Failed to parse LogLevel: {}", value);
                }
            }
            if (value instanceof Number) {
                return LogLevel.fromCode(((Number)value).intValue());
            }
            return null;
        }
    };
    private static final ValueConverter<LogCategory> LOG_CATEGORY_CONVERTER = new ValueConverter<LogCategory>(){

        @Override
        public LogCategory convert(Object value) {
            if (value == null || value.equals("") || value.equals("N/A")) {
                return null;
            }
            if (value instanceof String) {
                try {
                    return LogCategory.fromCode(Integer.parseInt((String)value));
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Failed to parse LogCategory: {}", value);
                }
            }
            if (value instanceof Number) {
                return LogCategory.fromCode(((Number)value).intValue());
            }
            return null;
        }
    };
    private static final ValueConverter<Rational> RATIONAL_CONVERTER = new RationalConverter("/");
    private static final ValueConverter<Rational> RATIO_CONVERTER = new RationalConverter(":");

    @Override
    public String getString(String key) {
        return this.getValue(key, STRING_CONVERTER);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getValue(key, BOOLEAN_CONVERTER);
    }

    @Override
    public Long getLong(String key) {
        return this.getValue(key, LONG_CONVERTER);
    }

    @Override
    public Integer getInteger(String key) {
        return this.getValue(key, INTEGER_CONVERTER);
    }

    @Override
    public Float getFloat(String key) {
        return this.getValue(key, FLOAT_CONVERTER);
    }

    @Override
    public Double getDouble(String key) {
        return this.getValue(key, DOUBLE_CONVERTER);
    }

    @Override
    public StreamType getStreamType(String key) {
        return this.getValue(key, STREAM_TYPE_CONVERTER);
    }

    @Override
    public LogLevel getLogLevel(String key) {
        return this.getValue(key, LOG_LEVEL_CONVERTER);
    }

    @Override
    public LogCategory getLogCategory(String key) {
        return this.getValue(key, LOG_CATEGORY_CONVERTER);
    }

    @Override
    public Rational getRational(String key) {
        return this.getValue(key, RATIONAL_CONVERTER);
    }

    @Override
    public Rational getRatio(String key) {
        return this.getValue(key, RATIO_CONVERTER);
    }

    @Override
    public <T> T getValue(String name, ValueConverter<T> converter) {
        Object value = this.getValue(name);
        if (value == null) {
            return null;
        }
        return converter.convert(value);
    }

    @Override
    public final <T> T getSubData(String name, ProbeDataConverter<T> converter) {
        ProbeData data = this.getSubData(name);
        if (data == null) {
            return null;
        }
        return converter.convert(data);
    }

    @Override
    public final <T> List<T> getSubDataList(String name, ProbeDataConverter<T> converter) {
        List<ProbeData> dataList = this.getSubDataList(name);
        if (dataList == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(dataList.size());
        for (ProbeData data : dataList) {
            result.add(converter.convert(data));
        }
        return result;
    }

    @Override
    public Object getSubDataValue(String name, String property) {
        ProbeData subData = this.getSubData(name);
        if (subData == null) {
            return null;
        }
        return subData.getValue(property);
    }

    @Override
    public <T> T getSubDataValue(String name, String property, ValueConverter<T> converter) {
        Object value = this.getSubDataValue(name, property);
        if (value == null) {
            return null;
        }
        return converter.convert(value);
    }

    @Override
    public String getSubDataString(String name, String property) {
        return this.getSubDataValue(name, property, STRING_CONVERTER);
    }

    @Override
    public Long getSubDataLong(String name, String property) {
        return this.getSubDataValue(name, property, LONG_CONVERTER);
    }

    @Override
    public Integer getSubDataInteger(String name, String property) {
        return this.getSubDataValue(name, property, INTEGER_CONVERTER);
    }

    @Override
    public Double getSubDataDouble(String name, String property) {
        return this.getSubDataValue(name, property, DOUBLE_CONVERTER);
    }

    @Override
    public Float getSubDataFloat(String name, String property) {
        return this.getSubDataValue(name, property, FLOAT_CONVERTER);
    }

    private static class RationalConverter
    implements ValueConverter<Rational> {
        private final String delimiter;

        RationalConverter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public Rational convert(Object value) {
            if (value == null || value.equals("") || value.equals("0/0") || value.equals("N/A")) {
                return null;
            }
            if (value instanceof Number) {
                return Rational.valueOf((Number)value);
            }
            try {
                return Rational.valueOf(value.toString(), this.delimiter);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse rational number: " + value, e);
                return null;
            }
        }
    }
}

