/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

public class DetachedByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private boolean closed;

    public DetachedByteChannel(ReadableByteChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read(ByteBuffer output) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        return this.delegate.read(output);
    }

    @Override
    public boolean isOpen() {
        return !this.closed && this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

