/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.legacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

class ListUtil {
    ListUtil() {
    }

    public static <T> List<T> add(List<T> source, T element) {
        ArrayList<T> list = new ArrayList<T>(source);
        list.add(element);
        return Collections.unmodifiableList(list);
    }

    public static <T> Collection<T> addAllDistinct(List<T> source, List<T> elements) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(source);
        set.addAll(elements);
        return Collections.unmodifiableCollection(set);
    }

    public static <T> List<T> remove(List<T> source, Predicate<T> filter) {
        if (source.isEmpty()) {
            return source;
        }
        ArrayList<T> list = new ArrayList<T>(source);
        list.removeIf(filter);
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> replace(List<T> source, T old, T replacement) {
        ArrayList<T> list = new ArrayList<T>(source);
        for (int i = 0; i < list.size(); ++i) {
            if (!Objects.equals(list.get(i), old)) continue;
            list.set(i, replacement);
        }
        return Collections.unmodifiableList(list);
    }
}

