/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.channel.PrivateChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.util.EntityUtil;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.json.DMCreateRequest;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.Image;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class User
implements Entity {
    private static final String DEFAULT_IMAGE_PATH = "embed/avatars/%d";
    private static final String AVATAR_IMAGE_PATH = "avatars/%s/%s";
    private static final String BANNER_IMAGE_PATH = "banners/%s/%s";
    private final GatewayDiscordClient gateway;
    private final UserData data;

    public User(GatewayDiscordClient gateway, UserData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public final GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public UserData getUserData() {
        return this.data;
    }

    public final Optional<String> getGlobalName() {
        return this.data.globalName();
    }

    public final String getUsername() {
        return this.data.username();
    }

    @Deprecated
    @Nullable
    public final String getDiscriminator() {
        return this.data.discriminator();
    }

    private boolean isMigrated() {
        return this.getDiscriminator() == null || this.getDiscriminator().equals("0");
    }

    public final String getTag() {
        if (this.isMigrated()) {
            return this.getUsername();
        }
        return this.getUsername() + "#" + this.getDiscriminator();
    }

    public final boolean hasAnimatedAvatar() {
        String avatar = this.data.avatar().orElse(null);
        return avatar != null && avatar.startsWith("a_");
    }

    public final Optional<String> getAvatarUrl(Image.Format format) {
        return this.data.avatar().map(avatar -> ImageUtil.getUrl(String.format(AVATAR_IMAGE_PATH, this.getId().asString(), avatar), format));
    }

    public final String getAvatarUrl() {
        boolean animated = this.hasAnimatedAvatar();
        return this.getAvatarUrl(animated ? Image.Format.GIF : Image.Format.PNG).orElse(this.getDefaultAvatarUrl());
    }

    public Mono<Image> getAvatar(Image.Format format) {
        return Mono.justOrEmpty(this.getAvatarUrl(format)).flatMap(Image::ofUrl);
    }

    public final Mono<Image> getAvatar() {
        return Image.ofUrl(this.getAvatarUrl());
    }

    public final String getDefaultAvatarUrl() {
        if (this.isMigrated()) {
            return ImageUtil.getUrl(String.format(DEFAULT_IMAGE_PATH, (this.getId().asLong() >> 22) % 6L), Image.Format.PNG);
        }
        return ImageUtil.getUrl(String.format(DEFAULT_IMAGE_PATH, Integer.parseInt(this.getDiscriminator()) % 5), Image.Format.PNG);
    }

    public final boolean hasAnimatedBanner() {
        String banner = Possible.flatOpt(this.data.banner()).orElse(null);
        return banner != null && banner.startsWith("a_");
    }

    public final Optional<String> getBannerUrl(Image.Format format) {
        return Possible.flatOpt(this.data.banner()).map(banner -> ImageUtil.getUrl(String.format(BANNER_IMAGE_PATH, this.getId().asString(), banner), format));
    }

    public final Optional<String> getBannerUrl() {
        boolean animated = this.hasAnimatedBanner();
        return this.getBannerUrl(animated ? Image.Format.GIF : Image.Format.PNG);
    }

    public Mono<Image> getBanner(Image.Format format) {
        return Mono.justOrEmpty(this.getBannerUrl(format)).flatMap(Image::ofUrl);
    }

    public final Mono<Image> getBanner() {
        return Mono.justOrEmpty(this.getBannerUrl()).flatMap(Image::ofUrl);
    }

    public final Optional<Color> getAccentColor() {
        return Possible.flatOpt(this.data.accentColor()).map(Color::of);
    }

    public boolean isBot() {
        return this.data.bot().toOptional().orElse(false);
    }

    public final String getMention() {
        return "<@" + this.getId().asString() + ">";
    }

    @Override
    public final Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public Mono<Member> asMember(Snowflake guildId) {
        return this.gateway.getMemberById(guildId, this.getId());
    }

    public Mono<Member> asMember(Snowflake guildId, EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getMemberById(guildId, this.getId());
    }

    public final Mono<PrivateChannel> getPrivateChannel() {
        return this.gateway.getRestClient().getUserService().createDM(DMCreateRequest.builder().recipientId(Snowflake.asString(this.getId().asLong())).build()).map(data -> EntityUtil.getChannel(this.gateway, data)).cast(PrivateChannel.class);
    }

    public EnumSet<Flag> getPublicFlags() {
        long publicFlags = this.data.publicFlags().toOptional().orElse(0L);
        if (publicFlags != 0L) {
            return Flag.of(publicFlags);
        }
        return EnumSet.noneOf(Flag.class);
    }

    public final boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public final int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "User{data=" + this.data + '}';
    }

    public static enum Flag {
        DISCORD_EMPLOYEE(0),
        DISCORD_PARTNER(1),
        HYPESQUAD_EVENTS(2),
        BUG_HUNTER_LEVEL_1(3),
        HOUSE_BRAVERY(6),
        HOUSE_BRILLIANCE(7),
        HOUSE_BALANCE(8),
        EARLY_SUPPORTER(9),
        TEAM_USER(10),
        SYSTEM(12),
        BUG_HUNTER_LEVEL_2(14),
        VERIFIED_BOT(16),
        VERIFIED_BOT_DEVELOPER(17),
        DISCORD_CERTIFIED_MODERATOR(18),
        BOT_HTTP_INTERACTIONS(19),
        ACTIVE_DEVELOPER(22);

        private final int value;
        private final int flag;

        private Flag(int value) {
            this.value = value;
            this.flag = 1 << value;
        }

        public int getValue() {
            return this.value;
        }

        public int getFlag() {
            return this.flag;
        }

        public static EnumSet<Flag> of(long value) {
            EnumSet<Flag> userFlags = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                long flagValue = flag.getFlag();
                if ((flagValue & value) != flagValue) continue;
                userFlags.add(flag);
            }
            return userFlags;
        }
    }
}

