/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.EmbedCreateFields;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.EmbedImageData;
import discord4j.discordjson.json.EmbedThumbnailData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import reactor.util.annotation.Nullable;

@Value.Immutable(singleton=true)
interface EmbedCreateSpecGenerator
extends Spec<EmbedData> {
    public Possible<String> title();

    public Possible<String> description();

    public Possible<String> url();

    public Possible<Instant> timestamp();

    public Possible<Color> color();

    @Nullable
    public EmbedCreateFields.Footer footer();

    public Possible<String> image();

    public Possible<String> thumbnail();

    @Nullable
    public EmbedCreateFields.Author author();

    @Value.Default
    default public List<EmbedCreateFields.Field> fields() {
        return Collections.emptyList();
    }

    @Override
    default public EmbedData asRequest() {
        return EmbedData.builder().title(this.title()).description(this.description()).url(this.url()).timestamp(InternalSpecUtils.mapPossible(this.timestamp(), DateTimeFormatter.ISO_INSTANT::format)).color(InternalSpecUtils.mapPossible(this.color(), Color::getRGB)).footer(InternalSpecUtils.mapPossible(InternalSpecUtils.toPossible(this.footer()), EmbedCreateFields.Footer::asRequest)).image(InternalSpecUtils.mapPossible(this.image(), url -> EmbedImageData.builder().url((String)url).build())).thumbnail(InternalSpecUtils.mapPossible(this.thumbnail(), url -> EmbedThumbnailData.builder().url((String)url).build())).author(InternalSpecUtils.mapPossible(InternalSpecUtils.toPossible(this.author()), EmbedCreateFields.Author::asRequest)).fields(this.fields().stream().map(EmbedCreateFields.Field::asRequest).collect(Collectors.toList())).build();
    }
}

